/*
 * Copyright 2010-2016 Nicolas Debeissat and other contributors,
 * http://debeissat.nicolas.free.fr/
 *
 * This software consists of voluntary contributions made by multiple individuals.
 * For exact contribution history, see the revision history available at
 * https://github.com/ndebeiss/jsXmlSaxParser
 *
 * --------------------------------------------------------------------------------
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *
 * --------------------------------------------------------------------------------
 *
 * This software bundles a number of components and libraries with separate
 * copyright notices and license terms, including the ones below. We recommend you
 * read them, as their terms may differ from the terms above.
 *
 * JsUnit (http://www.jsunit.net/)
 *   License: MPL 1.1, GPL 2.0, or LGPL 2.1 (See jsunit/licenses/index.html)
 *
 * XML W3C Conformance Test Suite (https://www.w3.org/XML/Test/)
 *   License: See LICENSES FOR W3C TEST SUITES at
 *   https://www.w3.org/Consortium/Legal/2008/04-testsuite-copyright.html
 */
function Reader(a){a&&(this.lock=a)}function StringReader(a){this.s=a,this.nextIdx=0,this.markIdx=0,this.length=a.length}function ReaderWrapper(a){this.reader=a,this.peeked=[]}!function(){function b(a,b){this.message=a,this.exception=b}function c(a){this.message=a||""}function d(a){this.message=a||""}function e(a,b){this.message=a||"",this.locator=b}function f(c,d,e,f,g,h,i,j){if(this.contentHandler=c,this.locator=i,this.locator&&(this.locator.columnNumber=-1,this.locator.lineNumber=-1,this.locator.publicId=null,this.locator.systemId=null,this.locator.version=null,this.locator.encoding=null,this.contentHandler.setDocumentLocator(i)),this.dtdHandler=g,this.errorHandler=e,this.entityResolver=h||null,"function"!=typeof a.AttributesImpl)throw new b("you must import an implementation of AttributesImpl, like AttributesImpl.js, in the html");try{this.namespaceSupport=new NamespaceSupport}catch(a){throw new b("you must import an implementation of NamespaceSupport, like NamespaceSupport.js, in the html",a)}this.disallowedGetProperty=[],this.disallowedGetFeature=[],this.disallowedSetProperty=[],this.disallowedSetFeature=[],this.disallowedSetPropertyValues={},this.disallowedSetFeatureValues={},this.features={},this.features["http://xml.org/sax/features/external-general-entities"]=!1,this.features["http://xml.org/sax/features/external-parameter-entities"]=!1,this.features["http://xml.org/sax/features/is-standalone"]=void 0,this.features["http://xml.org/sax/features/lexical-handler/parameter-entities"]=!1,this.features["http://xml.org/sax/features/namespaces"]=!0,this.features["http://xml.org/sax/features/namespace-prefixes"]=!1,this.features["http://xml.org/sax/features/resolve-dtd-uris"]=!0,this.features["http://xml.org/sax/features/string-interning"]=!0,this.features["http://xml.org/sax/features/unicode-normalization-checking"]=!1,this.features["http://xml.org/sax/features/use-attributes2"]=!0,this.features["http://xml.org/sax/features/use-locator2"]=!(!i||"function"!=typeof i.getXMLVersion||"function"!=typeof i.getEncoding),this.features["http://xml.org/sax/features/use-entity-resolver2"]=!0,this.features["http://xml.org/sax/features/validation"]=!1,this.features["http://xml.org/sax/features/xmlns-uris"]=!1,this.features["http://xml.org/sax/features/xml-1.1"]=!1,this.features["http://apache.org/xml/features/nonvalidating/load-external-dtd"]=!1,this.features["http://debeissat.nicolas.free.fr/ns/character-data-strict"]=!1,this.features["http://debeissat.nicolas.free.fr/ns/instance-augmentation"]=!1,this.features["http://debeissat.nicolas.free.fr/ns/attribute-whitespace-normalization"]=!1,this.properties={},this.properties["http://xml.org/sax/properties/declaration-handler"]=this.declarationHandler=f,this.properties["http://xml.org/sax/properties/document-xml-version"]=null,this.properties["http://xml.org/sax/properties/dom-node"]=this.domNode=j,this.properties["http://xml.org/sax/properties/lexical-handler"]=this.lexicalHandler=d||null,this.properties["http://xml.org/sax/properties/xml-string"]=null}function j(){throw"XMLReaderFactory is not meant to be instantiated"}var a=this;b.prototype=new Error,b.constructor=b,b.prototype.getMessage=function(){return this.message},b.prototype.getException=function(){return this.exception},c.prototype=new b,c.constructor=c,d.prototype=new b,d.constructor=d,e.prototype=new b,e.constructor=e,e.prototype.getColumnNumber=function(){if(this.locator)return this.locator.getColumnNumber()},e.prototype.getLineNumber=function(){if(this.locator)return this.locator.getLineNumber()},e.prototype.getPublicId=function(){if(this.locator)return this.locator.getPublicId()},e.prototype.getSystemId=function(){if(this.locator)return this.locator.getSystemId()},f.prototype.toString=function(){return"SAXParser"},f.prototype.getContentHandler=function(){return this.contentHandler},f.prototype.getDTDHandler=function(){return this.dtdHandler},f.prototype.getEntityResolver=function(){return this.entityResolver},f.prototype.getErrorHandler=function(){return this.errorHandler},f.prototype.getFeature=function(a){if(void 0===this.features[a])throw new d;if(this.disallowedGetFeature.indexOf(a)!==-1)throw new c;return this.features[a]},f.prototype.getProperty=function(a){if(void 0===this.properties[a])throw new d;if(this.disallowedGetProperty.indexOf(a)!==-1)throw new c;return this.properties[a]},f.prototype.parse=function(b,c){var d,e,g;if("function"==typeof a.InputSource&&b instanceof InputSource){var h=b.getCharacterStream(),i=b.getByteStream();if(d=b.getSystemId(),h){if(!(h instanceof StringReader))throw"A character stream InputSource is not implemented at present unless it is a StringReader character stream (and that only if it is our own version which has the string on the 's' property)";e=h.s}else if((i||d)&&(this.encoding=b.getEncoding(),i))throw"A byte stream InputSource is not implemented at present in SAXParser's parse() method";if(!d&&!e)throw"The SAXParser parse() method must, at present, take an InputSource with a systemId or with a StringReader character stream"}else{if("string"!=typeof b)throw"The argument supplied to SAXParser's parse() method was invalid";d=b}this.systemId=d,e||(c&&(d+=(d.indexOf("?")===-1?"?":"&")+"_saxQuertyTime="+(new Date).getTime()),e=f.loadFile(d),g=d.substring(0,d.lastIndexOf("/")+1),this.baseURI=g),this.parseString(e)},f.prototype.parseString=function(a){var b=new StringReader(a),c=new ReaderWrapper(b);this.initReaders(c,b),this.saxScanner.parse(c)},f.prototype.initReaders=function(a,b){var c=new XMLFilterImpl2(this);this.saxScanner=new SAXScanner(this,c),this.saxScanner.namespaceSupport=this.namespaceSupport,this.features["http://debeissat.nicolas.free.fr/ns/character-data-strict"]?this.saxScanner.CHAR_DATA_REGEXP=new RegExp(this.saxScanner.NOT_CHAR+"|[<&\\]]"):this.saxScanner.CHAR_DATA_REGEXP=/[<&\]]/,this.features["http://apache.org/xml/features/nonvalidating/load-external-dtd"]||(this.saxScanner.loadExternalDtd=function(a){}),this.features["http://xml.org/sax/features/validation"]&&(this.features["http://debeissat.nicolas.free.fr/ns/instance-augmentation"]=!0,c.endDocument=this.endDocument_validating),this.features["http://debeissat.nicolas.free.fr/ns/attribute-whitespace-normalization"]&&(c.attWhitespaceNormalize=f.attWhitespaceNormalize,this.features["http://debeissat.nicolas.free.fr/ns/instance-augmentation"]&&(c.attWhitespaceCollapse=f.attWhitespaceCollapse)),this.features["http://debeissat.nicolas.free.fr/ns/instance-augmentation"]&&(c.startDocument=this.startDocument_augmenting,c.startDTD=this.startDTD_augmenting,c.elementDecl=this.elementDecl_augmenting,c.attributeDecl=this.attributeDecl_augmenting,this.features["http://xml.org/sax/features/validation"]?(c.augmenting_elm=this.augmenting_elm,c.startElement=this.startElement_validating):(c.augmenting_elm=this.augmenting_elm,c.startElement=this.startElement_augmenting),c.endElement=this.endElement_augmenting,c.characters=this.characters_augmenting),this.features["http://xml.org/sax/features/use-entity-resolver2"]&&(c.resolveEntity=this.resolveEntity),this.features["http://xml.org/sax/features/use-attributes2"]?this.getAttributesInstance=this.getAttributes2Instance:this.getAttributesInstance=this.getAttributes1Instance,this.contentHandler.locator&&(this.contentHandler.locator.reader=b,this.contentHandler.locator.setSystemId(this.systemId),c.startDTDOld=c.startDTD,c.startDTD=function(a,b,c){return this.getContentHandler().locator.setPublicId(a),this.startDTDOld(a,b,c)},this.contentHandler.locator.getColumnNumberOld=this.contentHandler.locator.getColumnNumber,this.contentHandler.locator.getLineNumberOld=this.contentHandler.locator.getLineNumber,this.contentHandler.locator.getColumnNumber=function(){var a=this.reader.nextIdx-this.reader.s.substring(0,this.reader.nextIdx).lastIndexOf("\n");return this.setColumnNumber(a),this.getColumnNumberOld()},this.contentHandler.locator.getLineNumber=function(){var a=this.reader.s.substring(0,this.reader.nextIdx).split("\n").length;return this.setLineNumber(a),this.getLineNumberOld()}),c.warning=this.warning,c.error=this.error,c.fatalError=this.fatalError},f.prototype.setHandler=function(a){this.contentHandler=a,this.lexicalHandler=a,this.errorHandler=a,this.declarationHandler=a,this.dtdHandler=a,this.entityResolver=a},f.prototype.setContentHandler=function(a){this.contentHandler=a},f.prototype.setDTDHandler=function(a){this.dtdHandler=a},f.prototype.setEntityResolver=function(a){this.entityResolver=a},f.prototype.setErrorHandler=function(a){this.errorHandler=a},f.prototype.setFeature=function(a,b){if(void 0===this.features[a])throw new d;if(void 0!==this.disallowedSetFeatureValues[a]&&this.disallowedSetFeatureValues[a]===b||this.disallowedSetFeature.indexOf(a)!==-1)throw new c;this.features[a]=b},f.prototype.setProperty=function(a,b){if(void 0===this.properties[a])throw new d;if(void 0!==this.disallowedSetPropertyValues[a]&&this.disallowedSetPropertyValues[a]===b||this.disallowedSetProperty.indexOf(a)!==-1)throw new c;switch(this.properties[a]=b,a){case"http://xml.org/sax/properties/lexical-handler":this.lexicalHandler=b;break;case"http://xml.org/sax/properties/declaration-handler":this.declarationHandler=b;break;case"http://xml.org/sax/properties/dom-node":this.domNode=b}},f.prototype.getAttributes2Instance=function(){return new Attributes2Impl},f.prototype.getAttributes1Instance=function(){return new AttributesImpl},f.prototype.startDocument_augmenting=function(){this.elements={},this.instanceContext=new Context("",[]);var a=new DatatypeLibrary;return this.debug=!1,this.validatorFunctions=new ValidatorFunctions(this,a),this.parent.contentHandler.startDocument.call(this.parent.contentHandler)},f.prototype.startDTD_augmenting=function(a,b,c){if(this.pattern=this.elements[a]=new Element(new Name(null,a)),this.context=new Context(b,[]),this.parent&&this.parent.lexicalHandler)return this.parent.lexicalHandler.startDTD.call(this.parent.lexicalHandler,a,b,c)},f.getPatternFromMixed=function(a,b){var c,d=/^\( ?#PCDATA ?(\|.*) ?\)\*$/.exec(a);if(null!==d){for(var e=d[1].replace(/ /g,""),f=e.split("|"),g=f.length-1;g>0;g--){var h=f[g];b.elements[h]||(b.elements[h]=new Element(new Name(null,h))),c=c?new Group(b.elements[h],c):b.elements[h]}return new Choice(new Empty,new OneOrMore(new Choice(new Text,c)))}return new Text};var g=":A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u0200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\ud800-\udbff\udc00-\udfff",h=".0-9\u00B7\u0300-\u036F\u203F-\u2040-",i=new RegExp("(["+g+"]["+g+h+"]*)([*+?])? ?(([,|])?(.*))?");f.getPatternFromChildren=function(a,b){var c=/^\( ?(.*) ?\)([*+?]?)$/.exec(a);if(null!=c){var d=c[1],e=c[2],g=f.getPatternFromChildren(d,b);switch(e){case"?":g=new Choice(g,new Empty);break;case"+":g=new OneOrMore(g);break;case"*":g=new Choice(new Empty,new OneOrMore(g))}return g}var h=i.exec(a),j=h[1],e=h[2],k=h[4],d=h[5];b.elements[j]||(b.elements[j]=new Element(new Name(null,j)));var g;switch(e){case"?":g=new Choice(b.elements[j],new Empty);break;case"+":g=new OneOrMore(b.elements[j]);break;case"*":g=new Choice(new Empty,new OneOrMore(b.elements[j]));break;default:g=b.elements[j]}if(d)var l=f.getPatternFromChildren(d,b);return l&&(g="|"===k?new Choice(g,l):new Group(g,l)),g},f.getPatternFromModel=function(a,b){if("EMPTY"===a)return new Empty;if("ANY"===a)return new Choice(new Empty,new OneOrMore(new Element(new AnyName)));var c;return c=/^\( ?#PCDATA/.test(a)?f.getPatternFromMixed(a,b):f.getPatternFromChildren(a,b)},f.prototype.elementDecl_augmenting=function(a,b){var c=f.getPatternFromModel(b,this),d=this.elements[a];if(d?d.pattern?c instanceof Text?d.pattern=new Interleave(d.pattern,c):d.pattern=new Group(d.pattern,c):d.pattern=c:d=this.elements[a]=new Element(new Name(null,a),c),this.parent&&this.parent.declarationHandler)return this.parent.declarationHandler.elementDecl.call(this.parent.declarationHandler,a,b)},f.attWhitespaceNormalize=function(a){return a=a.replace(/\r\n/g," "),a.replace(/[\t\n\r]/g," ")},f.attWhitespaceCollapse=function(a,b){return"string"!==a&&(b=b.replace(/\s+/g," "),b=b.replace(/^\s/,"").replace(/\s$/,"")),b},f.addAttributesIn=function(a,b){a&&(a instanceof Choice?(f.addAttributesIn(a.pattern1,b),f.addAttributesIn(a.pattern2,b)):a instanceof Interleave?(f.addAttributesIn(a.pattern1,b),f.addAttributesIn(a.pattern2,b)):a instanceof Group?(f.addAttributesIn(a.pattern1,b),f.addAttributesIn(a.pattern2,b)):a instanceof Attribute&&b.push(a))},f.augmentAttributes=function(a,b){b&&(b instanceof Choice?(f.augmentAttributes(a,b.pattern1),f.augmentAttributes(a,b.pattern2)):b instanceof Interleave?(f.augmentAttributes(a,b.pattern1),f.augmentAttributes(a,b.pattern2)):b instanceof Group?(f.augmentAttributes(a,b.pattern1),f.augmentAttributes(a,b.pattern2)):b instanceof Attribute&&a.addAttribute(b))},f.isAlreadyDeclared=function(a,b){for(var c=0;c<b.length;c++){var d=b[c].nameClass;if(d.localName&&d.localName===a)return!0}return!1},f.prototype.attributeDecl_augmenting=function(a,b,c,d,e){var g=this.elements[a],h=[];if(g?f.addAttributesIn(g.pattern,h):g=this.elements[a]=new Element(new Name(null,a)),f.isAlreadyDeclared(b,h))this.warning("attribute : ["+b+"] under element : ["+a+"] is already declared",this.parent.saxScanner);else{var i;i="NMTOKENS"===c||"NMTOKEN"===c?new Datatype("http://www.w3.org/2001/XMLSchema-datatypes",c):new Datatype("http://www.w3.org/2001/XMLSchema-datatypes","string");var j=[];if(/^\(.+\)$/.test(c))for(var k=c.replace(/^\(/,"").replace(/\)$/,""),l=k.split("|"),m=l.length;m--;)j.push(new Param("enumeration",l[m]));var n=new Attribute(new Name(null,b),new Data(i,j));if(n.index=h.length,"#REQUIRED"!==d){if(e){var o=f.attWhitespaceCollapse(c,e);n.defaultValue=new Value(i,o,this.context)}n=new Choice(n,new Empty)}if(g.pattern){var p=new Group(g.pattern,n);g.pattern=p}else g.pattern=n}if(this.parent&&this.parent.declarationHandler)return this.parent.declarationHandler.attributeDecl.call(this.parent.declarationHandler,a,b,c,d,e)},f.prototype.augmenting_elm=function(a,b,c,d){for(var e=[],f=0;f<d.getLength();f++){var g=new AttributeNode(new QName(d.getURI(f),d.getLocalName(f)),d.getValue(f));g.atts=d,g.index=f,g.attWhitespaceCollapse=this.attWhitespaceCollapse,g.setType=function(a){if(this.atts.setType(this.index,a),this.attWhitespaceCollapse){var b=this.atts.getValue(this.index),c=this.attWhitespaceCollapse(a,b);this.atts.setValue(this.index,c)}this.atts.setDeclared&&(this.atts.setDeclared(this.index,!0),this.atts.setSpecified(this.index,!0))},e.push(g)}var h=new ElementNode(new QName(a,b),this.instanceContext,e,[]);h.atts=d,h.addAttribute=function(a){var b=a.nameClass,c=null;(a.pattern instanceof Data||a.pattern instanceof DataExcept)&&(c=a.pattern.datatype.localName);var f,e=a.defaultValue.string;void 0!==a.index&&this.atts.addAttributeAtIndex?(f=a.index,this.atts.addAttributeAtIndex(a.index,b.uri,b.localName,b.localName,c,e)):(f=d.getLength(),this.atts.addAttribute(b.uri,b.localName,b.localName,c,e)),d.setDeclared&&(d.setDeclared(f,!0),d.setSpecified(f,!1)),this.attributeNodes.push(new AttributeNode(b,e))},this.childNode?(this.currentElementNode.childNodes.push(h),h.setParentNode(this.currentElementNode),this.currentElementNode=h):this.childNode=this.currentElementNode=h},f.prototype.startElement_augmenting=function(a,b,c,d){if(this.context){this.augmenting_elm(a,b,c,d);var e=this.elements[b];e&&f.augmentAttributes(this.currentElementNode,e.pattern)}return this.parent.contentHandler.startElement.call(this.parent.contentHandler,a,b,c,d)},f.prototype.startElement_validating=function(a,b,c,d){if(this.context&&(this.augmenting_elm(a,b,c,d),this.resultPattern=this.validatorFunctions.childDeriv(this.context,this.pattern,this.childNode),this.resultPattern instanceof NotAllowed&&!(this.resultPattern instanceof MissingContent))){var e="document not valid, message is : ["+this.resultPattern.message+"]";this.resultPattern.pattern&&(e+=", expected was : ["+this.resultPattern.pattern.toHTML()+"], found is : ["+this.resultPattern.childNode.toHTML()+"]"),this.warning(e)}return this.parent.contentHandler.startElement.call(this.parent.contentHandler,a,b,c,d)},f.prototype.endElement_augmenting=function(a,b,c){return this.currentElementNode&&this.currentElementNode.parentNode&&(this.currentElementNode=this.currentElementNode.parentNode),this.parent.contentHandler.endElement.call(this.parent.contentHandler,a,b,c)},f.prototype.characters_augmenting=function(a,b,c){if(this.context){var d=new TextNode(a);this.currentElementNode.childNodes.push(d)}return this.parent.contentHandler.characters.call(this.parent.contentHandler,a,b,c)},f.prototype.endDocument_validating=function(){if(this.pattern&&(this.resultPattern=this.validatorFunctions.childDeriv(this.context,this.pattern,this.childNode),this.resultPattern instanceof NotAllowed)){var a=this.resultPattern.childNode;throw a.toHTML&&(a=a.toHTML()),new b("document not valid, message is : ["+this.resultPattern.message+"], expected was : ["+this.resultPattern.pattern.toHTML()+"], found is : ["+a+"]")}return this.parent.contentHandler.endDocument.call(this.parent.contentHandler)},f.loadFile=function(a){var c=null;if(window.XMLHttpRequest?c=new XMLHttpRequest:window.ActiveXObject&&(c=new ActiveXObject("Microsoft.XMLHTTP")),null===c)throw new b("Your browser does not support XMLHTTP, the external entity with URL : ["+a+"] will not be resolved");return c.open("GET",a,!1),c.send(null),4===c.readyState&&c.responseText},f.prototype.resolveEntity=function(a,b,c,d){var e;return e=c?f.loadFile(c+d):f.loadFile(d),e?e=e.replace(/\r\n/g,"\n").replace(/\r/g,"\n"):""},f.getSAXParseException=function(a,b,c){var d=new e(a,b);return d},f.prototype.warning=function(a,b){var c=f.getSAXParseException(a,this.parent.contentHandler.locator,b);this.parent&&this.parent.errorHandler&&this.parent.errorHandler.warning.call(this.parent.errorHandler,c)},f.prototype.error=function(a,b){var c=f.getSAXParseException(a,this.parent.contentHandler.locator,b);this.parent&&this.parent.errorHandler&&this.parent.errorHandler.error.call(this.parent.errorHandler,c)},f.prototype.fatalError=function(a,b){var c=f.getSAXParseException(a,this.parent.contentHandler.locator,b);throw this.parent&&this.parent.errorHandler&&this.parent.errorHandler.fatalError.call(this.parent.errorHandler,c),c},j.createXMLReader=function(b){return b?new a[b]:new f},j.getSaxImport=function(){if(!a.saxImport)for(var b=document.getElementsByTagName("script"),c=0;c<b.length;c++){var d=b.item(c),e=d.getAttribute("src");if(e&&e.match("sax.js"))return a.saxImport=d,a.saxImport}return a.saxImport},j.getJsPath=function(){if(void 0===a.jsPath){var b=j.getSaxImport();if(b){var c=b.getAttribute("src");a.jsPath=c.substring(0,c.lastIndexOf("/")+1)}}return a.jsPath},j.importJS=function(a){var c=j.getSaxImport();if(void 0===c)throw new b("could not find script markup importing sax.js in the document");var d=j.getJsPath();if(void 0===d)throw new b("could not get path of sax.js from the script markup");var e=document.createElement("script");e.setAttribute("src",d+a),e.setAttribute("type","text/javascript"),c.parentNode.insertBefore(e,c)},j.checkDependencies=function(){if("function"!=typeof a.SAXScanner)try{this.importJS("SAXScanner.js")}catch(a){throw new b("implementation of SAXScanner, like SAXScanner.js, not provided and could not be dynamically loaded because of exception",a)}if("function"!=typeof a.AttributesImpl)try{this.importJS("AttributesImpl.js")}catch(a){throw new b("implementation of Attributes, like AttributesImpl.js, not provided and could not be dynamically loaded because of exception",a)}if("function"!=typeof a.NamespaceSupport)try{this.importJS("NamespaceSupport.js")}catch(a){throw new b("implementation of NamespaceSupport, like NamespaceSupport.js, not provided and could not be dynamically loaded because of exception",a)}if("function"!=typeof a.XMLFilterImpl)try{this.importJS("XMLFilterImpls.js")}catch(a){throw new b("implementation of XMLFilterImpl, like XMLFilterImpls.js, not provided and could not be dynamically loaded because of exception",a)}if("function"!=typeof a.Reader)try{this.importJS("Reader.js")}catch(a){throw new b("implementation of Reader, like Reader.js, not provided and could not be dynamically loaded because of exception",e5)}if("function"!=typeof a.ReaderWrapper)try{this.importJS("ReaderWrapper.js")}catch(a){throw new b("implementation of ReaderWrapper.js, like ReaderWrapper.js, not provided and could not be dynamically loaded because of exception",e6)}},this.SAXParser=f,this.SAXException=b,this.SAXNotSupportedException=c,this.SAXNotRecognizedException=d,this.SAXParseException=e,this.XMLReaderFactory=j;}(),function(){function J(){}function K(a){this.entityName=a}function L(a){this.entityName=a}function M(a,b){this.prefix=a,this.localName=b,a?this.qName=a+":"+b:this.qName=b}function N(){this.publicId=null,this.systemId=null}function O(a,b){this.saxParser=a,this.saxEvents=b,this.NOT_CHAR=u}var a=0,b=1,c=2,d=3,e=4,f=5,g=6,h=["1.0","1.1"],i=/^1\.\d+$/,j=/^[A-Za-z]([A-Za-z0-9._]|-)*$/,k=/^yes$|^no$/,l=":A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u0200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\ud800-\udbff\udc00-\udfff",m=new RegExp("[^"+l+"]"),n=".0-9\u00B7\u0300-\u036F\u203F-\u2040-",o=new RegExp("[^"+l+n+"]"),p="\ud800-\udbff",q="\udc00-\udfff",r=new RegExp("["+p+"]"),s=new RegExp("["+q+"]"),t="\u0009\u000A\u000D\u0020-\uD7FF\uE000-\uFFFD",u="[^"+t+"]",v=new RegExp(u),w=function(){if(this.reader.peek().search(r)!==-1){var a=this.reader.peek();return this.reader.nextChar(!0),this.reader.peek().search(s)!==-1||this.saxEvents.fatalError("invalid XML character, high surrogate, decimal code number '"+a.charCodeAt(0)+"' not immediately followed by a low surrogate",this)}return this.saxEvents.fatalError("invalid XML character, decimal code number '"+this.reader.peek().charCodeAt(0)+"'",this)},x={pattern:v,cb:w},y="\\t\\n\\r ",z="["+y+"]",A=new RegExp(z),B=new RegExp("[^"+y+"]"),C="^<\\?xml"+z,D=new RegExp(C),E=new RegExp("^xml("+z+"|\\?)","i"),F=/^amp$|^lt$|^gt$|^quot$/,G=/^apos$/,H=/^"$|^'$/,I={};I["'"]="&apos;",I['"']="&quot;",J.prototype.toString=function(){return"EndOfInputException"},K.prototype.toString=function(){return"EntityNotReplacedException"},L.prototype.toString=function(){return"InternalEntityNotFoundException"},L.prototype=new SAXParseException,L.constructor=L,M.prototype.equals=function(a){return this.qName===a.qName},N.prototype.toString=function(){return"ExternalId"},O.prototype.toString=function(){return"SAXScanner"},O.prototype.init=function(){this.state=a,this.elementsStack=[],this.namespaceSupport.reset(),this.entities={},this.parameterEntities={},this.externalEntities={},this.currentEntities=[],this.relativeBaseUris=[]},O.prototype.parse=function(a){this.init();try{this.reader=a,this.saxEvents.startDocument(),this.startParsing(),this.state=b,this.continueParsing()}catch(a){if(!(a instanceof J))throw a;if(this.elementsStack.length>0)this.saxEvents.fatalError("the markup "+this.elementsStack.pop()+" has not been closed",this);else try{this.saxEvents.endDocument()}catch(a){throw a}}},O.prototype.startParsing=function(){try{this.reader.peek()}catch(a){if(!(a instanceof J))throw a;this.saxEvents.fatalError("empty document",this)}if(!this.scanXMLDeclOrTextDecl())try{this.reader.skipWhiteSpaces()}catch(a){if(!(a instanceof J))throw a;this.saxEvents.fatalError("empty document",this)}},O.prototype.continueParsing=function(){for(;;)this.next()},O.prototype.next=function(){0===this.elementsStack.length?(this.reader.skipWhiteSpaces(),this.reader.matchChar("<")?this.scanMarkup():(this.reader.nextChar(),this.saxEvents.fatalError("can not have text at root level of the XML",this))):this.reader.matchChar("<")?this.scanMarkup():this.scanText()},O.prototype.scanMarkup=function(){this.state===b?this.reader.matchChar("!")?this.scanComment()||this.scanDoctypeDecl()&&(this.state=d):this.reader.matchChar("?")?this.scanPI():(this.state=e,this.scanMarkup()):this.state===d?this.reader.matchChar("!")?this.scanComment()||(this.reader.matchStr("DOCTYPE")?this.saxEvents.fatalError("can not have two doctype declarations",this):this.saxEvents.fatalError("invalid declaration, only a comment is allowed here after &lt;!",this)):this.reader.matchChar("?")?this.scanPI():(this.state=e,this.scanMarkup()):this.state===e?this.scanElement()?this.elementsStack.length>0?this.state=f:this.state=g:this.saxEvents.fatalError("document is empty, no root element detected",this):this.state===f?this.reader.matchChar("!")?this.scanComment()||this.scanCData()||this.saxEvents.fatalError("neither comment nor CDATA after &lt;!",this):this.reader.matchChar("?")?this.scanPI():this.reader.matchChar("/")?this.scanEndingTag()&&0===this.elementsStack.length&&(this.state=g):this.scanElement()||this.saxEvents.fatalError("not valid markup",this):this.state===g&&(this.reader.matchChar("!")?this.scanComment()||this.saxEvents.fatalError("end of document, only comments or processing instructions are allowed",this):this.reader.matchChar("?")?this.scanPI()||this.saxEvents.fatalError("end of document, only comment or processing instruction are allowed",this):this.reader.matchChar("/")?this.saxEvents.fatalError("invalid ending tag at root of the document",this):this.saxEvents.fatalError("only one document element is allowed",this))},O.prototype.scanText=function(){for(var a=this.scanCharData();this.reader.matchChar("&");){try{var b=this.scanRef();b&&(a+=b)}catch(b){if(b instanceof K)a+="&"+b.entityName+";";else{if(!(b instanceof L))throw b;var c=this.externalEntities[b.entityName];void 0===c?this.saxEvents.error("entity : ["+b.entityName+"] not declared as an internal entity or as an external one",this):this.includeEntity(b.entityName,c)}}a+=this.scanCharData()}a=a.replace(/\r\n/g,"\n"),a.search(B)===-1?this.saxEvents.ignorableWhitespace(a,0,a.length):this.saxEvents.characters(a,0,a.length)},O.prototype.scanCharData=function(){for(var a=this.reader.nextCharRegExp(this.CHAR_DATA_REGEXP,x);this.reader.matchChar("]");)this.reader.matchStr("]>")&&this.saxEvents.error("Text must not contain a literal ']]&gt;' sequence",this),a+="]"+this.reader.nextCharRegExp(this.CHAR_DATA_REGEXP,x);return a},O.prototype.getRelativeBaseUri=function(){for(var a=this.saxParser.baseURI,b=this.relativeBaseUris.length;b--;)a+=this.relativeBaseUris[b];return a},O.prototype.includeEntity=function(a,b){if(b instanceof N)try{var d=this.saxEvents.resolveEntity(a,b.publicId,this.saxParser.baseURI,b.systemId);if(void 0!==d){d.search(new RegExp("&"+a+";"))!==-1&&this.saxEvents.fatalError("Recursion detected : ["+a+"] contains a reference to itself",this),this.includeText(d);var e=this.state;this.state=c,this.reader.matchRegExp(6,D,!0)&&this.startParsing(),this.state=e}}catch(c){this.saxEvents.error("issue at resolving entity : ["+a+"], publicId : ["+b.publicId+"], uri : ["+this.saxParser.baseURI+"], systemId : ["+b.systemId+"], got exception : ["+c.toString()+"]",this)}else b.search(new RegExp("&"+a+";"))!==-1&&this.saxEvents.fatalError("Recursion detected : ["+a+"] contains a reference to itself",this),this.includeText(b)},O.prototype.includeText=function(a){this.reader.unread(a)},O.prototype.scanRef=function(){return this.reader.matchChar("#")?this.scanCharRef():void this.scanEntityRef()},O.prototype.scanComment=function(){if(this.reader.matchChar("-")){if(this.reader.matchChar("-")){for(var a=this.reader.nextCharRegExp(new RegExp(u+"|-"),x);this.reader.matchChar("-")&&!this.reader.matchStr("->");){if(this.reader.matchChar("-"))return this.saxEvents.fatalError("end of comment not valid, must be --&gt;",this);a+="-"+this.reader.nextCharRegExp(new RegExp(u+"|-"),x)}return this.saxEvents.comment(a,0,a.length),!0}return this.saxEvents.fatalError("beginning comment markup is invalid, must be &lt;!--",this)}return!1},O.prototype.setEncoding=function(a){this.saxParser.contentHandler.locator&&this.saxParser.contentHandler.locator.setEncoding(this.encoding||a)},O.prototype.setXMLVersion=function(a){a&&(h.indexOf(a)===-1?this.saxEvents.fatalError("The specified XML Version is not a presently valid XML version number",this):"1.1"===a&&this.saxParser.features["http://xml.org/sax/features/xml-1.1"]===!1&&this.saxEvents.fatalError("The XML text specifies version 1.1, but this parser does not support this version.",this),this.saxParser.properties["http://xml.org/sax/properties/document-xml-version"]=a,this.saxParser.contentHandler.locator&&this.saxParser.contentHandler.locator.setXMLVersion(a))},O.prototype.scanXMLDeclOrTextDeclAttribute=function(a,b,c){if(this.reader.equals("?"))return!1;if(c&&this.reader.peek().search(A)===-1)return this.saxEvents.fatalError("The XML Declaration or Text Declaration must possess a space between the version/encoding/standalone information.",this);this.reader.skipWhiteSpaces();var d=this.scanName(),e=a.indexOf(d);if(e===-1)return["version","encoding","standalone"].indexOf(d)!==-1?this.saxEvents.fatalError('The attribute name "'+d+'" was not expected at this position in an XML or text declaration. It was expected to be: '+a.join(", "),this):this.saxEvents.fatalError('The attribute name "'+d+'" does not match the allowable names in an XML or text declaration: '+a.join(", "),this);if(this.reader.skipWhiteSpaces(),!this.reader.matchChar("="))return this.saxEvents.fatalError("invalid declaration attribute, must contain = between name and value",this);if(this.reader.skipWhiteSpaces(),!this.reader.equals('"')&&!this.reader.equals("'"))return this.saxEvents.fatalError("invalid declaration attribute value declaration, must begin with a quote",this);try{var f=this.reader.quoteContent();if(f.search(b[e])===-1)return this.saxEvents.fatalError('The attribute value "'+f+'" does not match the allowable values in an XML or text declaration: '+b[e],this)}catch(a){if(a instanceof J)return this.saxEvents.fatalError("document incomplete, attribute value declaration must end with a quote",this);throw a}return[d,f]},O.prototype.scanXMLDeclOrTextDecl=function(){var b=null,c="UTF-8";if(this.reader.matchRegExp(6,D)){var d=!1;if(this.state===a){var e=this.scanXMLDeclOrTextDeclAttribute(["version"],[i]);if(!e)return this.saxEvents.fatalError("An XML Declaration must have version information",this);b=e[1],this.setXMLVersion(b);var f=this.scanXMLDeclOrTextDeclAttribute(["encoding","standalone"],[j,k],!0);if(f&&"encoding"===f[0]){c=f[1],this.setEncoding(c);var g=this.scanXMLDeclOrTextDeclAttribute(["standalone"],[k],!0);g&&"yes"===g&&(d=!0)}this.saxParser.features["http://xml.org/sax/features/is-standalone"]=d}else{var h=this.scanXMLDeclOrTextDeclAttribute(["version","encoding"],[i,j]);if("version"===h[0]&&(b=h[1],this.setXMLVersion(b),h=this.scanXMLDeclOrTextDeclAttribute(["encoding"],[j],!0)),!h)return this.saxEvents.fatalError("A text declaration must possess explicit encoding information",this);c=h[1],this.setEncoding(c)}return this.reader.skipWhiteSpaces(),this.reader.unequals("?")?this.saxEvents.fatalError("invalid markup, '"+this.reader.peek()+"', in XML or text declaration where '?' expected",this):(this.reader.nextChar(!0),this.reader.unequals(">")?this.saxEvents.fatalError("invalid markup inside XML or text declaration; must end with &gt;",this):(this.reader.nextChar(),!0))}return this.state===a&&(this.setXMLVersion("1.0"),this.saxParser.contentHandler.locator&&this.saxParser.contentHandler.locator.setEncoding(c),this.saxParser.features["http://xml.org/sax/features/is-standalone"]=!1),!1},O.prototype.scanPI=function(){if(this.reader.matchRegExp(4,E))return this.saxEvents.fatalError("XML Declaration cannot occur past the very beginning of the document.",this);var a=this.scanName();this.reader.skipWhiteSpaces();for(var b=this.reader.nextCharRegExp(new RegExp(u+"|\\?"),x);this.reader.matchChar("?")&&!this.reader.matchChar(">");)b+="?"+this.reader.nextCharRegExp(new RegExp(u+"|\\?"),x);return this.saxEvents.processingInstruction(a,b),!0},O.prototype.loadExternalDtd=function(a){try{var b;b=this.saxParser.baseURI?this.saxParser.baseURI+a.systemId:a.systemId;var c=SAXParser.loadFile(b);this.scanExtSubset(c)}catch(b){this.saxEvents.warning("exception : ["+b.toString()+"] trying to load external subset : ["+this.saxParser.baseURI+a.systemId+"]",this);
}},O.prototype.scanDoctypeDecl=function(){if(this.reader.matchStr("DOCTYPE")){this.reader.skipWhiteSpaces();var a=this.reader.nextCharRegExp(/[ \[>]/);this.reader.skipWhiteSpaces();var b=new N;if(this.scanExternalId(b)&&this.reader.skipWhiteSpaces(),this.saxEvents.startDTD(a,b.publicId,b.systemId),this.reader.matchChar("[")){for(this.reader.skipWhiteSpaces();this.reader.unequals("]");)this.scanDoctypeDeclIntSubset(),this.reader.skipWhiteSpaces();this.reader.nextChar()}return null!==b.systemId&&this.loadExternalDtd(b),this.reader.unequals(">")?this.saxEvents.fatalError("invalid content in doctype declaration",this):(this.reader.nextChar(),this.saxEvents.endDTD(),!0)}return this.saxEvents.fatalError("invalid doctype declaration, must be &lt;!DOCTYPE",this)},O.prototype.scanExtSubset=function(a){if(a.search(B)!==-1){var b=this.reader;this.reader=new ReaderWrapper(new StringReader(a)),this.startParsing();try{for(;;)this.scanDoctypeDeclIntSubset(),this.reader.skipWhiteSpaces()}catch(a){if(!(a instanceof J))throw a}this.reader=b}},O.prototype.scanExternalId=function(a){return this.reader.matchStr("SYSTEM")?(this.reader.skipWhiteSpaces(),a.systemId=this.scanSystemLiteral(),!0):!!this.reader.matchStr("PUBLIC")&&(this.reader.skipWhiteSpaces(),a.publicId=this.scanPubIdLiteral(),this.reader.skipWhiteSpaces(),a.systemId=this.scanSystemLiteral(),!0)},O.prototype.scanSystemLiteral=function(a){return this.reader.unequals("'")&&this.reader.unequals('"')?this.saxEvents.fatalError("invalid sytem Id declaration, should begin with a quote",this):this.reader.quoteContent()},O.prototype.scanPubIdLiteral=function(a){return this.reader.unequals("'")&&this.reader.unequals('"')?this.saxEvents.fatalError("invalid Public Id declaration, should begin with a quote",this):this.reader.quoteContent()},O.prototype.includeParameterEntity=function(){var a=this.scanPeRef();if(a instanceof N)try{var b=this.saxEvents.resolveEntity(null,a.publicId,null,this.saxParser.baseURI+a.systemId);if(void 0!==b&&b.search(B)!==-1){this.includeText(b);var d=this.state;this.state=c,this.reader.matchRegExp(6,D,!0)&&this.startParsing(),this.state=d}}catch(b){this.saxEvents.error("issue at resolving entity : ["+entityName+"], publicId : ["+a.publicId+"], uri : ["+this.saxParser.baseURI+"], systemId : ["+a.systemId+"], got exception : ["+b.toString()+"]",this)}else this.includeText(" "+a+" ")},O.prototype.scanDoctypeDeclIntSubset=function(){this.reader.matchChar("<")?this.reader.matchChar("?")?this.scanPI()||this.saxEvents.fatalError("invalid processing instruction inside doctype declaration",this):this.reader.matchChar("!")&&(this.scanComment()?this.reader.skipWhiteSpaces():this.scanEntityDecl()||this.scanElementDecl()||this.scanAttlistDecl()||this.scanNotationDecl()||(this.reader.nextCharWhileNot(">"),this.reader.nextChar(!0))):this.reader.matchChar("%")?this.includeParameterEntity():this.saxEvents.fatalError("invalid character in internal subset of doctype declaration : ["+this.reader.peek()+"]",this)},O.prototype.scanEntityDecl=function(){var a,b,c;if(this.reader.matchStr("ENTITY")){if(this.reader.skipWhiteSpaces(),this.reader.matchChar("%"))if(this.reader.skipWhiteSpaces(),a=this.scanName(),this.reader.skipWhiteSpaces(),this.parameterEntities[a]){var d=this.reader.nextCharWhileNot(">");this.saxEvents.warning("entity : ["+a+"] is declared several times, only first value : ["+this.parameterEntities[a]+"] is effective, declaration : ["+d+"] is ignored")}else b=new N,this.scanExternalId(b)?this.parameterEntities[a]=b:(c=this.scanEntityValue(),this.parameterEntities[a]=c,this.saxEvents.internalEntityDecl("%"+a,c));else if(a=this.scanName(),this.reader.skipWhiteSpaces(),b=new N,this.scanExternalId(b)){if(this.reader.skipWhiteSpaces(),this.reader.matchStr("NDATA")){this.reader.skipWhiteSpaces();var e=this.scanName();this.saxEvents.unparsedEntityDecl(a,b.publicId,b.systemId,e)}void 0===this.externalEntities[a]?this.externalEntities[a]=b:this.saxEvents.warning("external entity : ["+a+"] is declared several times, only first value : ["+this.externalEntities[a]+"] is effective, declaration : ["+b+"] is ignored")}else c=this.scanEntityValue(),void 0===this.entities[a]?this.isEntityReferencingItself(a,c)?this.saxEvents.error("circular entity declaration, entity : ["+a+"] is referencing itself directly or indirectly",this):(this.entities[a]=c,this.saxEvents.internalEntityDecl(a,c)):this.saxEvents.warning("entity : ["+a+"] is declared several times, only first value : ["+this.entities[a]+"] is effective, declaration : ["+c+"] is ignored");return this.reader.nextChar(!0),!0}return!1},O.prototype.isEntityReferencingItself=function(a,b){var c=/^[^&]*&([^;]+);(.*)/.exec(b);if(null!==c){if(c[1]===a)return!0;var d=this.entities[c[1]];if(void 0!==d){var e=this.isEntityReferencingItself(a,d);return e||this.isEntityReferencingItself(a,c[2])}return this.isEntityReferencingItself(a,c[2])}return!1},O.prototype.scanEntityValue=function(){if(this.reader.equals('"')||this.reader.equals("'")){for(var a=this.reader.next(),b=new RegExp("["+a+"&%]"),c=this.reader.nextCharRegExp(b);;)if(this.reader.matchChar("%")){var d=this.scanPeRef();d instanceof N&&(d=this.saxEvents.resolveEntity(null,d.publicId,null,this.saxParser.baseURI+d.systemId)),c+=d+this.reader.nextCharRegExp(b)}else{if(!this.reader.matchChar("&"))break;if(this.reader.matchChar("#")){var e=this.scanCharRef();c+=e+this.reader.nextCharRegExp(b)}else c+="&"+this.reader.nextCharRegExp(b)}return/\uFFFF/.test(c)?this.saxEvents.fatalError("invalid entity declaration value, must not contain U+FFFF",this):(this.reader.nextChar(),c)}return this.saxEvents.error("invalid entity value declaration, must begin with a quote",this)},O.prototype.scanPeRef=function(a){try{a=this.reader.nextCharWhileNot(";"),this.reader.nextChar(!0);var b=this.parameterEntities[a];return void 0!==b?b:(this.saxEvents.fatalError("parameter entity reference : ["+a+"] has not been declared, no replacement found",this),"")}catch(a){if(a instanceof J)return this.saxEvents.fatalError("document incomplete, parameter entity reference must end with ;",this);throw a}},O.prototype.scanElementDecl=function(){if(this.reader.matchStr("ELEMENT")){this.reader.skipWhiteSpaces();var a=this.scanName();this.reader.skipWhiteSpaces();var b=this.scanContentModelDecl();return this.reader.nextChar(!0),this.saxEvents.elementDecl(a,b),!0}return!1},O.prototype.scanContentModelDecl=function(){for(var a=new RegExp("[%>]"),b=this.reader.nextCharRegExp(a);this.reader.matchChar("%");)this.includeParameterEntity(),b+=this.reader.nextCharRegExp(a);return b.replace(new RegExp(z+"+","g")," ")},O.prototype.scanAttlistDecl=function(){if(this.reader.matchStr("ATTLIST")){this.reader.skipWhiteSpaces(),this.reader.matchChar("%")&&(this.includeParameterEntity(),this.reader.skipWhiteSpaces());var a=this.scanName();for(this.reader.skipWhiteSpaces();this.reader.unequals(">");)this.scanAttDef(a);return this.reader.nextChar(!0),!0}return!1},O.prototype.scanAttDef=function(a){this.reader.matchChar("%")&&(this.includeParameterEntity(),this.reader.skipWhiteSpaces());var b=this.scanName();this.reader.skipWhiteSpaces();var c=this.scanAttType();this.reader.skipWhiteSpaces();var d=null;this.reader.equals("#")&&(d=this.reader.nextCharRegExp(new RegExp(z+"|>")),this.reader.skipWhiteSpaces());var e=null;if((null===d||"#FIXED"===d)&&(this.reader.matchChar("%")&&(this.includeParameterEntity(),this.reader.skipWhiteSpaces()),this.reader.equals('"')||this.reader.equals("'"))){var f=this.reader.next();e=this.reader.nextCharRegExp(new RegExp("["+f+"<]")),this.reader.equals("<")&&this.saxEvents.fatalError("invalid attribute value, must not contain &lt;",this),this.reader.nextChar()}this.saxEvents.attributeDecl(a,b,c,d,e)},O.prototype.scanAttType=function(){var a;if(this.reader.matchChar("(")){for(this.reader.skipWhiteSpaces(),a=this.reader.nextCharRegExp(o);this.reader.peek().search(A)!==-1;)this.reader.skipWhiteSpaces(),a+=this.reader.nextCharRegExp(o);this.reader.unequals(")")?(this.saxEvents.error("Invalid character : ["+this.reader.peek()+"] in ATTLIST enumeration",this),a+=this.reader.nextCharRegExp(A)):this.reader.nextChar(),a="("+a+")"}else if(this.reader.matchStr("NOTATION"))this.reader.skipWhiteSpaces(),this.reader.matchChar("(")?(this.reader.skipWhiteSpaces(),a=this.scanName(),this.reader.skipWhiteSpaces(),this.reader.unequals(")")&&this.saxEvents.error("Invalid character : ["+this.reader.peek()+"] in ATTLIST enumeration",this),this.reader.nextChar()):(this.saxEvents.error("Invalid NOTATION, must be followed by '('",this),this.reader.nextCharWhileNot(">"),this.reader.nextChar(!0)),a="NOTATION ("+a+")";else{var b=new RegExp("["+y+"%]");for(a=this.reader.nextCharRegExp(b);this.reader.matchChar("%");)this.includeParameterEntity(),a+=this.reader.nextCharRegExp(b);/^CDATA$|^ID$|^IDREF$|^IDREFS$|^ENTITY$|^ENTITIES$|^NMTOKEN$|^NMTOKENS$/.test(a)||this.saxEvents.error("Invalid type : ["+a+"] defined in ATTLIST",this)}return a},O.prototype.scanNotationDecl=function(){if(this.reader.matchStr("NOTATION")){this.reader.skipWhiteSpaces();var a=this.scanName();this.reader.skipWhiteSpaces();var b=new N;return this.reader.matchStr("PUBLIC")?(this.reader.skipWhiteSpaces(),b.publicId=this.scanPubIdLiteral(),this.reader.skipWhiteSpaces(),this.reader.unequals(">")&&(b.systemId=this.scanSystemLiteral(),this.reader.skipWhiteSpaces())):this.scanExternalId(b),this.reader.nextChar(!0),this.saxEvents.notationDecl(a,b.publicId,b.systemId),!0}return!1},O.prototype.scanQName=function(a){var b=this.scanName(),c=b;if(b.indexOf(":")!==-1){var d=b.split(":");a=d[0],c=d[1]}return this.reader.skipWhiteSpaces(),new M(a,c)},O.prototype.scanElement=function(){var a=this.scanQName("");this.elementsStack.push(a.qName);var b=this.scanAttributes(a),c=null;try{c=this.namespaceSupport.getURI(a.prefix)}catch(b){this.saxEvents.error("namespace of element : ["+a.qName+"] not found",this)}var d=!1;return this.reader.matchChar("/")&&(this.reader.equals(">")?(d=!0,this.elementsStack.pop(),this.endMarkup(c,a)):this.saxEvents.fatalError("invalid empty markup, must finish with /&gt;",this)),this.reader.unequals(">")&&this.saxEvents.fatalError("invalid element, must finish with &gt;",this),this.reader.nextChar(!0),this.saxEvents.startElement(c,a.localName,a.qName,b),d&&this.saxEvents.endElement(c,a.localName,a.qName),!0},O.prototype.scanAttributes=function(a){var b=this.saxParser.getAttributesInstance();this.namespaceSupport.pushContext();var c="";this.scanAttribute(a,b);for(var d=b.getLength();d--;){var e=b.getPrefix(d),f=null;try{f=this.namespaceSupport.getURI(e)}catch(b){this.saxEvents.error("namespace of attribute : ["+a.qName+"] not found",this)}if(b.setURI(d,f),f===NamespaceSupport.XMLNS)switch(b.getLocalName(d)){case"base":c=b.getValue(d)}}return this.relativeBaseUris.push(c),b},O.prototype.scanAttribute=function(a,b){if(this.reader.skipWhiteSpaces(),this.reader.unequals(">")&&this.reader.unequals("/")){var c=this.scanQName(null);if(this.reader.matchChar("=")){this.reader.skipWhiteSpaces();var d=this.scanAttValue();"xmlns"===c.prefix?(this.namespaceSupport.declarePrefix(c.localName,d),this.saxEvents.startPrefixMapping(c.localName,d)):"xmlns"===c.qName?(this.namespaceSupport.declarePrefix("",d),this.saxEvents.startPrefixMapping("",d)):b.getIndex(c.qName)!==-1?this.saxEvents.error("multiple declarations for same attribute : ["+c.qName+"]",this):b.addAttribute(void 0,c.localName,c.qName,void 0,d),this.scanAttribute(a,b)}else this.saxEvents.fatalError("invalid attribute, must contain = between name and value",this)}},O.prototype.scanAttValue=function(){var a,b;if(this.reader.equals('"')||this.reader.equals("'")){b=this.reader.next();try{for(a=this.reader.nextCharRegExp(new RegExp("["+b+"<&\uFFFF]")),this.saxEvents.attWhitespaceNormalize&&(a=this.saxEvents.attWhitespaceNormalize(a));this.reader.matchChar("&");){try{var c=this.scanRef();c&&(a+=c)}catch(b){if(b instanceof L)this.saxEvents.error("entity reference : ["+b.entityName+"] not declared, ignoring it",this);else{if(!(b instanceof K))throw b;a+="&"+b.entityName+";"}}var d=this.reader.nextCharRegExp(new RegExp("["+b+"<&]"));this.saxEvents.attWhitespaceNormalize&&(d=this.saxEvents.attWhitespaceNormalize(d)),a+=d}if(this.reader.equals("<"))return this.saxEvents.fatalError("invalid attribute value, must not contain &lt;",this);if(this.reader.equals("\uFFFF"))return this.saxEvents.fatalError("invalid attribute value, must not contain U+FFFF",this);this.reader.nextChar(!0),/[^\/>"]/.test(this.reader.peek())&&this.reader.peek().search(A)===-1&&this.saxEvents.fatalError("Whitespace is required between attribute-value pairs.",this),this.reader.skipWhiteSpaces()}catch(a){if(a instanceof J)return this.saxEvents.fatalError("document incomplete, attribute value declaration must end with a quote",this);throw a}return a}return this.saxEvents.fatalError("invalid attribute value declaration, must begin with a quote",this)},O.prototype.scanCData=function(){if(this.reader.matchStr("[CDATA[")){this.saxEvents.startCDATA();for(var a=this.reader.nextCharWhileNot("]");!this.reader.matchStr("]]>");)this.reader.nextChar(!0),a+="]"+this.reader.nextCharWhileNot("]");return/\uFFFF/.test(a)&&this.saxEvents.fatalError("Character U+FFFF is not allowed within CDATA.",this),a=a.replace(/\r\n/g,"\n"),this.saxEvents.characters(a,0,a.length),this.saxEvents.endCDATA(),!0}return!1},O.prototype.scanCharRef=function(){var a,b="";if(this.reader.matchChar("x")){for(;this.reader.unequals(";");){var c=this.reader.next();/[0-9a-fA-F]/.test(c)?b+=c:this.saxEvents.error("invalid char reference beginning with x, must contain alphanumeric characters only",this)}this.reader.nextChar(!0),a=String.fromCharCode("0x"+b),this.saxEvents.startCharacterReference&&this.saxEvents.startCharacterReference(!0,b)}else{for(;this.reader.unequals(";");){var c=this.reader.next();/\d/.test(c)?b+=c:this.saxEvents.error("invalid char reference, must contain numeric characters only",this)}this.reader.nextChar(!0),a=String.fromCharCode(b),a.search(H)!==-1&&(a=I[a]),this.saxEvents.startCharacterReference&&this.saxEvents.startCharacterReference(!1,b)}return a},O.prototype.scanEntityRef=function(){try{var a=this.scanName();if(this.reader.skipWhiteSpaces(),this.reader.unequals(";"))return this.saxEvents.error("entity : ["+a+"] contains an invalid character : ["+this.reader.peek()+"], or it is not ended by ;",this),"";if(this.reader.nextChar(!0),this.saxEvents.startEntity(a),this.saxEvents.endEntity(a),a.search(F)!==-1)throw new K(a);if(a.search(G)!==-1)this.includeText("'");else{var b=this.entities[a];if(void 0===b)throw new L(a);this.includeEntity(a,b)}}catch(a){if(a instanceof J)return this.saxEvents.fatalError("document incomplete, entity reference must end with ;",this);throw a}},O.prototype.scanEndingTag=function(){var a=this.scanQName(""),b=null;try{b=this.namespaceSupport.getURI(a.prefix)}catch(b){this.saxEvents.error("namespace of ending tag : ["+a.qName+"] not found",this)}var c=this.elementsStack.pop();return a.qName===c?this.reader.matchChar(">")?(this.endMarkup(b,a),this.saxEvents.endElement(b,a.localName,a.qName),!0):this.saxEvents.fatalError("invalid ending markup, does not finish with &gt;",this):(this.reader.matchChar(">"),this.saxEvents.fatalError("invalid ending markup : ["+a.qName+"], markup name does not match current one : ["+c+"]",this))},O.prototype.endMarkup=function(a,b){var c=this.namespaceSupport.popContext();for(var d in c)this.saxEvents.endPrefixMapping(d);this.relativeBaseUris.pop()},O.prototype.scanName=function(){return this.reader.peek().search(m)!==-1?(this.saxEvents.fatalError("invalid starting character in Name : ["+this.reader.peek()+"]",this),""):this.reader.nextCharRegExp(o)},this.SAXScanner=O,this.EndOfInputException=J}(),function(){function a(a){for(var b=this.attsArray.length;b--;)if(this.attsArray[b].qName===a)return b;return-1}function b(a,b){for(var c=this.attsArray.length;c--;)if(this.attsArray[c].namespaceURI===a&&this.attsArray[c].localName===b)return c;return-1}function c(a){return this.attsArray[a]?this.attsArray[a].value:null}function d(a){for(var b=this.attsArray.length;b--;)if(this.attsArray[b].qName===a)return this.attsArray[b].value;return null}function e(a,b){for(var c=this.attsArray.length;c--;)if(this.attsArray[c].namespaceURI===a&&this.attsArray[c].localName===b)return this.attsArray[c].value;return null}function f(a,b){var c=null;return a.length!==b.length&&(c=b.split(":")[0]),c}function g(a,b,c,d,e,f){this.namespaceURI=a,void 0===b||""===b?this.prefix=null:this.prefix=b,this.localName=c,this.qName=d,this.type=e,this.value=f}function h(a){this.attsArray=[],a&&this.setAttributes(a)}function i(a){if(h.call(this,a),a)for(var b=0;b<a.getLength();b++)this.setDeclared(a.isDeclared(b)),this.setSpecified(a.isSpecified(b))}function j(c,d){var e;return e=void 0===d?"string"==typeof c?a.call(this,c):c:b.call(this,c,d)}h.prototype.toString=function(){return"AttributesImpl"},h.prototype.getIndex=function(c,d){return void 0===d?a.call(this,c):b.call(this,c,d)},h.prototype.getLength=function(){return this.attsArray.length},h.prototype.getPrefix=function(a){return this.attsArray[a].prefix},h.prototype.getLocalName=function(a){return this.attsArray[a].localName},h.prototype.getQName=function(a){return this.attsArray[a].qName},h.prototype.getType=function(c,d){var e;if(d?e=b.call(this,c,d):c&&(e=parseInt(c,10),e||0===e||(e=a.call(this,c))),e||0===e){var f=this.attsArray[e].type;if(f)return f}return"CDATA"},h.prototype.getURI=function(a){return this.attsArray[a].namespaceURI},h.prototype.getValue=function(a,b){return void 0===b?"string"==typeof a?d.call(this,a):c.call(this,a):e.call(this,a,b)},h.prototype.addAttribute=function(a,b,c,d,e){var g=f.call(this,b,c);this.addPrefixedAttribute(a,g,b,c,d,e)},h.prototype.clear=function(){this.attsArray=[]},h.prototype.removeAttribute=function(a){this.attsArray.splice(a,1)},h.prototype.addAttributeAtIndex=function(a,b,c,d,e,h){var i=f.call(this,c,d);a>this.attsArray.length?this.attsArray[a]=new g(b,i,c,d,e,h):this.attsArray.splice(a,0,new g(b,i,c,d,e,h))},h.prototype.setAttribute=function(a,b,c,d,e,f){this.setURI(a,b),this.setLocalName(a,c),this.setQName(a,d),this.setType(a,e),this.setValue(a,f)},h.prototype.setAttributes=function(a){for(var b=0;b<a.getLength();b++)this.addPrefixedAttribute(a.getURI(b),a.getPrefix(b),a.getLocalName(b),a.getType(b),a.getValue(b))},h.prototype.setLocalName=function(a,b){this.attsArray[a].localName=b},h.prototype.setQName=function(a,b){var c=this.attsArray[a];if(c.qName=b,b.indexOf(":")!==-1){var d=b.split(":");c.prefix=d[0],c.localName=d[1]}else c.prefix=null,c.localName=b},h.prototype.setType=function(a,b){this.attsArray[a].type=b},h.prototype.setURI=function(a,b){this.attsArray[a].namespaceURI=b},h.prototype.setValue=function(a,b){this.attsArray[a].value=b},h.prototype.addPrefixedAttribute=function(a,b,c,d,e,f){this.attsArray.push(new g(a,b,c,d,e,f))},i.prototype.toString=function(){return"Attributes2Impl"},i.prototype=new h,i.prototype.isDeclared=function(a,b){var c=j(a,b);return this.attsArray[c].declared},i.prototype.isSpecified=function(a,b){var c=j(a,b);return this.attsArray[c].specified},i.prototype.addAttribute=function(a,b,c,d,e){var g=f.call(this,b,c);this.addPrefixedAttribute(a,g,b,c,d,e);var h=this.getLength()-1;this.setDeclared(h,!1),this.setSpecified(h,!0)},i.prototype.setAttributes=function(a){},i.prototype.setDeclared=function(a,b){this.attsArray[a].declared=b},i.prototype.setSpecified=function(a,b){this.attsArray[a].specified=b},this.AttributesImpl=h,this.Attributes2Impl=i}(),function(){function a(a){this.prefix=a}function b(){}b.prototype.declarePrefix=function(a,b){var c=this.namespaces[this.namespaces.length-1];c[a]=b},b.prototype.getDeclaredPrefixes=function(){for(var a=[],b=this.namespaces.length;b--;)for(var c in this.namespaces[b])a.push(c);return a},b.prototype.getPrefix=function(a){for(var b=this.namespaces.length;b--;){var c=this.namespaces[b];for(var d in c)if(c[d]===a)return d}return null},b.prototype.getPrefixes=function(){throw new SAXNotSupportedException("NamespaceSupport.getPrefixes()")},b.prototype.getPrefixes=function(a){throw new SAXNotSupportedException("NamespaceSupport.getPrefixes(uri)")},b.prototype.getURI=function(b){if(null===b)return null;for(var c=this.namespaces.length;c--;){var d=this.namespaces[c][b];if(d)return d}if(!b)return null;throw new a(b)},b.prototype.isNamespaceDeclUris=function(){throw new SAXNotSupportedException("NamespaceSupport.isNamespaceDeclUris()")},b.prototype.popContext=function(){return this.namespaces.pop()},b.prototype.processName=function(a,b,c){throw new SAXNotSupportedException("NamespaceSupport.processName(qName, parts, isAttribute)")},b.prototype.pushContext=function(){var a={};this.namespaces.push(a)},b.prototype.reset=function(){this.namespaces=[];var a={};a.xml=b.XMLNS,this.namespaces.push(a)},b.prototype.setNamespaceDeclUris=function(a){throw new SAXNotSupportedException("NamespaceSupport.setNamespaceDeclUris(value)")},b.NSDECL="http://www.w3.org/xmlns/2000/",b.XMLNS="http://www.w3.org/XML/1998/namespace",this.NamespaceSupport=b}(),function(){function a(a,b){for(var c=0;c<b.length;c++)if("function"!=typeof a[b[c]])return!1;return!0}function b(b){if(b){if(!a(b,["getContentHandler","getDTDHandler","getEntityResolver","getErrorHandler","getFeature","getProperty","parse","setContentHandler","setDTDHandler","setEntityResolver","setErrorHandler","setFeature","setProperty"]))throw"XMLFilterImpl must be given a parent which implements XMLReader";this.parent=b}}function c(a){return b.call(this,a)}b.prototype.toString=function(){return"XMLFilterImpl"},b.prototype.setParent=function(a){this.parent=a},b.prototype.getParent=function(){return this.parent},b.prototype.getContentHandler=function(){return this.parent.getContentHandler.call(this.parent)},b.prototype.getDTDHandler=function(){return this.parent.getDTDHandler.call(this.parent)},b.prototype.getEntityResolver=function(){return this.parent.getEntityResolver.call(this.parent)},b.prototype.getErrorHandler=function(){return this.parent.getErrorHandler.call(this.parent)},b.prototype.getFeature=function(a){return this.parent.getFeature.call(this.parent,a)},b.prototype.getProperty=function(a){return this.parent.getProperty.call(this.parent,a)},b.prototype.parse=function(a){return this.parent.parse.call(this.parent,a)},b.prototype.setContentHandler=function(a){return this.parent.setContentHandler.call(this.parent,a)},b.prototype.setDTDHandler=function(a){return this.parent.setDTDHandler.call(this.parent,a)},b.prototype.setEntityResolver=function(a){return this.parent.setEntityResolver.call(this.parent,a)},b.prototype.setErrorHandler=function(a){return this.parent.setErrorHandler.call(this.parent,a)},b.prototype.setFeature=function(a,b){return this.parent.setFeature.call(this.parent,a,b)},b.prototype.setProperty=function(a,b){return this.parent.setProperty.call(this.parent,a,b)},b.prototype.startDocument=function(){return this.parent?this.parent.contentHandler.startDocument.call(this.parent.contentHandler):void 0},b.prototype.startElement=function(a,b,c,d){return this.parent?this.parent.contentHandler.startElement.call(this.parent.contentHandler,a,b,c,d):void 0},b.prototype.endElement=function(a,b,c){return this.parent?this.parent.contentHandler.endElement.call(this.parent.contentHandler,a,b,c):void 0},b.prototype.startPrefixMapping=function(a,b){return this.parent?this.parent.contentHandler.startPrefixMapping.call(this.parent.contentHandler,a,b):void 0},b.prototype.endPrefixMapping=function(a){return this.parent?this.parent.contentHandler.endPrefixMapping.call(this.parent.contentHandler,a):void 0},b.prototype.processingInstruction=function(a,b){return this.parent?this.parent.contentHandler.processingInstruction.call(this.parent.contentHandler,a,b):void 0},b.prototype.ignorableWhitespace=function(a,b,c){return this.parent?this.parent.contentHandler.ignorableWhitespace.call(this.parent.contentHandler,a,b,c):void 0},b.prototype.characters=function(a,b,c){return this.parent?this.parent.contentHandler.characters.call(this.parent.contentHandler,a,b,c):void 0},b.prototype.skippedEntity=function(a){return this.parent?this.parent.contentHandler.skippedEntity.call(this.parent.contentHandler,a):void 0},b.prototype.endDocument=function(){return this.parent?this.parent.contentHandler.endDocument.call(this.parent.contentHandler):void 0},b.prototype.setDocumentLocator=function(a){return this.parent?this.parent.contentHandler.setDocumentLocator.call(this.parent.contentHandler,a):void 0},b.prototype.resolveEntity=function(a,b){if(this.parent&&this.parent.entityResolver)return this.parent.entityResolver.resolveEntity.call(this.parent.entityResolver,a,b)},b.prototype.notationDecl=function(a,b,c){if(this.parent&&this.parent.dtdHandler&&this.parent.dtdHandler.notationDecl)return this.parent.dtdHandler.notationDecl.call(this.parent.dtdHandler,a,b,c)},b.prototype.unparsedEntityDecl=function(a,b,c,d){if(this.parent&&this.parent.dtdHandler&&this.parent.dtdHandler.unparsedEntityDecl)return this.parent.dtdHandler.unparsedEntityDecl.call(this.parent.dtdHandler,a,b,c,d)},b.prototype.warning=function(a){if(this.parent&&this.parent.errorHandler)return this.parent.errorHandler.warning.call(this.parent.errorHandler,a)},b.prototype.error=function(a){if(this.parent&&this.parent.errorHandler)return this.parent.errorHandler.error.call(this.parent.errorHandler,a)},b.prototype.fatalError=function(a){if(this.parent&&this.parent.errorHandler)return this.parent.errorHandler.fatalError.call(this.parent.errorHandler,a)},b.prototype.parseString=function(a){return this.parent.parseString.call(this.parent,a)},c.prototype=new b,c.prototype.toString=function(){return"XMLFilterImpl2"},c.prototype.attributeDecl=function(a,b,c,d,e){if(this.parent&&this.parent.declarationHandler&&this.parent.declarationHandler.attributeDecl)return this.parent.declarationHandler.attributeDecl.call(this.parent.declarationHandler,a,b,c,d,e)},c.prototype.elementDecl=function(a,b){if(this.parent&&this.parent.declarationHandler&&this.parent.declarationHandler.elementDecl)return this.parent.declarationHandler.elementDecl.call(this.parent.declarationHandler,a,b)},c.prototype.externalEntityDecl=function(a,b,c){if(this.parent&&this.parent.declarationHandler&&this.parent.declarationHandler.externalEntityDecl)return this.parent.declarationHandler.externalEntityDecl.call(this.parent.declarationHandler,a,b,c)},c.prototype.internalEntityDecl=function(a,b){if(this.parent&&this.parent.declarationHandler&&this.parent.declarationHandler.internalEntityDecl)return this.parent.declarationHandler.internalEntityDecl.call(this.parent.declarationHandler,a,b)},c.prototype.comment=function(a,b,c){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.comment)return this.parent.lexicalHandler.comment.call(this.parent.lexicalHandler,a,b,c)},c.prototype.endCDATA=function(){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.endCDATA)return this.parent.lexicalHandler.endCDATA.call(this.parent.lexicalHandler)},c.prototype.endDTD=function(){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.endDTD)return this.parent.lexicalHandler.endDTD.call(this.parent.lexicalHandler)},c.prototype.endEntity=function(a){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.endEntity)return this.parent.lexicalHandler.endEntity.call(this.parent.lexicalHandler,a)},c.prototype.startCDATA=function(){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.startCDATA)return this.parent.lexicalHandler.startCDATA.call(this.parent.lexicalHandler)},c.prototype.startDTD=function(a,b,c){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.startDTD)return this.parent.lexicalHandler.startDTD.call(this.parent.lexicalHandler,a,b,c)},c.prototype.startEntity=function(a){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.startEntity)return this.parent.lexicalHandler.startEntity.call(this.parent.lexicalHandler,a)},c.prototype.startCharacterReference=function(a,b){if(this.parent&&this.parent.lexicalHandler&&this.parent.lexicalHandler.startCharacterReference)return this.parent.lexicalHandler.startCharacterReference.call(this.parent.lexicalHandler,a,b)},c.prototype.resolveEntity=function(a,b,c,d){if(this.parent&&this.parent.entityResolver&&this.parent.entityResolver.resolveEntity)return this.parent.entityResolver.resolveEntity.call(this.parent.entityResolver,a,b,c,d)},c.prototype.getExternalSubset=function(a,b){if(this.parent&&this.parent.entityResolver&&this.parent.entityResolver.getExternalSubset)return this.parent.entityResolver.getExternalSubset.call(this.parent.entityResolver,a,b)},this.XMLFilterImpl=b,this.XMLFilterImpl2=c}(),Reader.prototype.close=function(){throw"The Reader close() method is abstract"},Reader.prototype.mark=function(a){},Reader.prototype.markSupported=function(){},Reader.prototype.read=function(a,b,c){if(arguments.length>4||2===arguments.length)throw"Reader's read() method expects 0, 1, or 3 arguments";throw"The Reader read() method with 3 arguments (char[], int, and int) is abstract."},Reader.prototype.ready=function(){},Reader.prototype.reset=function(){},Reader.prototype.skip=function(a){},StringReader.prototype=new Reader,StringReader.prototype.constructor=StringReader,StringReader.prototype.close=function(){},StringReader.prototype.mark=function(a){this.markIdx=this.nextIdx},StringReader.prototype.markSupported=function(){return!0},StringReader.prototype.read=function(a,b,c){if(0===arguments.length){if(this.nextIdx>=this.length)throw new EndOfInputException;var d=this.s.charAt(this.nextIdx);return this.nextIdx++,d}if(1===arguments.length)return a=this.s.substr(this.nextIdx),this.nextIdx=this.length,a;if(this.nextIdx+=b,this.nextIdx>=this.length)throw new EndOfInputException;return a=this.s.substr(this.nextIdx,c),this.nextIdx+=c,a},StringReader.prototype.ready=function(){return!0},StringReader.prototype.reset=function(){this.nextIdx=this.markIdx},StringReader.prototype.skip=function(a){return this.nextIdx+=a,a},ReaderWrapper.WS=new RegExp("[\\t\\n\\r ]"),ReaderWrapper.prototype.peekLen=function(a){var b=this.peeked.length;if(a<=b)return this.peeked.slice(-a).reverse().join("");var c=this.peeked.slice(0).reverse().join(""),d=a-b,e=this.reader.read(c,0,d);c+=e;for(var f=0;f<d;f++)this.peeked.unshift(e.charAt(f));return c},ReaderWrapper.prototype.skip=function(a){for(var b=0;0!==this.peeked.length&&b<a;b++)this.peeked.pop();a-=b,a&&this.reader.skip(a)},ReaderWrapper.prototype.next=function(){return 0!==this.peeked.length?this.peeked.pop():this.reader.read()},ReaderWrapper.prototype.peek=function(){var a=this.peeked.length;if(0!==a)return this.peeked[a-1];var b=this.reader.read();return this.peeked[0]=b,b},ReaderWrapper.prototype.nextChar=function(a){this.next(),a||this.skipWhiteSpaces()},ReaderWrapper.prototype.skipWhiteSpaces=function(){for(;this.peek().search(ReaderWrapper.WS)!==-1;)this.next()},ReaderWrapper.prototype.nextCharRegExp=function(a,b){for(var c="",d=this.peek();;){if(d.search(a)!==-1){if(b&&d.search(b.pattern)!==-1){var e=b.cb.call(this);if(e!==!0)return e;c+=d,d=this.peek();continue}return c}c+=d,this.next(),d=this.peek()}},ReaderWrapper.prototype.nextCharWhileNot=function(a){for(var b="",c=this.peek();c!==a;)b+=c,this.next(),c=this.peek();return b},ReaderWrapper.prototype.matchRegExp=function(a,b,c){var d=this.peekLen(a);return 0===d.search(b)&&(c||this.skip(a),!0)},ReaderWrapper.prototype.matchStr=function(a){var b=a.length,c=this.peekLen(b);return c===a&&(this.skip(b),!0)},ReaderWrapper.prototype.matchChar=function(a){return!!this.equals(a)&&(this.next(),!0)},ReaderWrapper.prototype.quoteContent=function(){var a=this.next(),b=this.nextCharWhileNot(a);return this.next(),b},ReaderWrapper.prototype.equals=function(a){return a===this.peek()},ReaderWrapper.prototype.unequals=function(a){return a!==this.peek()},ReaderWrapper.prototype.unread=function(a){
for(var b=a.length;b--;)this.peeked[this.peeked.length]=a.charAt(b)},function(){function a(){this.saxParseExceptions=[]}function b(){a.call(this)}a.prototype.startDocument=function(){},a.prototype.startElement=function(a,b,c,d){},a.prototype.endElement=function(a,b,c){},a.prototype.startPrefixMapping=function(a,b){},a.prototype.endPrefixMapping=function(a){},a.prototype.processingInstruction=function(a,b){},a.prototype.ignorableWhitespace=function(a,b,c){},a.prototype.characters=function(a,b,c){},a.prototype.skippedEntity=function(a){},a.prototype.endDocument=function(){},a.prototype.setDocumentLocator=function(a){this.locator=a},a.prototype.resolveEntity=function(a,b){return null},a.prototype.notationDecl=function(a,b,c){},a.prototype.unparsedEntityDecl=function(a,b,c,d){},a.prototype.warning=function(a){this.saxParseExceptions.push(a)},a.prototype.error=function(a){this.saxParseExceptions.push(a)},a.prototype.fatalError=function(a){throw a},b.prototype=new a,b.prototype.attributeDecl=function(a,b,c,d,e){},b.prototype.elementDecl=function(a,b){},b.prototype.externalEntityDecl=function(a,b,c){},b.prototype.internalEntityDecl=function(a,b){},b.prototype.comment=function(a,b,c){},b.prototype.endCDATA=function(){},b.prototype.endDTD=function(){},b.prototype.endEntity=function(a){},b.prototype.startCDATA=function(){},b.prototype.startDTD=function(a,b,c){},b.prototype.startEntity=function(a){},b.prototype.resolveEntity=function(a,b,c,d){},b.prototype.getExternalSubset=function(a,b){},this.DefaultHandler=a,this.DefaultHandler2=b}();