/*
 * viewmodel.min.js  version 7.5.2
 *
 * Sweet Home 3D, Copyright (c) 2024 Space Mushrooms <info@sweethome3d.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
if(Math.fround===undefined){doubleToFloatConverter=new Float32Array(1);Math.fround=function(a){doubleToFloatConverter[0]=a;return doubleToFloatConverter[0]}}function Node3D(){}Node3D.READING_MODEL="Reading model";Node3D.PARSING_MODEL="Parsing model";Node3D.BUILDING_MODEL="Building model";Node3D.BINDING_MODEL="Binding model";Node3D.prototype.setCapability=function(a){if(this.capabilities===undefined){this.capabilities=0}this.capabilities|=a};Node3D.prototype.getCapability=function(a){if(this.capabilities===undefined){return false}else{return(this.capabilities&a)!==0}};Node3D.prototype.getParent=function(){if(this.parent===undefined){return null}else{return this.parent}};Node3D.prototype.getUserData=function(){if(this.userData===undefined){return null}else{return this.userData}};Node3D.prototype.setUserData=function(a){this.userData=a};Node3D.prototype.getName=function(){if(this.name===undefined){return null}else{return this.name}};Node3D.prototype.setName=function(a){this.name=a};Node3D.prototype.addPropertyChangeListener=function(a,b){if(this.propertyChangeSupport===undefined){this.propertyChangeSupport=new PropertyChangeSupport(this)}this.propertyChangeSupport.addPropertyChangeListener(a,b)};Node3D.prototype.removePropertyChangeListener=function(a,b){if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.removePropertyChangeListener(a,b)}};Node3D.prototype.getPropertyChangeListeners=function(){if(this.propertyChangeSupport!==undefined){return this.propertyChangeSupport.getPropertyChangeListeners()}else{return[]}};Node3D.prototype.setPickable=function(a){this.pickable=a};Node3D.prototype.isPickable=function(){if(this.pickable!==undefined){return this.pickable}else{return true}};Node3D.prototype.clone=function(){var a=new Node3D();this.cloneNodeAttributes(a);return a};Node3D.prototype.cloneNodeAttributes=function(a){if(this.capabilities!==undefined){a.capabilities=this.capabilities}if(this.userData!==undefined){a.userData=this.userData}if(this.name!==undefined){a.name=this.name}if(this.pickable!==undefined){a.pickable=this.pickable}};function Shape3D(b,a){Node3D.call(this);if(b===undefined){b=null;a=null}else{if(a===undefined){a=null}}this.appearance=a;this.bounds=null;this.geometries=[];if(b!==null){this.geometries.push(b)}}Shape3D.prototype=Object.create(Node3D.prototype);Shape3D.prototype.constructor=Shape3D;Shape3D.ALLOW_GEOMETRY_WRITE=2;Shape3D.prototype.addGeometry=function(e){this.geometries.push(e);var b=vec3.fromValues(Infinity,Infinity,Infinity);var c=vec3.fromValues(-Infinity,-Infinity,-Infinity);if(this.bounds!==null){this.bounds.getLower(b);this.bounds.getUpper(c)}for(var a=0;a<e.vertexIndices.length;a++){var d=e.vertices[e.vertexIndices[a]];vec3.min(b,b,d);vec3.max(c,c,d)}this.bounds=new BoundingBox3D(b,c);if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("GEOMETRY",null,e)}};Shape3D.prototype.setGeometry=function(b,a){var c=this.geometries[a];this.geometries[a]=b;this.bounds=null;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("GEOMETRY",c,b)}};Shape3D.prototype.removeGeometry=function(a){var b=this.geometries[a];this.geometries.splice(a,1);this.bounds=null;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("GEOMETRY",b,null)}};Shape3D.prototype.getBounds=function(){if(this.geometries.length===0){return new BoundingBox3D(vec3.fromValues(Infinity,Infinity,Infinity),vec3.fromValues(-Infinity,-Infinity,-Infinity))}else{if(this.bounds===null){var b=vec3.fromValues(Infinity,Infinity,Infinity);var d=vec3.fromValues(-Infinity,-Infinity,-Infinity);for(var c=0;c<this.geometries.length;c++){var f=this.geometries[c];if(f.vertexIndices){for(var a=0;a<f.vertexIndices.length;a++){var e=f.vertices[f.vertexIndices[a]];vec3.min(b,b,e);vec3.max(d,d,e)}}}this.bounds=new BoundingBox3D(b,d)}}return this.bounds.clone()};Shape3D.prototype.getGeometries=function(){return this.geometries};Shape3D.prototype.getAppearance=function(){return this.appearance};Shape3D.prototype.setAppearance=function(a){this.appearance=a};Shape3D.prototype.clone=function(){var a=new Shape3D(null,this.appearance);this.cloneNodeAttributes(a);a.geometries=this.geometries;a.bounds=this.bounds;return a};function Background3D(a){Node3D.call(this);this.geometry=a;a.parent=this}Background3D.prototype=Object.create(Node3D.prototype);Background3D.prototype.constructor=Background3D;Background3D.prototype.getGeometry=function(){return this.geometry};Background3D.prototype.clone=function(){var a=new Background3D(this.geometry);this.cloneNodeAttributes(a);return a};function Light3D(a){Node3D.call(this);this.color=a}Light3D.prototype=Object.create(Node3D.prototype);Light3D.prototype.constructor=Light3D;Light3D.prototype.getColor=function(){return this.color};Light3D.prototype.setColor=function(a){var b=this.color;this.color=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("COLOR",b,a)}};function AmbientLight3D(a){Light3D.call(this,a)}AmbientLight3D.prototype=Object.create(Light3D.prototype);AmbientLight3D.prototype.constructor=AmbientLight3D;AmbientLight3D.prototype.clone=function(){var a=new AmbientLight3D(this.color);this.cloneNodeAttributes(a);return a};function DirectionalLight3D(a,b){Light3D.call(this,a);this.direction=b}DirectionalLight3D.prototype=Object.create(Light3D.prototype);DirectionalLight3D.prototype.constructor=DirectionalLight3D;DirectionalLight3D.prototype.getDirection=function(){return this.direction};DirectionalLight3D.prototype.clone=function(){var a=new DirectionalLight3D(this.color,this.direction);this.cloneNodeAttributes(a);return a};function Group3D(){Node3D.call(this);this.children=[]}Group3D.prototype=Object.create(Node3D.prototype);Group3D.prototype.constructor=Group3D;Group3D.ALLOW_CHILDREN_EXTEND=1;Group3D.prototype.addChild=function(a){this.insertChild(a,this.children.length)};Group3D.prototype.insertChild=function(e,a){this.children.splice(a,0,e);e.parent=this;if(this.childrenListeners!==undefined){var d={source:this,child:e,index:a};var c=this.childrenListeners.slice(0);for(var b=0;b<c.length;b++){c[b].childAdded(d)}}};Group3D.prototype.getChild=function(a){return this.children[a]};Group3D.prototype.getChildren=function(){return this.children};Group3D.prototype.removeChild=function(a){var e;if(a instanceof Node3D){e=a;a=this.children.indexOf(e)}else{e=this.children[a]}this.children.splice(a,1);delete e.parent;if(this.childrenListeners!==undefined){var d={source:this,child:e,index:a};var c=this.childrenListeners.slice(0);for(var b=0;b<c.length;b++){c[b].childRemoved(d)}}};Group3D.prototype.removeAllChildren=function(){for(var a=this.children.length-1;a>=0;a--){this.removeChild(a)}};Group3D.prototype.addChildrenListener=function(a){if(this.childrenListeners===undefined){this.childrenListeners=[]}this.childrenListeners.push(a)};Group3D.prototype.removeChildrenListener=function(b){if(this.childrenListeners!==undefined){var a=this.childrenListeners.indexOf(b);if(a!==-1){this.childrenListeners.splice(a,1)}}};Group3D.prototype.getChildrenListeners=function(){if(this.childrenListeners!==undefined){return this.childrenListeners.slice(0)}else{return[]}};Group3D.prototype.setPickable=function(b){Node3D.prototype.setPickable.call(this,b);for(var a=0;a<this.children.length;a++){this.children[a].setPickable(b)}};Group3D.prototype.clone=function(){var a=new Group3D();this.cloneNodeAttributes(a);return a};function BranchGroup3D(){Group3D.call(this)}BranchGroup3D.prototype=Object.create(Group3D.prototype);BranchGroup3D.prototype.constructor=BranchGroup3D;BranchGroup3D.prototype.detach=function(){if(this.parent){this.parent.removeChild(this)}};BranchGroup3D.prototype.clone=function(){var a=new BranchGroup3D();this.cloneNodeAttributes(a);return a};function SharedGroup3D(){Group3D.call(this)}SharedGroup3D.prototype=Object.create(Group3D.prototype);SharedGroup3D.prototype.constructor=SharedGroup3D;SharedGroup3D.prototype.clone=function(){var a=new SharedGroup3D();this.cloneNodeAttributes(a);return a};function Link3D(a){Node3D.call(this);this.sharedGroup=a}Link3D.prototype=Object.create(Node3D.prototype);Link3D.prototype.constructor=Link3D;Link3D.prototype.getSharedGroup=function(){return this.sharedGroup};Link3D.prototype.setSharedGroup=function(a){this.sharedGroup=a};Link3D.prototype.setPickable=function(a){Node3D.prototype.setPickable.call(this,a);this.sharedGroup.setPickable(a)};Link3D.prototype.clone=function(){var a=new Link3D(this.sharedGroup);this.cloneNodeAttributes(a);return a};function TransformGroup3D(a){Group3D.call(this);if(a!==undefined){this.transform=mat4.clone(a)}else{this.transform=mat4.create()}}TransformGroup3D.prototype=Object.create(Group3D.prototype);TransformGroup3D.prototype.constructor=TransformGroup3D;TransformGroup3D.ALLOW_TRANSFORM_WRITE=4;TransformGroup3D.prototype.getTransform=function(a){mat4.copy(a,this.transform)};TransformGroup3D.prototype.setTransform=function(a){if(!TransformGroup3D.areTransformationsEqual(this.transform,a)){var b=mat4.clone(this.transform);mat4.copy(this.transform,a);if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("TRANSFORM",b,a)}}};TransformGroup3D.areTransformationsEqual=function(c,b){if(c&&b&&c.length===b.length){for(var a=0;a<c.length;a++){if(c[a]!==b[a]){return false}}return true}else{return c===b}};TransformGroup3D.isIdentity=function(a){if(TransformGroup3D.IDENTITY===undefined){TransformGroup3D.IDENTITY=mat4.create()}return mat4.exactEquals(a,TransformGroup3D.IDENTITY)};TransformGroup3D.prototype.clone=function(){var a=new TransformGroup3D(this.transform);this.cloneNodeAttributes(a);return a};function Appearance3D(a){if(a!==undefined){this.name=a}}Appearance3D.CULL_NONE=0;Appearance3D.CULL_BACK=1;Appearance3D.CULL_FRONT=2;Appearance3D.prototype.addPropertyChangeListener=function(a){if(this.propertyChangeSupport===undefined){this.propertyChangeSupport=new PropertyChangeSupport(this)}this.propertyChangeSupport.addPropertyChangeListener(a)};Appearance3D.prototype.removePropertyChangeListener=function(a){if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.removePropertyChangeListener(a)}};Appearance3D.prototype.setName=function(a){this.name=a};Appearance3D.prototype.getName=function(){return this.name};Appearance3D.prototype.setAmbientColor=function(a){var b=this.ambientColor;this.ambientColor=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("AMBIENT_COLOR",b,a)}};Appearance3D.prototype.getAmbientColor=function(){return this.ambientColor};Appearance3D.prototype.setEmissiveColor=function(a){var b=this.emissiveColor;this.emissiveColor=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("EMISSIVE_COLOR",b,a)}};Appearance3D.prototype.getEmissiveColor=function(){return this.emissiveColor};Appearance3D.prototype.setDiffuseColor=function(a){var b=this.diffuseColor;this.diffuseColor=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("DIFFUSE_COLOR",b,a)}};Appearance3D.prototype.getDiffuseColor=function(){return this.diffuseColor};Appearance3D.prototype.setSpecularColor=function(b){var a=this.specularColor;this.specularColor=b;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("SPECULAR_COLOR",a,b)}};Appearance3D.prototype.getSpecularColor=function(){return this.specularColor};Appearance3D.prototype.setShininess=function(b){b=Math.max(b,1);var a=this.shininess;this.shininess=b;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("SHININESS",a,b)}};Appearance3D.prototype.getShininess=function(){return this.shininess};Appearance3D.prototype.setTransparency=function(a){var b=this.transparency;this.transparency=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("TRANSPARENCY",b,a)}};Appearance3D.prototype.getTransparency=function(){return this.transparency};Appearance3D.prototype.setIllumination=function(a){var b=this.illumination;this.illumination=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("ILLUMINATION",b,a)}};Appearance3D.prototype.getIllumination=function(){return this.illumination};Appearance3D.prototype.setTextureImage=function(a){if(this.textureImage!==a){var b=this.textureImage;this.textureImage=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("TEXTURE_IMAGE",b,a)}}};Appearance3D.prototype.getTextureImage=function(){return this.textureImage};Appearance3D.isPowerOfTwo=function(a){return(a&(a-1))==0};Appearance3D.getNextHighestPowerOfTwo=function(a){--a;for(var b=1;b<32;b<<=1){a=a|a>>b}return(a+1)};Appearance3D.prototype.setTextureCoordinatesGeneration=function(b){if(!Appearance3D.areTextureCoordinatesGenerationsEqual(this.textureCoordinatesGeneration,b)){var a=this.textureCoordinatesGeneration;this.textureCoordinatesGeneration=b;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("TEXTURE_COORDINATES_GENERATION",a,b)}}};Appearance3D.areTextureCoordinatesGenerationsEqual=function(c,b){if(c&&b){var e=c.planeS;var d=b.planeS;if(e&&d&&vec4.equals(e,d)){var a=c.planeT;var f=b.planeT;return a&&f&&vec4.equals(a,f)}return false}else{return c===b}};Appearance3D.prototype.getTextureCoordinatesGeneration=function(){return this.textureCoordinatesGeneration};Appearance3D.prototype.setTextureTransform=function(b){if(!TransformGroup3D.areTransformationsEqual(this.textureTransform,b)){var a=this.textureTransform;this.textureTransform=b;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("TEXTURE_TRANSFORM",a,b)}}};Appearance3D.prototype.getTextureTransform=function(){return this.textureTransform};Appearance3D.prototype.setVisible=function(b){var a=this.visible;this.visible=b;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("VISIBLE",a,b)}};Appearance3D.prototype.isVisible=function(){return this.visible!==false};Appearance3D.prototype.setCullFace=function(a){var b=this.cullFace;this.cullFace=a;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("CULL_FACE",b,a)}};Appearance3D.prototype.getCullFace=function(){return this.cullFace};Appearance3D.prototype.setBackFaceNormalFlip=function(b){var a=this.backFaceNormalFlip;this.backFaceNormalFlip=b;if(this.propertyChangeSupport!==undefined){this.propertyChangeSupport.firePropertyChange("BACK_FACE_NORMAL_FLIP",a,b)}};Appearance3D.prototype.getBackFaceNormalFlip=function(){return this.backFaceNormalFlip};Appearance3D.prototype.isBackFaceNormalFlip=function(){return this.backFaceNormalFlip===true};Appearance3D.prototype.clone=function(){var b=new Appearance3D(this.name);for(var a in this){if(this.hasOwnProperty(a)){b[a]=this[a]}}return b};function IndexedGeometryArray3D(b,c,a,d){this.vertices=b;this.vertexIndices=c;this.textureCoordinates=a;this.textureCoordinateIndices=d;this.textureCoordinatesDefined=this.textureCoordinateIndices&&this.textureCoordinateIndices.length>0}IndexedGeometryArray3D.prototype.hasTextureCoordinates=function(){return this.textureCoordinatesDefined};IndexedGeometryArray3D.prototype.disposeCoordinates=function(){delete this.textureCoordinates;delete this.textureCoordinateIndices};function IndexedLineArray3D(b,c,a,d){IndexedGeometryArray3D.call(this,b,c,a,d)}IndexedLineArray3D.prototype=Object.create(IndexedGeometryArray3D.prototype);IndexedLineArray3D.prototype.constructor=IndexedLineArray3D;function IndexedTriangleArray3D(c,d,a,f,e,b){IndexedGeometryArray3D.call(this,c,d,a,f);this.normals=e;this.normalIndices=b}IndexedTriangleArray3D.prototype=Object.create(IndexedGeometryArray3D.prototype);IndexedTriangleArray3D.prototype.constructor=IndexedTriangleArray3D;IndexedTriangleArray3D.prototype.disposeCoordinates=function(){IndexedGeometryArray3D.prototype.disposeCoordinates.call(this);delete this.normals;delete this.normalIndices};function BoundingBox3D(a,b){this.lower=a!==undefined?vec3.clone(a):vec3.fromValues(-1,-1,-1);this.upper=b!==undefined?vec3.clone(b):vec3.fromValues(1,1,1)}BoundingBox3D.prototype.getLower=function(a){vec3.copy(a,this.lower)};BoundingBox3D.prototype.getUpper=function(a){vec3.copy(a,this.upper)};BoundingBox3D.prototype.isEmpty=function(){return this.lower[0]===Infinity&&this.lower[1]===Infinity&&this.lower[2]===Infinity&&this.upper[0]===-Infinity&&this.upper[1]===-Infinity&&this.upper[2]===-Infinity};BoundingBox3D.prototype.combine=function(b){if(b instanceof BoundingBox3D){if(this.lower[0]>b.lower[0]){this.lower[0]=b.lower[0]}if(this.lower[1]>b.lower[1]){this.lower[1]=b.lower[1]}if(this.lower[2]>b.lower[2]){this.lower[2]=b.lower[2]}if(this.upper[0]<b.upper[0]){this.upper[0]=b.upper[0]}if(this.upper[1]<b.upper[1]){this.upper[1]=b.upper[1]}if(this.upper[2]<b.upper[2]){this.upper[2]=b.upper[2]}}else{var a=b;if(this.lower[0]>a[0]){this.lower[0]=a[0]}if(this.lower[1]>a[1]){this.lower[1]=a[1]}if(this.lower[2]>a[2]){this.lower[2]=a[2]}if(this.upper[0]<a[0]){this.upper[0]=a[0]}if(this.upper[1]<a[1]){this.upper[1]=a[1]}if(this.upper[2]<a[2]){this.upper[2]=a[2]}}};BoundingBox3D.prototype.intersect=function(a){return !this.isEmpty()&&a[0]>=this.lower[0]&&a[0]<=this.upper[0]&&a[1]>=this.lower[1]&&a[1]<=this.upper[1]&&a[2]>=this.lower[2]&&a[2]<=this.upper[2]};BoundingBox3D.prototype.transform=function(g){if(!this.isEmpty()){var f=this.upper[0];var e=this.upper[1];var d=this.upper[2];var c=this.lower[0];var a=this.lower[1];var h=this.lower[2];var b=vec3.fromValues(f,e,d);vec3.transformMat4(b,b,g);this.upper[0]=b[0];this.upper[1]=b[1];this.upper[2]=b[2];this.lower[0]=b[0];this.lower[1]=b[1];this.lower[2]=b[2];vec3.set(b,c,e,d);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}vec3.set(b,c,a,d);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}vec3.set(b,f,a,d);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}vec3.set(b,c,e,h);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}vec3.set(b,f,e,h);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}vec3.set(b,c,a,h);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}vec3.set(b,f,a,h);vec3.transformMat4(b,b,g);if(b[0]>this.upper[0]){this.upper[0]=b[0]}if(b[1]>this.upper[1]){this.upper[1]=b[1]}if(b[2]>this.upper[2]){this.upper[2]=b[2]}if(b[0]<this.lower[0]){this.lower[0]=b[0]}if(b[1]<this.lower[1]){this.lower[1]=b[1]}if(b[2]<this.lower[2]){this.lower[2]=b[2]}}};BoundingBox3D.prototype.clone=function(){return new BoundingBox3D(this.lower,this.upper)};function Box3D(a,d,c,b){Shape3D.call(this,new IndexedTriangleArray3D([vec3.fromValues(-a,-d,-c),vec3.fromValues(a,-d,-c),vec3.fromValues(a,-d,c),vec3.fromValues(-a,-d,c),vec3.fromValues(-a,d,-c),vec3.fromValues(-a,d,c),vec3.fromValues(a,d,c),vec3.fromValues(a,d,-c)],[0,1,2,0,2,3,4,5,6,4,6,7,0,3,5,0,5,4,1,7,6,1,6,2,0,4,7,0,7,1,2,6,5,2,5,3],[vec2.fromValues(0,0),vec2.fromValues(1,0),vec2.fromValues(1,1),vec2.fromValues(0,1)],[0,1,2,0,2,3,3,0,1,3,1,2,0,1,2,0,2,3,1,2,3,1,3,0,1,2,3,1,3,0,1,2,3,1,3,0],[vec3.fromValues(0,-1,0),vec3.fromValues(0,1,0),vec3.fromValues(-1,0,0),vec3.fromValues(1,0,0),vec3.fromValues(0,0,-1),vec3.fromValues(0,0,1)],[0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5]),b);this.bounds=new BoundingBox3D(vec3.fromValues(-a,-d,-c),vec3.fromValues(a,d,c))}Box3D.prototype=Object.create(Shape3D.prototype);Box3D.prototype.constructor=Box3D;function GeometryInfo3D(a){this.type=a}GeometryInfo3D.TRIANGLE_ARRAY=0;GeometryInfo3D.TRIANGLE_STRIP_ARRAY=1;GeometryInfo3D.TRIANGLE_FAN_ARRAY=2;GeometryInfo3D.QUAD_ARRAY=10;GeometryInfo3D.POLYGON_ARRAY=20;GeometryInfo3D.prototype.setCoordinates=function(a){this.vertices=a};GeometryInfo3D.prototype.setCoordinateIndices=function(a){this.coordinatesIndices=a};GeometryInfo3D.prototype.setNormals=function(a){this.normals=a};GeometryInfo3D.prototype.setNormalIndices=function(a){this.normalIndices=a};GeometryInfo3D.prototype.setTextureCoordinates=function(a){this.textureCoordinates=a};GeometryInfo3D.prototype.setTextureCoordinateIndices=function(a){this.textureCoordinateIndices=a};GeometryInfo3D.prototype.setStripCounts=function(a){this.stripCounts=a};GeometryInfo3D.prototype.setContourCounts=function(a){this.contourCounts=a};GeometryInfo3D.prototype.setCreaseAngle=function(a){this.creaseAngle=a};GeometryInfo3D.prototype.setGeneratedNormals=function(a){this.generatedNormals=a};GeometryInfo3D.prototype.computeNormals=function(c,a,k,e){var b;if(this.creaseAngle===undefined){b=44*Math.PI/180}else{b=this.creaseAngle}var n=vec3.create();var m=vec3.create();if(b>0){var g=[];for(var p=0;p<a.length;p+=3){var q=c[a[p+1]];vec3.sub(n,c[a[p+2]],q);vec3.sub(m,c[a[p]],q);var u=vec3.cross(vec3.create(),n,m);for(var o=0;o<3;o++){var t={normal:u};var f=a[p+o];t.nextVertex=g[f];g[f]=t;k.push(u);e.push(k.length-1)}}var l=vec3.create();for(var p=0;p<a.length;p+=3){for(var o=0;o<3;o++){var f=a[p+o];var s=e[p+o];var h=k[s];var u=vec3.create();for(var t=g[f];t!==undefined;t=t.nextVertex){if(t.normal===h){vec3.add(u,u,t.normal)}else{var d=vec3.dot(t.normal,h);if(d>0||b>Math.PI/2){var r=Math.abs(Math.atan2(vec3.length(vec3.cross(l,t.normal,h)),d));if(r<b-0.001){vec3.add(u,u,t.normal)}}}}if(vec3.squaredLength(u)!==0){vec3.normalize(u,u)}else{vec3.copy(u,h);vec3.normalize(u,u)}k[s]=u}}}else{for(var p=0;p<a.length;p+=3){var q=c[a[p+1]];vec3.sub(n,c[a[p+2]],q);vec3.sub(m,c[a[p]],q);var u=vec3.cross(vec3.create(),n,m);vec3.normalize(u,u);var s=k.length-1;if(k.length===0||!vec3.exactEquals(k[s],u)){k.push(u);s++}for(var o=0;o<3;o++){e.push(s)}}}};GeometryInfo3D.prototype.getIndexedGeometryArray=function(){if(this.vertices&&!this.coordinatesIndices){this.coordinatesIndices=new Array(this.vertices.length);if(this.generatedNormals&&(this.creaseAngle===undefined||this.creaseAngle>0)){for(var g=0;g<this.coordinatesIndices.length;g++){for(var f=0;f<this.vertices.length;f++){if(vec3.exactEquals(this.vertices[g],this.vertices[f])){this.coordinatesIndices[g]=f;break}}}}else{for(var g=0;g<this.coordinatesIndices.length;g++){this.coordinatesIndices[g]=g}}}if(this.textureCoordinates&&!this.textureCoordinateIndices){this.textureCoordinateIndices=new Array(this.textureCoordinates.length);for(var g=0;g<this.textureCoordinateIndices.length;g++){this.textureCoordinateIndices[g]=g}}if(this.normals&&!this.normalIndices&&!this.generatedNormals){this.normalIndices=new Array(this.normals.length);for(var g=0;g<this.normalIndices.length;g++){this.normalIndices[g]=g}}var b;var m;var c;if(this.type===GeometryInfo3D.POLYGON_ARRAY){b=[];m=[];c=[];new Triangulator().triangulate(this.vertices,this.coordinatesIndices,this.textureCoordinates?this.textureCoordinateIndices:[],this.normals?this.normalIndices:[],this.stripCounts,b,m,c)}else{if(this.type===GeometryInfo3D.QUAD_ARRAY){b=[];m=[];c=[];for(var g=0;g<this.coordinatesIndices.length;g+=4){b.push(this.coordinatesIndices[g]);b.push(this.coordinatesIndices[g+1]);b.push(this.coordinatesIndices[g+2]);b.push(this.coordinatesIndices[g+2]);b.push(this.coordinatesIndices[g+3]);b.push(this.coordinatesIndices[g]);if(this.textureCoordinateIndices){m.push(this.textureCoordinateIndices[g]);m.push(this.textureCoordinateIndices[g+1]);m.push(this.textureCoordinateIndices[g+2]);m.push(this.textureCoordinateIndices[g+2]);m.push(this.textureCoordinateIndices[g+3]);m.push(this.textureCoordinateIndices[g])}if(this.normalIndices){c.push(this.normalIndices[g]);c.push(this.normalIndices[g+1]);c.push(this.normalIndices[g+2]);c.push(this.normalIndices[g+2]);c.push(this.normalIndices[g+3]);c.push(this.normalIndices[g])}}}else{if(this.type===GeometryInfo3D.TRIANGLE_STRIP_ARRAY){b=[];m=[];c=[];for(var g=0,h=0;g<this.stripCounts.length;g++){var l=this.stripCounts[g];for(var d=0;d<l-2;d++){var e=h+(d%2===0?d+1:d+2);var a=h+(d%2===0?d+2:d+1);b.push(this.coordinatesIndices[h+d]);b.push(this.coordinatesIndices[e]);b.push(this.coordinatesIndices[a]);if(this.textureCoordinateIndices){m.push(this.textureCoordinateIndices[h+d]);m.push(this.textureCoordinateIndices[e]);m.push(this.textureCoordinateIndices[a])}if(this.normalIndices){c.push(this.normalIndices[h+d]);c.push(this.normalIndices[e]);c.push(this.normalIndices[a])}}h+=l}}else{if(this.type===GeometryInfo3D.TRIANGLE_FAN_ARRAY){b=[];m=[];c=[];for(var g=0,h=0;g<this.stripCounts.length;g++){var l=this.stripCounts[g];for(var d=0;d<l-2;d++){b.push(this.coordinatesIndices[h]);b.push(this.coordinatesIndices[h+d+1]);b.push(this.coordinatesIndices[h+d+2]);if(this.textureCoordinateIndices){m.push(this.textureCoordinateIndices[h]);m.push(this.textureCoordinateIndices[h+d+1]);m.push(this.textureCoordinateIndices[h+d+2])}if(this.normalIndices){c.push(this.normalIndices[h]);c.push(this.normalIndices[h+d+1]);c.push(this.normalIndices[h+d+2])}}h+=l}}else{b=this.vertices?this.coordinatesIndices:[];m=this.textureCoordinates?this.textureCoordinateIndices:[];c=this.normals?this.normalIndices:[]}}}}var n;if(this.generatedNormals){n=[];c=[];this.computeNormals(this.vertices,b,n,c)}else{n=this.normals}return new IndexedTriangleArray3D(this.vertices,b,this.textureCoordinates,m,n,c)};function IncorrectFormat3DException(a){this.message=a}function HTMLCanvas3D(d,b){this.scene=null;this.textures=[];this.sharedGeometries=[];this.sceneGeometries=[];this.backgroundGeometries=[];this.lights=[];this.fieldOfView=Math.PI*45/180;this.frontClipDistance=0.1;this.backClipDistance=100;this.projectionPolicy=HTMLCanvas3D.PERSPECTIVE_PROJECTION;this.offscreen=b===true;this.canvas=typeof d==="string"?document.getElementById(d):d;this.gl=this.canvas.getContext("webgl");if(!this.gl){this.gl=this.canvas.getContext("experimental-webgl");if(!this.gl){throw"No WebGL"}}this.updateViewportSize();this.shaderProgram=this.gl.createProgram();var c=this.createShader(this.gl.VERTEX_SHADER,"attribute vec3 vertexPosition;attribute vec3 vertexNormal;attribute vec2 vertexTextureCoord;uniform mat4 modelViewTransform;uniform mat4 projectionTransform;uniform bool textureCoordinatesGenerated;uniform vec4 planeS;uniform vec4 planeT;uniform mat3 textureCoordTransform;uniform mat3 normalTransform;uniform bool ignoreNormal;uniform bool backFaceNormalFlip;uniform bool lightingEnabled;uniform bool useTextures;varying vec2 varTextureCoord;varying vec4 varVertexPosition;varying vec3 varTransformedNormal;void main(void) {  varVertexPosition = modelViewTransform * vec4(vertexPosition, 1.0);  gl_Position = projectionTransform * varVertexPosition;  if (useTextures) {    if (textureCoordinatesGenerated) {      varTextureCoord = vec2(vertexPosition.x * planeS.x + vertexPosition.y * planeS.y          + vertexPosition.z * planeS.z + planeS.w,            vertexPosition.x * planeT.x + vertexPosition.y * planeT.y          + vertexPosition.z * planeT.z + planeT.w);    } else {      varTextureCoord = vec2(vertexTextureCoord);    }    varTextureCoord = vec2(textureCoordTransform * vec3(varTextureCoord, 1));  }  if (lightingEnabled) {    vec3 normal;    if (ignoreNormal) {      normal = vec3(1., 1., 1.);    } else {      normal = vertexNormal;      if (backFaceNormalFlip) {        normal = -normal;      }    }    varTransformedNormal = normalize(normalTransform * normal);  }}");this.gl.attachShader(this.shaderProgram,c);var a=this.createShader(this.gl.FRAGMENT_SHADER,"precision mediump float;uniform vec3  vertexDiffuseColor;uniform vec3  vertexSpecularColor;uniform float shininess;uniform sampler2D sampler;uniform float alpha;uniform bool  useTextures;uniform bool  lightingEnabled;uniform vec3  ambientColor;uniform int   directionalLightCount;uniform vec3  lightDirections["+HTMLCanvas3D.MAX_DIRECTIONAL_LIGHT+"];uniform vec3  directionalLightColors["+HTMLCanvas3D.MAX_DIRECTIONAL_LIGHT+"];varying vec2  varTextureCoord;varying vec4  varVertexPosition;varying vec3  varTransformedNormal;void main(void) {  vec3 lightWeight;  if (lightingEnabled) {    lightWeight = ambientColor;    if (directionalLightCount > 0) {      vec3 diffuseLightWeight = vec3(0., 0., 0.);      vec3 specularLightWeight = vec3(0., 0., 0.);      vec3 eyeDirection = vec3(0., 0., 0.);      bool computeSpecularLightWeight = false;      if (vertexSpecularColor.r > 0.          && vertexSpecularColor.g > 0.          && vertexSpecularColor.b > 0.) {        eyeDirection = normalize(-varVertexPosition.xyz);        computeSpecularLightWeight = length(eyeDirection) <= 1.0001;      }      for (int i = 0; i < "+HTMLCanvas3D.MAX_DIRECTIONAL_LIGHT+"; i++) {        if (i >= directionalLightCount) {          break;        }        float directionalLightWeight = max(dot(varTransformedNormal, lightDirections[i]), 0.);        diffuseLightWeight += directionalLightColors[i] * directionalLightWeight;        if (computeSpecularLightWeight) {          vec3 reflectionDirection = reflect(-lightDirections[i], varTransformedNormal);          specularLightWeight += directionalLightColors[i] * pow(max(dot(reflectionDirection, eyeDirection), 0.), shininess);        }      }      lightWeight += vertexDiffuseColor * diffuseLightWeight;      if (computeSpecularLightWeight) {        lightWeight += vertexSpecularColor * specularLightWeight;      }    }  } else {    lightWeight = vertexDiffuseColor;  }  vec4 fragmentColor;  if (useTextures) {    fragmentColor = texture2D(sampler, vec2(varTextureCoord.s, varTextureCoord.t));  } else {    fragmentColor = vec4(1., 1., 1., 1.);  }  gl_FragColor = vec4(fragmentColor.rgb * lightWeight * alpha, fragmentColor.a * alpha);}");this.gl.attachShader(this.shaderProgram,a);this.gl.linkProgram(this.shaderProgram);this.shaderProgram.vertexPositionAttribute=this.gl.getAttribLocation(this.shaderProgram,"vertexPosition");this.shaderProgram.normalAttribute=this.gl.getAttribLocation(this.shaderProgram,"vertexNormal");this.shaderProgram.textureCoordAttribute=this.gl.getAttribLocation(this.shaderProgram,"vertexTextureCoord");this.shaderProgram.projectionTransform=this.gl.getUniformLocation(this.shaderProgram,"projectionTransform");this.shaderProgram.modelViewTransform=this.gl.getUniformLocation(this.shaderProgram,"modelViewTransform");this.shaderProgram.textureCoordinatesGenerated=this.gl.getUniformLocation(this.shaderProgram,"textureCoordinatesGenerated");this.shaderProgram.planeS=this.gl.getUniformLocation(this.shaderProgram,"planeS");this.shaderProgram.planeT=this.gl.getUniformLocation(this.shaderProgram,"planeT");this.shaderProgram.textureCoordTransform=this.gl.getUniformLocation(this.shaderProgram,"textureCoordTransform");this.shaderProgram.normalTransform=this.gl.getUniformLocation(this.shaderProgram,"normalTransform");this.shaderProgram.ignoreNormal=this.gl.getUniformLocation(this.shaderProgram,"ignoreNormal");this.shaderProgram.backFaceNormalFlip=this.gl.getUniformLocation(this.shaderProgram,"backFaceNormalFlip");this.shaderProgram.ambientColor=this.gl.getUniformLocation(this.shaderProgram,"ambientColor");this.shaderProgram.lightingEnabled=this.gl.getUniformLocation(this.shaderProgram,"lightingEnabled");this.shaderProgram.directionalLightCount=this.gl.getUniformLocation(this.shaderProgram,"directionalLightCount");this.shaderProgram.lightDirections=this.gl.getUniformLocation(this.shaderProgram,"lightDirections");this.shaderProgram.directionalLightColors=this.gl.getUniformLocation(this.shaderProgram,"directionalLightColors");this.shaderProgram.vertexDiffuseColor=this.gl.getUniformLocation(this.shaderProgram,"vertexDiffuseColor");this.shaderProgram.vertexSpecularColor=this.gl.getUniformLocation(this.shaderProgram,"vertexSpecularColor");this.shaderProgram.shininess=this.gl.getUniformLocation(this.shaderProgram,"shininess");this.shaderProgram.alpha=this.gl.getUniformLocation(this.shaderProgram,"alpha");this.shaderProgram.useTextures=this.gl.getUniformLocation(this.shaderProgram,"useTextures");this.gl.useProgram(this.shaderProgram);this.viewPlatformTransform=mat4.create();mat4.translate(this.viewPlatformTransform,this.viewPlatformTransform,[0,0,-2.4]);this.geometryAmbientColor=vec3.create();this.geometrySpecularColor=vec3.create();this.geometryModelViewTransform=mat4.create();this.geometryNormalTransform=mat3.create();this.shaderAmbientColor=vec3.create();this.gl.uniform3fv(this.shaderProgram.ambientColor,this.shaderAmbientColor);this.shaderSpecularColor=vec3.create();this.gl.uniform3fv(this.shaderProgram.vertexSpecularColor,this.shaderSpecularColor);this.geometryDiffuseColor=vec3.create();this.shaderDiffuseColor=vec3.fromValues(1,1,1);this.gl.uniform3fv(this.shaderProgram.vertexDiffuseColor,this.shaderDiffuseColor);this.shaderModelViewTransform=mat4.create();this.gl.uniformMatrix4fv(this.shaderProgram.modelViewTransform,false,this.shaderModelViewTransform);this.shaderNormalTransform=mat3.create();this.gl.uniformMatrix3fv(this.shaderProgram.normalTransform,false,this.shaderNormalTransform);this.shaderTextureTransform=mat3.create();this.gl.uniformMatrix3fv(this.shaderProgram.textureCoordTransform,false,this.shaderTextureTransform);this.shaderLightingEnabled=true;this.gl.uniform1i(this.shaderProgram.lightingEnabled,this.shaderLightingEnabled);this.shaderShininess=1;this.gl.uniform1f(this.shaderProgram.shininess,this.shaderShininess);this.shaderIgnoreNormal=false;this.gl.uniform1i(this.shaderProgram.ignoreNormal,this.shaderIgnoreNormal);this.shaderBackFaceNormalFlip=false;this.gl.uniform1i(this.shaderProgram.backFaceNormalFlip,this.shaderBackFaceNormalFlip);this.shaderTextureCoordinatesGenerated=false;this.gl.uniform1i(this.shaderProgram.textureCoordinatesGenerated,false);this.shaderUseTextures=false;this.gl.uniform1i(this.shaderProgram.useTextures,false);this.shaderAlpha=1;this.gl.uniform1f(this.shaderProgram.alpha,this.shaderAlpha);this.gl.enable(this.gl.CULL_FACE);this.gl.cullFace(this.gl.BACK);this.canvasNeededRepaint=false;this.pickingFrameBufferNeededRepaint=true;this.errorTexture=this.gl.createTexture();this.gl.bindTexture(this.gl.TEXTURE_2D,this.errorTexture);var e=new Uint8Array([255,0,0,255]);this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,1,1,0,this.gl.RGBA,this.gl.UNSIGNED_BYTE,e);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MAG_FILTER,this.gl.LINEAR);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.LINEAR);this.gl.bindTexture(this.gl.TEXTURE_2D,null)}HTMLCanvas3D.MAX_DIRECTIONAL_LIGHT=16;HTMLCanvas3D.VEC4_DEFAULT_PLANE_S=vec4.fromValues(1,0,0,0);HTMLCanvas3D.VEC4_DEFAULT_PLANE_T=vec4.fromValues(0,1,0,0);HTMLCanvas3D.MAT3_IDENTITY=mat3.create();HTMLCanvas3D.PARALLEL_PROJECTION=0;HTMLCanvas3D.PERSPECTIVE_PROJECTION=1;HTMLCanvas3D.prototype.createShader=function(a,c){var b=this.gl.createShader(a);this.gl.shaderSource(b,c);this.gl.compileShader(b);if(!this.gl.getShaderParameter(b,this.gl.COMPILE_STATUS)){throw"Invalid shader: "+c}return b};HTMLCanvas3D.prototype.getCanvas=function(){return this.canvas};HTMLCanvas3D.prototype.getHTMLElement=function(){return this.getCanvas()};HTMLCanvas3D.prototype.getDepthBits=function(){return this.gl.getParameter(this.gl.DEPTH_BITS)};HTMLCanvas3D.prototype.setFieldOfView=function(a){if(this.fieldOfView!=a){this.fieldOfView=a;this.repaint()}};HTMLCanvas3D.prototype.setFrontClipDistance=function(a){if(this.frontClipDistance!=a){this.frontClipDistance=a;this.repaint()}};HTMLCanvas3D.prototype.setBackClipDistance=function(a){if(this.backClipDistance!=a){this.backClipDistance=a;this.repaint()}};HTMLCanvas3D.prototype.getViewPlatformTransform=function(a){return mat4.copy(a,this.viewPlatformTransform)};HTMLCanvas3D.prototype.setViewPlatformTransform=function(a){if(this.viewPlatformTransform!=a){this.viewPlatformTransform=a;this.repaint()}};HTMLCanvas3D.prototype.updateViewportSize=function(){var c;try{c=this.canvas.getBoundingClientRect()}catch(a){c={width:this.canvas.width,height:this.canvas.height}}var b=c.width!==0&&c.height!==0;if(!b){c={width:this.canvas.width,height:this.canvas.height}}if(this.viewportWidth!=c.width||this.viewportHeight!=c.height){this.viewportWidth=c.width;this.viewportHeight=c.height;this.canvas.width=this.viewportWidth;this.canvas.height=this.viewportHeight;if(this.pickingFrameBuffer!==undefined){this.gl.deleteFramebuffer(this.pickingFrameBuffer);delete this.pickingFrameBuffer}if(b){this.repaint()}}};HTMLCanvas3D.prototype.setScene=function(f,c){var a=[];var d=[];var g=[];var b=[];var h=this.countDisplayedGeometries(f);this.prepareScene(f,a,d,g,false,[],b,mat4.create(),c,h);this.scene=f;this.sharedGeometries=a;this.sceneGeometries=d;this.backgroundGeometries=g;this.lights=b;if(this.offscreen){this.canvasNeededRepaint=true;if(c!==undefined){c(ModelLoader.BINDING_MODEL,"",1)}}else{var e=this;setTimeout(function(){if(c!==undefined){c(ModelLoader.BINDING_MODEL,"",1)}e.drawScene()},0)}};HTMLCanvas3D.prototype.getScene=function(){return this.scene};HTMLCanvas3D.prototype.countDisplayedGeometries=function(c){if(c instanceof Group3D){var d=0;var b=c.getChildren();for(var a=0;a<b.length;a++){d+=this.countDisplayedGeometries(b[a])}return d}else{if(c instanceof Link3D){return this.countDisplayedGeometries(c.getSharedGroup())}else{if(c instanceof Shape3D){return c.getGeometries().length}else{return 0}}}};HTMLCanvas3D.DEFAULT_APPEARANCE=new Appearance3D();HTMLCanvas3D.prototype.prepareScene=function(l,c,j,e,o,p,q,f,k,d){var s=this;if(l instanceof Group3D){if(l instanceof TransformGroup3D){var m=mat4.create();l.getTransform(m);f=mat4.mul(mat4.create(),f,m);if(l.getCapability(TransformGroup3D.ALLOW_TRANSFORM_WRITE)){l.addPropertyChangeListener("TRANSFORM",{propertyChange:function(v){var u=l.getChildren();for(var t=0;t<u.length;t++){s.updateChildrenTransformation(u[t],o?e:j,p,q,s.getTransformFromRoot(l))}s.repaint()}})}}var b=l.getChildren();for(var n=0;n<b.length;n++){this.prepareScene(b[n],c,j,e,o,p,q,f,k,d)}if(l.getCapability(Group3D.ALLOW_CHILDREN_EXTEND)){l.addChildrenListener({childAdded:function(i){s.prepareScene(i.child,c,j,e,o,p,q,s.getTransformFromRoot(l));s.repaint()},childRemoved:function(i){s.removeDisplayedItems(i.child,c,o?e:j,q);s.removeNodeListeners(i.child);s.repaint()}})}}else{if(l instanceof Link3D){p=p.slice(0);p.push(l);this.prepareScene(l.getSharedGroup(),c,j,e,o,p,q,f,k,d)}else{if(l instanceof Shape3D){if(k!==undefined&&!o&&Math.floor((j.length-1)/d*10)<Math.floor(j.length/d*10)){k(ModelLoader.BINDING_MODEL,"",j.length/d)}var r=l.getAppearance();if(!r){r=HTMLCanvas3D.DEFAULT_APPEARANCE}var h=null;if(r.getTextureImage()){h=this.prepareTexture(r.getTextureImage())}var g=l.getGeometries();for(var n=0;n<g.length;n++){this.prepareGeometry(g[n],r,h,l,c,j,e,o,p,f)}if(l.getCapability(Shape3D.ALLOW_GEOMETRY_WRITE)){l.addPropertyChangeListener("GEOMETRY",{propertyChange:function(w){if(w.getOldValue()){removedGeometry=w.getOldValue();for(var u=0;u<j.length;u++){var x=j[u];if(x.nodeGeometry===removedGeometry){s.clearGeometryBuffers(x);j.splice(u,1);break}}}if(w.getNewValue()){addedGeometry=w.getNewValue();var t=l.getAppearance();if(!t){t=HTMLCanvas3D.DEFAULT_APPEARANCE}var v=null;if(t.getTextureImage()){v=s.prepareTexture(t.getTextureImage())}s.prepareGeometry(addedGeometry,t,v,l,c,j,e,o,p,s.getTransformFromRoot(l))}}})}if(r!==HTMLCanvas3D.DEFAULT_APPEARANCE){r.addPropertyChangeListener({propertyChange:function(w){var v=o?e:j;for(var u=0;u<v.length;u++){var y=v[u];if(y.node===l){var x=w.getNewValue();switch(w.getPropertyName()){case"AMBIENT_COLOR":y.ambientColor=x;break;case"DIFFUSE_COLOR":y.diffuseColor=x;break;case"SPECULAR_COLOR":y.specularColor=x;break;case"SHININESS":y.shininess=x;break;case"TRANSPARENCY":y.transparency=x!=null?1-x:1;break;case"ILLUMINATION":y.lightingEnabled=(x==null||x>=1)&&y.mode===s.gl.TRIANGLES;break;case"TEXTURE_IMAGE":y.texture=x!=null?s.prepareTexture(x):undefined;break;case"TEXTURE_COORDINATES_GENERATION":var t=x;y.textureCoordinatesGeneration=t;break;case"TEXTURE_TRANSFORM":y.textureTransform=x;break;case"VISIBLE":y.visible=x!==false;break;case"CULL_FACE":y.cullFace=x;break;case"BACK_FACE_NORMAL_FLIP":y.backFaceNormalFlip=x===true;break}}}s.repaint()}})}}else{if(l instanceof Background3D){this.prepareScene(l.getGeometry(),c,j,e,true,p,q,f)}else{if(l instanceof Light3D){var a={node:l,color:l.getColor()};if(l instanceof DirectionalLight3D){a.direction=l.getDirection();a.transform=f}q.push(a);l.addPropertyChangeListener("COLOR",{canvas3D:s,propertyChange:function(v){for(var u=0;u<q.length;u++){var t=q[u];if(q[u].node===l){t.color=v.getNewValue();break}}s.repaint()}})}}}}}};HTMLCanvas3D.prototype.getTransformFromRoot=function(c){var b=mat4.create();if(c instanceof TransformGroup3D){c.getTransform(b)}if(c!==null){var a=c.getParent();if(a instanceof Group3D){mat4.mul(b,this.getTransformFromRoot(a),b)}}return b};HTMLCanvas3D.prototype.prepareGeometry=function(f,y,n,q,d,o,g,u,w,j){var b=null;if(!q.getCapability(Shape3D.ALLOW_GEOMETRY_WRITE)){for(var s=0;s<d.length;s++){if(d[s].nodeGeometry===f){b={node:q,center:d[s].center,nodeGeometry:f,vertexCount:d[s].vertexCount,vertexBuffer:d[s].vertexBuffer,textureCoordinatesBuffer:d[s].textureCoordinatesBuffer,normalBuffer:d[s].normalBuffer,mode:d[s].mode};d[s].referenceCount++;break}}}if(b===null){var e=q.getBounds();var x=vec3.create();e.getLower(x);var t=vec3.create();e.getUpper(t);var v=vec3.fromValues((x[0]+t[0])/2,(x[1]+t[1])/2,(x[2]+t[2])/2);b={node:q,center:v,nodeGeometry:f,vertexCount:f.vertexIndices.length};b.vertexBuffer=this.prepareBuffer(f.vertices,f.vertexIndices);if(f.hasTextureCoordinates()){b.textureCoordinatesBuffer=this.prepareBuffer(f.textureCoordinates,f.textureCoordinateIndices)}else{b.textureCoordinatesBuffer=null}if(f instanceof IndexedTriangleArray3D){b.mode=this.gl.TRIANGLES;b.normalBuffer=this.prepareBuffer(f.normals,f.normalIndices)}else{b.mode=this.gl.LINES}if(!q.getCapability(Shape3D.ALLOW_GEOMETRY_WRITE)){d.push({nodeGeometry:f,center:v,vertexCount:b.vertexCount,vertexBuffer:b.vertexBuffer,textureCoordinatesBuffer:b.textureCoordinatesBuffer,normalBuffer:b.normalBuffer,mode:b.mode,referenceCount:1})}}b.transform=j;if(w.length>0){b.parentLinks=w}var c=y.getAmbientColor();if(c!==undefined){b.ambientColor=c}var m=y.getDiffuseColor();if(m!==undefined){b.diffuseColor=m}var h=y.getSpecularColor();if(h!==undefined){b.specularColor=h}var r=y.getShininess();if(r!==undefined){b.shininess=r}var p=y.getTextureCoordinatesGeneration();if(p!==undefined){b.textureCoordinatesGeneration=p}var l=y.getTextureTransform();if(l!==undefined){b.textureTransform=l}if(n!==null){b.texture=n}b.backFaceNormalFlip=y.isBackFaceNormalFlip();if(y.getCullFace()!==undefined){b.cullFace=y.getCullFace()}var a=y.getIllumination();b.lightingEnabled=(a==null||a>=1)&&b.normalBuffer!==null;b.transparency=y.getTransparency()!=null?1-y.getTransparency():1;b.visible=y.isVisible();var k=u?g:o;k.push(b)};HTMLCanvas3D.prototype.updateChildrenTransformation=function(d,a,l,f,k){var c=this;if(d instanceof Group3D){if(d instanceof TransformGroup3D){var m=mat4.create();d.getTransform(m);k=mat4.mul(mat4.create(),k,m)}var b=d.getChildren();for(var g=0;g<b.length;g++){this.updateChildrenTransformation(b[g],a,l,f,k)}}else{if(d instanceof Link3D){l=l.slice(0);l.push(d);this.updateChildrenTransformation(d.getSharedGroup(),a,l,f,k)}else{if(d instanceof Shape3D){for(var g=0;g<a.length;g++){if(a[g].node===d){var h=a[g].parentLinks===undefined;if(!h){if(a[g].parentLinks.length===l.length){var e;for(e=0;e<l.length;e++){if(a[g].parentLinks[e]!==l[e]){break}}h=e===l.length}}if(h){a[g].transform=k;break}}}}else{if(d instanceof Light3D){for(var g=0;g<f.length;g++){if(f[g].node===d){f[g].transform=k;break}}}}}}};HTMLCanvas3D.prototype.removeDisplayedItems=function(c,h,a,f){if(c instanceof Group3D){var b=c.getChildren();for(var g=0;g<b.length;g++){this.removeDisplayedItems(b[g],h,a,f)}}else{if(c instanceof Link3D){this.removeDisplayedItems(c.getSharedGroup(),h,a,f)}else{if(c instanceof Shape3D){var k=c.getGeometries().length;for(var g=a.length-1;k>0&&g>=0;g--){var l=a[g];if(l.node===c){if(c.getCapability(Shape3D.ALLOW_GEOMETRY_WRITE)){this.clearGeometryBuffers(l)}else{for(var e=0;e<h.length;e++){var d=h[e];if(d.nodeGeometry===l.nodeGeometry){if(--d.referenceCount===0){this.clearGeometryBuffers(l);h.splice(e,1)}break}}}a.splice(g,1);k--}}}else{if(c instanceof Light3D){for(var g=0;g<f.length;g++){if(f[g].node===c){f.splice(g,1);break}}}}}}};HTMLCanvas3D.prototype.removeNodeListeners=function(d){var c=d.getPropertyChangeListeners();for(var b=0;b<c.length;b++){if(c[b].canvas3D===this){d.removePropertyChangeListener(c[b])}}if(d instanceof Group3D){c=d.getChildrenListeners();for(var b=0;b<c.length;b++){if(c[b].canvas3D===this){d.removeChildrenListener(c[b])}}var a=d.getChildren();for(var b=0;b<a.length;b++){this.removeNodeListeners(a[b])}}else{if(d instanceof Link3D){this.removeNodeListeners(d.getSharedGroup())}}};HTMLCanvas3D.prototype.prepareTexture=function(a){if(a.url!==undefined){for(var b=0;b<this.textures.length;b++){if(this.textures[b].image.url==a.url){return this.textures[b]}}}var c=this.gl.createTexture();if(c!==null){c.image=a;if(a.width!==0){this.bindTextureAndRepaint(c,true)}else{var d=this;var e=function(){a.removeEventListener("load",e);d.bindTextureAndRepaint(c,false)};a.addEventListener("load",e)}this.textures.push(c);return c}else{console.log("Can't create texture");return this.errorTexture}};HTMLCanvas3D.resizeTransparentTextures=true;HTMLCanvas3D.prototype.bindTextureAndRepaint=function(d,c){if((!Appearance3D.isPowerOfTwo(d.image.naturalWidth)||!Appearance3D.isPowerOfTwo(d.image.naturalHeight))&&(!d.image.transparent||HTMLCanvas3D.resizeTransparentTextures)){var a=document.createElement("canvas");a.width=Appearance3D.getNextHighestPowerOfTwo(d.image.naturalWidth);a.height=Appearance3D.getNextHighestPowerOfTwo(d.image.naturalHeight);var b=a.getContext("2d");b.drawImage(d.image,0,0,d.image.naturalWidth,d.image.naturalHeight,0,0,a.width,a.height);var f=new Image();f.crossOrigin="anonymous";f.url=d.image.url;f.transparent=d.image.transparent;var e=this;var g=function(){f.removeEventListener("load",g);e.bindTexture(d);e.repaint()};f.addEventListener("load",g);f.src=a.toDataURL();d.image=f}else{this.bindTexture(d);if(!c){this.repaint()}}};HTMLCanvas3D.prototype.bindTexture=function(a){this.gl.bindTexture(this.gl.TEXTURE_2D,a);this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,true);this.gl.pixelStorei(this.gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,true);this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.image);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MAG_FILTER,this.gl.LINEAR);if(Appearance3D.isPowerOfTwo(a.image.naturalWidth)&&Appearance3D.isPowerOfTwo(a.image.naturalHeight)){this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.LINEAR_MIPMAP_NEAREST);this.gl.generateMipmap(this.gl.TEXTURE_2D)}else{this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.LINEAR);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_WRAP_S,this.gl.CLAMP_TO_EDGE);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_WRAP_T,this.gl.CLAMP_TO_EDGE)}this.gl.bindTexture(this.gl.TEXTURE_2D,null);delete a.image.src;a.image.bound=true};HTMLCanvas3D.prototype.prepareBuffer=function(e,g){if(g.length>0&&e.length>0){var b=this.gl.createBuffer();this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b);var f=e[0].length;var a=new Float32Array(g.length*f);for(var d=0,c=0;d<g.length;d++,c+=f){a.set(e[g[d]],c)}this.gl.bufferData(this.gl.ARRAY_BUFFER,a,this.gl.STATIC_DRAW);return b}else{return null}};HTMLCanvas3D.prototype.drawScene=function(){this.gl.viewport(0,0,this.viewportWidth,this.viewportHeight);var k=getComputedStyle(this.canvas).backgroundColor;if(k==""){k=this.canvas.style.backgroundColor}k=k.substring(4,k.length-1).replace(/ /g,"").split(",");this.gl.clearColor(k[0]/256,k[1]/256,k[2]/256,k.length===4?k[3]:1);this.gl.clear(this.gl.COLOR_BUFFER_BIT|this.gl.DEPTH_BUFFER_BIT);if(this.scene!==null){var b=vec3.create();var h=0;var v=[];var s=[];var d=mat4.invert(mat4.create(),this.viewPlatformTransform);var o=mat4.create();for(var r=0;r<this.lights.length;r++){var g=this.lights[r];if(g.direction!==undefined){var a=vec3.transformMat3(vec3.create(),g.direction,mat3.fromMat4(mat3.create(),mat4.mul(o,d,g.transform)));vec3.normalize(a,a);vec3.negate(a,a);v.push.apply(v,g.color);s.push.apply(s,a);h++}else{vec3.add(b,b,g.color)}}this.gl.uniform1i(this.shaderProgram.directionalLightCount,h);if(h<HTMLCanvas3D.MAX_DIRECTIONAL_LIGHT){var f=new Array((HTMLCanvas3D.MAX_DIRECTIONAL_LIGHT-h)*3);for(var q=0;q<f.length;q++){f[q]=0}v.push.apply(v,f);s.push.apply(s,f)}this.gl.uniform3fv(this.shaderProgram.directionalLightColors,v);this.gl.uniform3fv(this.shaderProgram.lightDirections,s);var w=2*Math.atan(this.viewportHeight/this.viewportWidth*Math.tan(this.fieldOfView/2));var n=mat4.create();if(this.projectionPolicy===HTMLCanvas3D.PARALLEL_PROJECTION){mat4.ortho(n,-1,1,-1,1,0.001,1)}else{mat4.perspective(n,w,this.viewportWidth/this.viewportHeight,0.001,1)}this.gl.uniformMatrix4fv(this.shaderProgram.projectionTransform,false,n);var m=mat4.clone(this.viewPlatformTransform);m[12]=0;m[13]=0;m[14]=0;var p=mat4.invert(mat4.create(),m);for(var r=0;r<this.backgroundGeometries.length;r++){var t=this.backgroundGeometries[r];this.drawGeometry(t,p,b,t.lightingEnabled,true,true)}this.gl.clear(this.gl.DEPTH_BUFFER_BIT);this.getVirtualWorldToImageTransform(n);this.gl.uniformMatrix4fv(this.shaderProgram.projectionTransform,false,n);this.gl.enable(this.gl.DEPTH_TEST);var c=[];for(var r=0;r<this.sceneGeometries.length;r++){var l=this.sceneGeometries[r];if(l.visible){if((l.transparency===undefined||l.transparency===1)&&(l.texture===undefined||l.texture.image===undefined||!l.texture.image.transparent)){this.drawGeometry(l,d,b,l.lightingEnabled,true,true)}else{if(l.transparency>0){c.push(l)}}}}this.gl.enable(this.gl.BLEND);this.gl.blendFunc(this.gl.ONE,this.gl.ONE_MINUS_SRC_ALPHA);var u=vec3.create();for(var r=0;r<c.length;r++){var l=c[r];vec3.transformMat4(u,l.center,l.transform);vec3.transformMat4(u,u,d);l.zOrder=u[2]}c.sort(function(j,i){return j.zOrder-i.zOrder});for(var r=0;r<c.length;r++){var l=c[r];this.drawGeometry(l,d,b,l.lightingEnabled,true,true)}}var e=Date.now();if(Math.floor(e/1000)>Math.floor(this.lastDrawSceneTime/1000)){this.framesPerSecond=Math.round(this.drawnFrameCount/(e-this.previousFramesPerSecondTime)*10000)/10;this.previousFramesPerSecondTime=e;this.drawnFrameCount=0}if(this.drawnFrameCount===undefined){this.previousFramesPerSecondTime=e;this.drawnFrameCount=0}this.drawnFrameCount++;this.lastDrawSceneTime=e};HTMLCanvas3D.prototype.drawGeometry=function(h,d,b,f,a,c){if(h.cullFace!==this.shaderCullFace){this.shaderCullFace=h.cullFace;if(this.shaderCullFace!==undefined){if(this.shaderCullFace===Appearance3D.CULL_NONE){this.gl.disable(this.gl.CULL_FACE)}else{this.gl.enable(this.gl.CULL_FACE);this.gl.cullFace(this.shaderCullFace===Appearance3D.CULL_BACK?this.gl.BACK:this.gl.FRONT)}}else{this.gl.enable(this.gl.CULL_FACE);this.gl.cullFace(this.gl.BACK)}}mat4.copy(this.geometryModelViewTransform,d);mat4.mul(this.geometryModelViewTransform,this.geometryModelViewTransform,h.transform);if(!mat4.exactEquals(this.shaderModelViewTransform,this.geometryModelViewTransform)){mat4.copy(this.shaderModelViewTransform,this.geometryModelViewTransform);this.gl.uniformMatrix4fv(this.shaderProgram.modelViewTransform,false,this.shaderModelViewTransform)}if(this.shaderLightingEnabled!==f){this.shaderLightingEnabled=f;this.gl.uniform1i(this.shaderProgram.lightingEnabled,this.shaderLightingEnabled)}if(f){if(h.ambientColor!==undefined&&h.texture===undefined){vec3.mul(this.geometryAmbientColor,h.ambientColor,b)}else{vec3.set(this.geometryAmbientColor,0,0,0)}if(!vec3.exactEquals(this.shaderAmbientColor,this.geometryAmbientColor)){vec3.copy(this.shaderAmbientColor,this.geometryAmbientColor);this.gl.uniform3fv(this.shaderProgram.ambientColor,this.shaderAmbientColor)}if(!this.ignoreShininess&&h.specularColor!==undefined&&h.shininess!==undefined){if(this.shaderShininess!==h.shininess){this.shaderShininess=h.shininess;this.gl.uniform1f(this.shaderProgram.shininess,this.shaderShininess)}vec3.copy(this.geometrySpecularColor,h.specularColor)}else{vec3.set(this.geometrySpecularColor,0,0,0)}if(!vec3.exactEquals(this.shaderSpecularColor,this.geometrySpecularColor)){vec3.copy(this.shaderSpecularColor,this.geometrySpecularColor);this.gl.uniform3fv(this.shaderProgram.vertexSpecularColor,this.shaderSpecularColor)}mat3.fromMat4(this.geometryNormalTransform,this.geometryModelViewTransform);if(!mat3.exactEquals(this.shaderNormalTransform,this.geometryNormalTransform)){mat3.copy(this.shaderNormalTransform,this.geometryNormalTransform);this.gl.uniformMatrix3fv(this.shaderProgram.normalTransform,false,this.shaderNormalTransform)}if(this.shaderIgnoreNormal!==(h.mode===this.gl.LINES)){this.shaderIgnoreNormal=h.mode===this.gl.LINES;this.gl.uniform1i(this.shaderProgram.ignoreNormal,this.shaderIgnoreNormal)}if(this.shaderBackFaceNormalFlip!==h.backFaceNormalFlip){this.shaderBackFaceNormalFlip=h.backFaceNormalFlip;this.gl.uniform1i(this.shaderProgram.backFaceNormalFlip,this.shaderBackFaceNormalFlip)}}vec3.set(this.geometryDiffuseColor,1,1,1);if(a&&h.texture!==undefined&&(h.texture.image===undefined||h.texture.image.bound)){this.gl.activeTexture(this.gl.TEXTURE0);if(h.textureCoordinatesGeneration){this.gl.uniform4fv(this.shaderProgram.planeS,h.textureCoordinatesGeneration.planeS);this.gl.uniform4fv(this.shaderProgram.planeT,h.textureCoordinatesGeneration.planeT);if(!this.shaderTextureCoordinatesGenerated){this.shaderTextureCoordinatesGenerated=true;this.gl.uniform1i(this.shaderProgram.textureCoordinatesGenerated,true)}}else{if(h.textureCoordinatesBuffer===null){this.gl.uniform4fv(this.shaderProgram.planeS,HTMLCanvas3D.VEC4_DEFAULT_PLANE_S);this.gl.uniform4fv(this.shaderProgram.planeT,HTMLCanvas3D.VEC4_DEFAULT_PLANE_T);if(!this.shaderTextureCoordinatesGenerated){this.shaderTextureCoordinatesGenerated=true;this.gl.uniform1i(this.shaderProgram.textureCoordinatesGenerated,true)}}else{if(this.shaderTextureCoordinatesGenerated){this.shaderTextureCoordinatesGenerated=false;this.gl.uniform1i(this.shaderProgram.textureCoordinatesGenerated,false)}}}var e=h.textureTransform!==undefined?h.textureTransform:HTMLCanvas3D.MAT3_IDENTITY;if(!mat3.exactEquals(this.shaderTextureTransform,e)){mat3.copy(this.shaderTextureTransform,e);this.gl.uniformMatrix3fv(this.shaderProgram.textureCoordTransform,false,this.shaderTextureTransform)}this.gl.bindTexture(this.gl.TEXTURE_2D,h.texture);if(!this.shaderUseTextures){this.shaderUseTextures=true;this.gl.uniform1i(this.shaderProgram.useTextures,true)}}else{if(this.shaderTextureCoordinatesGenerated){this.shaderTextureCoordinatesGenerated=false;this.gl.uniform1i(this.shaderProgram.textureCoordinatesGenerated,false)}if(this.shaderUseTextures){this.shaderUseTextures=false;this.gl.uniform1i(this.shaderProgram.useTextures,false)}if(h.diffuseColor!==undefined){vec3.copy(this.geometryDiffuseColor,h.diffuseColor)}}if(!vec3.exactEquals(this.shaderDiffuseColor,this.geometryDiffuseColor)){vec3.copy(this.shaderDiffuseColor,this.geometryDiffuseColor);this.gl.uniform3fv(this.shaderProgram.vertexDiffuseColor,this.shaderDiffuseColor)}this.gl.enableVertexAttribArray(this.shaderProgram.vertexPositionAttribute);this.gl.bindBuffer(this.gl.ARRAY_BUFFER,h.vertexBuffer);this.gl.vertexAttribPointer(this.shaderProgram.vertexPositionAttribute,3,this.gl.FLOAT,false,0,0);if(f&&h.mode===this.gl.TRIANGLES){this.gl.enableVertexAttribArray(this.shaderProgram.normalAttribute);this.gl.bindBuffer(this.gl.ARRAY_BUFFER,h.normalBuffer);this.gl.vertexAttribPointer(this.shaderProgram.normalAttribute,3,this.gl.FLOAT,false,0,0)}else{this.gl.disableVertexAttribArray(this.shaderProgram.normalAttribute)}if(a&&h.textureCoordinatesBuffer!==null&&h.texture!==undefined){this.gl.enableVertexAttribArray(this.shaderProgram.textureCoordAttribute);this.gl.bindBuffer(this.gl.ARRAY_BUFFER,h.textureCoordinatesBuffer);this.gl.vertexAttribPointer(this.shaderProgram.textureCoordAttribute,2,this.gl.FLOAT,false,0,0)}else{this.gl.disableVertexAttribArray(this.shaderProgram.textureCoordAttribute)}var g=h.transparency&&c?h.transparency:1;if(this.shaderAlpha!==g){this.shaderAlpha=g;this.gl.uniform1f(this.shaderProgram.alpha,this.shaderAlpha)}this.gl.drawArrays(h.mode,0,h.vertexCount)};HTMLCanvas3D.prototype.getFramesPerSecond=function(){return this.framesPerSecond};HTMLCanvas3D.prototype.repaint=function(){if(!this.canvasNeededRepaint){this.canvasNeededRepaint=true;if(!this.offscreen){var a=this;requestAnimationFrame(function(){if(a.canvasNeededRepaint){a.drawScene();a.canvasNeededRepaint=false;a.pickingFrameBufferNeededRepaint=true}})}}};HTMLCanvas3D.prototype.getVirtualWorldToImageTransform=function(b,a){if(a===undefined){a=this.viewportWidth/this.viewportHeight}var c=2*Math.atan(Math.tan(this.fieldOfView/2)/a);if(this.projectionPolicy===HTMLCanvas3D.PARALLEL_PROJECTION){mat4.ortho(b,-1,1,-1,1,this.frontClipDistance,this.backClipDistance)}else{mat4.perspective(b,c,a,this.frontClipDistance,this.backClipDistance)}return b};HTMLCanvas3D.prototype.isLoadingCompleted=function(){return this.isTextureLoadingCompleted(this.backgroundGeometries)&&this.isTextureLoadingCompleted(this.sceneGeometries)};HTMLCanvas3D.prototype.isTextureLoadingCompleted=function(b){for(var a=0;a<b.length;a++){var c=b[a].texture;if(c!==undefined&&c.image!==undefined&&!c.image.bound){return false}}return true};HTMLCanvas3D.prototype.getImage=function(a){if(this.canvasNeededRepaint){this.drawScene();this.canvasNeededRepaint=false}var c=new Image();c.crossOrigin="anonymous";var b;if(a!==undefined){b=function(d){c.removeEventListener("load",b);a(c)};c.addEventListener("load",b)}c.src=this.canvas.toDataURL();if(c.width!==0&&a!==undefined){b()}return c};HTMLCanvas3D.prototype.clear=function(){for(var b=0;b<this.textures.length;b++){delete this.textures[b].src;this.gl.deleteTexture(this.textures[b])}this.textures=[];this.gl.deleteTexture(this.errorTexture);this.errorTexture=null;this.clearGeometries(this.sharedGeometries);this.clearGeometries(this.sceneGeometries);this.clearGeometries(this.backgroundGeometries);this.lights=[];if(this.pickingFrameBuffer!==undefined){this.gl.deleteFramebuffer(this.pickingFrameBuffer);delete this.pickingFrameBuffer}var a=this.gl.getAttachedShaders(this.shaderProgram);for(var b=0;b<a.length;b++){this.gl.detachShader(this.shaderProgram,a[b])}this.scene=null;this.repaint()};HTMLCanvas3D.prototype.clearGeometries=function(b){for(var a=0;a<b.length;a++){this.clearGeometryBuffers(b[a])}b.length=0};HTMLCanvas3D.prototype.clearGeometryBuffers=function(a){this.gl.deleteBuffer(a.vertexBuffer);if(a.textureCoordinatesBuffer!==null&&a.texture!==undefined){this.gl.deleteBuffer(a.textureCoordinatesBuffer)}if(a.normalBuffer!==undefined){this.gl.deleteBuffer(a.normalBuffer)}};HTMLCanvas3D.prototype.setProjectionPolicy=function(a){this.projectionPolicy=a};HTMLCanvas3D.prototype.setIgnoreShininess=function(a){this.ignoreShininess=a;this.repaint()};HTMLCanvas3D.prototype.getClosestShapeAt=function(k,j){if(this.pickingFrameBuffer===undefined){this.pickingFrameBuffer=this.gl.createFramebuffer();this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,this.pickingFrameBuffer);this.pickingFrameBuffer.width=Appearance3D.isPowerOfTwo(this.canvas.width)?this.canvas.width:Appearance3D.getNextHighestPowerOfTwo(this.canvas.width);this.pickingFrameBuffer.height=Appearance3D.isPowerOfTwo(this.canvas.height)?this.canvas.height:Appearance3D.getNextHighestPowerOfTwo(this.canvas.height);this.pickingFrameBuffer.colorMap=new Uint8Array(this.pickingFrameBuffer.width*this.pickingFrameBuffer.height*4);var c=this.gl.createTexture();this.gl.bindTexture(this.gl.TEXTURE_2D,c);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MAG_FILTER,this.gl.NEAREST);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.NEAREST);this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.pickingFrameBuffer.width,this.pickingFrameBuffer.height,0,this.gl.RGBA,this.gl.UNSIGNED_BYTE,null);var e=this.gl.createRenderbuffer();this.gl.bindRenderbuffer(this.gl.RENDERBUFFER,e);this.gl.framebufferTexture2D(this.gl.FRAMEBUFFER,this.gl.COLOR_ATTACHMENT0,this.gl.TEXTURE_2D,c,0);this.gl.renderbufferStorage(this.gl.RENDERBUFFER,this.gl.DEPTH_COMPONENT16,this.pickingFrameBuffer.width,this.pickingFrameBuffer.height);this.gl.framebufferRenderbuffer(this.gl.FRAMEBUFFER,this.gl.DEPTH_ATTACHMENT,this.gl.RENDERBUFFER,e);this.gl.bindTexture(this.gl.TEXTURE_2D,null)}if(this.pickingFrameBufferNeededRepaint){this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,this.pickingFrameBuffer);this.gl.viewport(0,0,this.pickingFrameBuffer.width,this.pickingFrameBuffer.height);this.gl.clearColor(1,1,1,1);this.gl.clear(this.gl.COLOR_BUFFER_BIT|this.gl.DEPTH_BUFFER_BIT);var n=mat4.create();this.getVirtualWorldToImageTransform(n,this.canvas.width/this.canvas.height);this.gl.uniformMatrix4fv(this.shaderProgram.projectionTransform,false,n);this.gl.enable(this.gl.DEPTH_TEST);var m=mat4.invert(mat4.create(),this.viewPlatformTransform);var l=vec3.create();for(var f=0;f<this.sceneGeometries.length;f++){var h=this.sceneGeometries[f];if(h.visible&&h.node.isPickable()){var d=h.diffuseColor;vec3.set(l,((f>>>16)&255)/255,((f>>>8)&255)/255,(f&255)/255);h.diffuseColor=l;this.drawGeometry(h,m,null,false,false,false);if(d!==undefined){h.diffuseColor=d}}}this.gl.readPixels(0,0,this.pickingFrameBuffer.width,this.pickingFrameBuffer.height,this.gl.RGBA,this.gl.UNSIGNED_BYTE,this.pickingFrameBuffer.colorMap);this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,null);this.pickingFrameBufferNeededRepaint=false}var g=this.canvas.getBoundingClientRect();if(k>=g.left&&j>=g.top&&k<g.right&&j<g.bottom){k-=g.left;j-=g.top;var b=(this.pickingFrameBuffer.height-1-Math.floor(j/g.height*this.pickingFrameBuffer.height))*this.pickingFrameBuffer.width+Math.floor(k/g.width*this.pickingFrameBuffer.width);b*=4;var a=this.pickingFrameBuffer.colorMap[b]*65536+this.pickingFrameBuffer.colorMap[b+1]*256+this.pickingFrameBuffer.colorMap[b+2];if(a!=16777215){return this.sceneGeometries[a].node}}return null};function URLContent(a){this.url=a}URLContent.__class="com.eteks.sweethome3d.tools.URLContent";URLContent.__interfaces=["com.eteks.sweethome3d.model.Content"];URLContent.urlContents={};URLContent.fromURL=function(b){var a=URLContent.urlContents[b];if(a==null){if(b.indexOf(LocalStorageURLContent.LOCAL_STORAGE_PREFIX)===0){a=new LocalStorageURLContent(b)}else{if(b.indexOf(IndexedDBURLContent.INDEXED_DB_PREFIX)===0){a=new IndexedDBURLContent(b)}else{a=new URLContent(b)}}URLContent.urlContents[b]=a}return a};URLContent.prototype.getURL=function(){if(typeof document!=="undefined"){var n=this.url.indexOf("https://");var i=this.url.indexOf("http://");if(n!==-1||i!==-1){var e=document.getElementsByTagName("script");if(e&&e.length>0){var c=document.getElementsByTagName("script")[0].src;var h=c.indexOf("://");var g=c.substring(0,h);var a=n!==-1?"https":"http";if(g!=a){var j=c.substring(h+"://".length,c.indexOf("/",h+"://".length));var f="";var k=j.indexOf(":");if(k>0){f=j.substring(k);j=j.substring(0,k)}var m=n!==-1?n:i;var l=this.url.indexOf("://",m);var b=this.url.indexOf("/",l+"://".length);var d=this.url.substring(l+"://".length,b);if(d.indexOf(":")>0){d=d.substring(0,d.indexOf(":"))}if(j==d){return this.url.substring(0,m)+g+"://"+j+f+this.url.substring(b)}}}}}return this.url};URLContent.prototype.getStreamURL=function(a){a.urlReady(this.getURL())};URLContent.prototype.isStreamURLReady=function(){return true};URLContent.prototype.isJAREntry=function(){return this.url.indexOf("jar:")===0&&this.url.indexOf("!/")!==-1};URLContent.prototype.getJAREntryURL=function(){if(!this.isJAREntry()){throw new IllegalStateException("Content isn't a JAR entry")}var a=this.getURL();return a.substring("jar:".length,a.indexOf("!/"))};URLContent.prototype.getJAREntryName=function(){if(!this.isJAREntry()){throw new IllegalStateException("Content isn't a JAR entry")}return this.url.substring(this.url.indexOf("!/")+2)};URLContent.prototype.equals=function(a){if(a===this){return true}else{if(a instanceof URLContent){return a.url==this.url}else{return false}}};URLContent.prototype.hashCode=function(){return this.url.split("").reduce(function(d,c){d=((d<<5)-d)+c.charCodeAt(0);return d&d},0)};function HomeURLContent(a){URLContent.call(this,a)}HomeURLContent.prototype=Object.create(URLContent.prototype);HomeURLContent.prototype.constructor=HomeURLContent;HomeURLContent.__class="com.eteks.sweethome3d.io.HomeURLContent";HomeURLContent.__interfaces=["com.eteks.sweethome3d.model.Content"];function SimpleURLContent(a){URLContent.call(this,a)}SimpleURLContent.prototype=Object.create(URLContent.prototype);SimpleURLContent.prototype.constructor=SimpleURLContent;SimpleURLContent.__class="com.eteks.sweethome3d.tools.SimpleURLContent";SimpleURLContent.__interfaces=["com.eteks.sweethome3d.model.Content"];function LocalURLContent(a){URLContent.call(this,a);this.savedContent=null}LocalURLContent.prototype=Object.create(URLContent.prototype);LocalURLContent.prototype.constructor=LocalURLContent;LocalURLContent.prototype.getSavedContent=function(){return this.savedContent};LocalURLContent.prototype.setSavedContent=function(a){this.savedContent=a};LocalURLContent.prototype.getStreamURL=function(a){throw new UnsupportedOperationException("LocalURLContent abstract class")};LocalURLContent.prototype.getBlob=function(a){throw new UnsupportedOperationException("LocalURLContent abstract class")};LocalURLContent.prototype.writeBlob=function(c,e,a){var d=this;var b=[];this.getBlob({blobReady:function(g){var B;if(Array.isArray(e)){var E=e[0];B=new Array(e.length);for(var y=0;y<e.length;y++){B[y]=encodeURIComponent(e[y])}e=E}else{B=encodeURIComponent(e)}var n=CoreTools.format(c.replace(/(%[^s^\d])/g,"%$1"),B);if(n.indexOf(LocalStorageURLContent.LOCAL_STORAGE_PREFIX)===0){var t=n.substring(n.indexOf(LocalStorageURLContent.LOCAL_STORAGE_PREFIX)+LocalStorageURLContent.LOCAL_STORAGE_PREFIX.length);var u=decodeURIComponent(t.indexOf("?")>0?t.substring(0,t.indexOf("?")):t);return LocalURLContent.convertBlobToBase64(g,function(G){try{localStorage.setItem(u,G);a.blobSaved(d,e)}catch(i){if(a.blobError!==undefined){a.blobError(i,i.message)}}})}else{if(n.indexOf(IndexedDBURLContent.INDEXED_DB_PREFIX)===0){var D=n.indexOf(IndexedDBURLContent.INDEXED_DB_PREFIX)+IndexedDBURLContent.INDEXED_DB_PREFIX.length;var q=n.indexOf("/",D);var A=n.indexOf("?",q+1);var C=n.substring(D,q);var l=n.substring(q+1,A);var v=n.substring(A+1).split("&");var F=null;var r=null;var f=null;var p=null;for(var y=0;y<v.length;y++){var j=v[y].indexOf("=");var m=v[y].substring(0,j);var w=v[y].substring(j+1);switch(m){case"keyPathField":r=w;break;case"contentField":f=w;break;case"dateField":p=w;break}}var s={};for(var y=0;y<v.length;y++){var j=v[y].indexOf("=");var m=v[y].substring(0,j);var w=v[y].substring(j+1);if(r===m){F=decodeURIComponent(w)}else{if(m.indexOf("Field",m.length-"Field".length)===-1){s[m]=decodeURIComponent(w)}}}var x=function(i){var G=i.target.result;if(!G.objectStoreNames.contains(l)){G.createObjectStore(l,{keyPath:r})}};var z=function(i){if(a.blobError!==undefined){a.blobError(i.target.errorCode,"Can't connect to database "+C)}};var h=function(M){var O=M.target.result;try{if(!O.objectStoreNames.contains(l)){O.close();var J=indexedDB.open(C,O.version+1);J.addEventListener("upgradeneeded",x);J.addEventListener("error",z);J.addEventListener("success",h)}else{var G=O.transaction(l,"readwrite");var N=G.objectStore(l);var I={};I[r]=F;I[f]=g;if(p!=null){I[p]=Date.now()}for(var H in s){I[H]=s[H]}var L=N.put(I);L.addEventListener("error",function(i){if(a.blobError!==undefined){a.blobError(i.target.errorCode,"Can't store item in "+l)}});L.addEventListener("success",function(i){a.blobSaved(d,e)});G.addEventListener("complete",function(i){O.close()});b.push(G)}}catch(K){if(a.blobError!==undefined){a.blobError(K,K.message)}}};if(indexedDB!=null){var k=indexedDB.open(C);k.addEventListener("upgradeneeded",x);k.addEventListener("error",z);k.addEventListener("success",h)}else{a.blobError(new Error("indexedDB"),"indexedDB unavailable")}}else{var k=new XMLHttpRequest();k.open("POST",n,true);k.addEventListener("load",function(i){if(k.readyState===XMLHttpRequest.DONE){if(k.status===200){a.blobSaved(d,e)}else{if(a.blobError!==undefined){a.blobError(k.status,k.responseText)}}}});var o=function(i){if(a.blobError!==undefined){a.blobError(0,"Can't post "+n)}};k.addEventListener("error",o);k.addEventListener("timeout",o);k.send(g);b.push(k)}}},blobError:function(f,g){if(a.blobError!==undefined){a.blobError(f,g)}}});return{abort:function(){for(var f=0;f<b.length;f++){b[f].abort()}}}};LocalURLContent.convertBlobToBase64=function(c,b){var a=new FileReader();a.onload=function(){b(a.result)};a.readAsDataURL(c);return a};function BlobURLContent(a){LocalURLContent.call(this,URL.createObjectURL(a));this.blob=a}BlobURLContent.prototype=Object.create(LocalURLContent.prototype);BlobURLContent.prototype.constructor=BlobURLContent;BlobURLContent.__class="com.eteks.sweethome3d.tools.BlobURLContent";BlobURLContent.__interfaces=["com.eteks.sweethome3d.model.Content"];BlobURLContent.BLOB_PREFIX="blob:";BlobURLContent.fromBlob=function(a){for(var b in URLContent.urlContents){if(URLContent.urlContents[b] instanceof BlobURLContent&&URLContent.urlContents[b].blob===a){return URLContent.urlContents[b]}}var c=new BlobURLContent(a);URLContent.urlContents[c.getURL()]=c;return c};BlobURLContent.fromImage=function(e,d,a){var b=document.createElement("canvas");var c=b.getContext("2d");b.width=e.width;b.height=e.height;c.drawImage(e,0,0,e.width,e.height);if(b.msToBlob){a(BlobURLContent.fromBlob(b.msToBlob()))}else{b.toBlob(function(f){a(BlobURLContent.fromBlob(f))},d,0.7)}};BlobURLContent.prototype.getStreamURL=function(a){a.urlReady(this.getURL())};BlobURLContent.prototype.getBlob=function(a){if(a!==undefined){a.blobReady(this.blob)}return this.blob};function LocalStorageURLContent(a){LocalURLContent.call(this,a);this.blob=null;this.blobUrl=null}LocalStorageURLContent.prototype=Object.create(LocalURLContent.prototype);LocalStorageURLContent.prototype.constructor=LocalStorageURLContent;LocalStorageURLContent.__class="com.eteks.sweethome3d.tools.LocalStorageURLContent";LocalStorageURLContent.__interfaces=["com.eteks.sweethome3d.model.Content"];LocalStorageURLContent.LOCAL_STORAGE_PREFIX="localstorage://";LocalStorageURLContent.prototype.getStreamURL=function(a){if(this.blobUrl==null){var b=this;this.getBlob({blobReady:function(c){a.urlReady(b.blobUrl)},blobError:function(c,d){if(a.urlError!==undefined){a.urlError(c,d)}}})}else{a.urlReady(this.blobUrl)}};LocalStorageURLContent.prototype.getBlob=function(e){if(this.blob==null){var b=this.getURL();if(b.indexOf(LocalStorageURLContent.LOCAL_STORAGE_PREFIX)===0){var k=b.substring(b.indexOf(LocalStorageURLContent.LOCAL_STORAGE_PREFIX)+LocalStorageURLContent.LOCAL_STORAGE_PREFIX.length);var h=decodeURIComponent(k.indexOf("?")>0?k.substring(0,k.indexOf("?")):k);var d=localStorage.getItem(h);if(d!=null){var g=d.substring("data:".length,d.indexOf(";"));var f=atob(d.substring(d.indexOf(",")+1));var j=new Array(f.length);for(var c=0;c<j.length;c++){j[c]=f.charCodeAt(c)}var a=new Uint8Array(j);this.blob=new Blob([a],{type:g});this.blobUrl=URL.createObjectURL(this.blob)}else{if(e.urlError!==undefined){e.urlError(1,"No key '"+h+"' in localStorage")}}}else{if(e.urlError!==undefined){e.urlError(1,b+" not a local storage url")}}}if(e!==undefined&&e.blobReady!==undefined&&this.blob!=null){e.blobReady(this.blob)}return this.blob};function IndexedDBURLContent(a){LocalURLContent.call(this,a);this.blob=null;this.blobUrl=null}IndexedDBURLContent.prototype=Object.create(LocalURLContent.prototype);IndexedDBURLContent.prototype.constructor=IndexedDBURLContent;IndexedDBURLContent.__class="com.eteks.sweethome3d.tools.IndexedDBURLContent";IndexedDBURLContent.__interfaces=["com.eteks.sweethome3d.model.Content"];IndexedDBURLContent.INDEXED_DB_PREFIX="indexeddb://";IndexedDBURLContent.prototype.getStreamURL=function(a){if(this.blobUrl==null){var b=this;this.getBlob({blobReady:function(c){a.urlReady(b.blobUrl)},blobError:function(c,d){if(a.urlError!==undefined){a.urlError(c,d)}}})}else{a.urlReady(this.blobUrl)}};IndexedDBURLContent.prototype.getBlob=function(k){if(k!==undefined){if(this.blob!=null){k.blobReady(this.blob)}else{var f=this.getURL();if(f.indexOf(IndexedDBURLContent.INDEXED_DB_PREFIX)>=0){var p=f.indexOf(IndexedDBURLContent.INDEXED_DB_PREFIX)+IndexedDBURLContent.INDEXED_DB_PREFIX.length;var j=f.indexOf("/",p);var r=f.indexOf("/",j+1);var n=f.indexOf("?",r+1);var c=f.indexOf("=",n+1);var g=f.indexOf("&",c+1);var o=f.substring(p,j);var e=f.substring(j+1,r);var a=f.substring(r+1,n);var h=f.substring(n+1,c);var q=decodeURIComponent(f.substring(c+1,g>0?g:f.length));var i=this;var l=function(s){var t=s.target.result;if(!t.objectStoreNames.contains(e)){t.createObjectStore(e,{keyPath:h})}};var m=function(s){if(k.blobError!==undefined){k.blobError(s.target.errorCode,"Can't connect to database "+o)}};var b=function(u){var x=u.target.result;try{if(!x.objectStoreNames.contains(e)){x.close();var w=indexedDB.open(o,x.version+1);w.addEventListener("upgradeneeded",l);w.addEventListener("error",m);w.addEventListener("success",b)}else{var y=x.transaction(e,"readonly");var s=y.objectStore(e);var v=s.get(q);v.addEventListener("error",function(z){if(k.blobError!==undefined){k.blobError(z.target.errorCode,"Can't query in "+e)}});v.addEventListener("success",function(B){if(B.target.result!==undefined){i.blob=B.target.result[a];for(var A in B.target.result){var z=B.target.result[A];if(z!==h&&z!=a&&i.blob[z]===undefined){i.blob[z]=B.target.result[z]}}i.blobUrl=URL.createObjectURL(i.blob);if(k.blobReady!==undefined){k.blobReady(i.blob)}}else{if(k.blobError!==undefined){k.blobError(-1,"Blob with key "+q+" not found")}}});y.addEventListener("complete",function(z){x.close()})}}catch(t){if(k.blobError!==undefined){k.blobError(t,t.message)}}};if(indexedDB!=null){var d=indexedDB.open(o);d.addEventListener("upgradeneeded",l);d.addEventListener("error",m);d.addEventListener("success",b)}else{k.blobError(new Error("indexedDB"),"indexedDB unavailable")}}else{if(k.urlError!==undefined){k.urlError(1,f+" not an indexedDB url")}}}}return this.blob};IndexedDBURLContent.prototype.isStreamURLReady=function(){return this.blobUrl!=null};var OperatingSystem={};OperatingSystem.isLinux=function(){if(navigator&&navigator.platform){return navigator.platform.indexOf("Linux")!==-1}else{return false}};OperatingSystem.isWindows=function(){if(navigator&&navigator.platform){return navigator.platform.indexOf("Windows")!==-1||navigator.platform.indexOf("Win")!==-1}else{return false}};OperatingSystem.isMacOSX=function(){if(navigator&&navigator.platform){return navigator.platform.indexOf("Mac")!==-1}else{return false}};OperatingSystem.getName=function(){if(OperatingSystem.isMacOSX()){return"Mac OS X"}else{if(OperatingSystem.isLinux()){return"Linux"}else{if(OperatingSystem.isWindows()){return"Windows"}else{return"Other"}}}};OperatingSystem.isInternetExplorerOrLegacyEdge=function(){return(document.documentMode||/Edge/.test(navigator.userAgent))};OperatingSystem.isInternetExplorer=function(){return document.documentMode};var ZIPTools={};ZIPTools.READING="Reading";ZIPTools.openedZips={};ZIPTools.runningRequests=[];ZIPTools.getZIP=function(d,b,a){if(a===undefined){a=b;b=false}if(d in ZIPTools.openedZips){a.zipReady(ZIPTools.openedZips[d])}else{var c=URLContent.fromURL(d);if(b&&!c.isStreamURLReady()){throw new IllegalStateException("Can't run synchronously with unavailable URL")}c.getStreamURL({urlReady:function(e){try{var g=new XMLHttpRequest();g.open("GET",e,!b);g.responseType="arraybuffer";g.withCredentials=true;g.overrideMimeType("application/octet-stream");g.addEventListener("readystatechange",function(k){if(g.readyState===XMLHttpRequest.DONE){if((g.status===200||g.status===0)&&g.response!=null){try{ZIPTools.runningRequests.splice(ZIPTools.runningRequests.indexOf(g),1);var j=new JSZip(g.response);ZIPTools.openedZips[d]=j;a.zipReady(ZIPTools.openedZips[d])}catch(i){a.zipError(i)}}else{var h=ZIPTools.runningRequests.indexOf(g);if(h>=0){ZIPTools.runningRequests.splice(h,1);a.zipError(new Error(g.status+" while requesting "+d))}}}});g.addEventListener("progress",function(h){if(h.lengthComputable&&a.progression!==undefined){a.progression(ZIPTools.READING,d,h.loaded/h.total)}});g.send();ZIPTools.runningRequests.push(g)}catch(f){a.zipError(f)}},urlError:function(e,f){if(a.zipError!==undefined){a.zipError(f)}}})}};ZIPTools.clear=function(){ZIPTools.openedZips={};while(ZIPTools.runningRequests.length>0){var a=ZIPTools.runningRequests[ZIPTools.runningRequests.length-1];ZIPTools.runningRequests.splice(ZIPTools.runningRequests.length-1,1);a.abort()}};ZIPTools.disposeZIP=function(a){delete ZIPTools.openedZips[a]};ZIPTools.isGIFImage=function(a){if(a.length<=6){return false}else{if(typeof a==="string"){return a.charCodeAt(0)===71&&a.charCodeAt(1)===73&&a.charCodeAt(2)===70&&a.charCodeAt(3)===56&&(a.charCodeAt(4)===55||a.charCodeAt(4)===57)&&a.charCodeAt(5)===97}else{return a[0]===71&&a[1]===73&&a[2]===70&&a[3]===56&&(a[4]===55||a[4]===57)&&a[5]===97}}};ZIPTools.isBMPImage=function(a){if(a.length<=2){return false}else{if(typeof a==="string"){return a.charCodeAt(0)===66&&a.charCodeAt(1)===77}else{return a[0]===66&&a[1]===77}}};ZIPTools.isJPEGImage=function(a){if(a.length<=3){return false}else{if(typeof a==="string"){return a.charCodeAt(0)===255&&(a.charCodeAt(1)===216||a.charCodeAt(1)===79)&&a.charCodeAt(2)===255}else{return a[0]===255&&(a[1]===216||a[1]===79)&&a[2]===255}}};ZIPTools.isPNGImage=function(a){if(a.length<=8){return false}else{if(typeof a==="string"){return a.charCodeAt(0)===137&&a.charCodeAt(1)===80&&a.charCodeAt(2)===78&&a.charCodeAt(3)===71&&a.charCodeAt(4)===13&&a.charCodeAt(5)===10&&a.charCodeAt(6)===26&&a.charCodeAt(7)===10}else{return a[0]===137&&a[1]===80&&a[2]===78&&a[3]===71&&a[4]===13&&a[5]===10&&a[6]===26&&a[7]===10}}};ZIPTools.isTransparentImage=function(c){if(c.length>26){if(typeof c==="string"){return(c.charCodeAt(25)===4||c.charCodeAt(25)===6||(c.indexOf("PLTE")!==-1&&c.indexOf("tRNS")!==-1))}else{if(c[25]===4||c[25]===6){return true}else{for(var b=0;b<c.length;b++){if(c[b]===80&&c[b+1]===76&&c[b+2]===84&&c[b+3]===69){for(var a=0;a<c.length;a++){if(c[a]===116&&c[a+1]===82&&c[a+2]===78&&c[a+3]===83){return true}}}}}}}return false};ZIPTools.getScriptFolder=function(b){if(b===undefined){b="jszip.min.js"}if(typeof document!=="undefined"){var a=document.getElementsByTagName("script");for(var c=0;c<a.length;c++){if(b instanceof RegExp&&a[c].src.match(b)||typeof b==="string"&&a[c].src.indexOf(b)!==-1){return a[c].src.substring(0,a[c].src.lastIndexOf("/")+1)}}if(a.length>0){return a[0].src.substring(0,a[0].src.lastIndexOf("/")+1)}}return"https://www.sweethome3d.com/libjs/"};function ModelLoader(a){this.modelExtension=a;this.parserBusy=false;this.waitingParsedEntries=[]}ModelLoader.READING_MODEL=Node3D.READING_MODEL;ModelLoader.PARSING_MODEL=Node3D.PARSING_MODEL;ModelLoader.BUILDING_MODEL=Node3D.BUILDING_MODEL;ModelLoader.BINDING_MODEL=Node3D.BINDING_MODEL;ModelLoader.prototype.load=function(e,c,d){if(d===undefined){d=c;c=false}var g=null;if(e.indexOf("jar:")===0){var f=e.indexOf("!/");g=e.substring(f+2);e=e.substring(4,f)}d.progression(ModelLoader.READING_MODEL,e,0);var b=this;var a={zipReady:function(l){try{if(g===null){var h=l.file(/.*/);for(var k=0;k<h.length;k++){if(h[k].name.toLowerCase().match(new RegExp("."+b.modelExtension.toLowerCase()+"$"))){b.parseModelEntry(h[k],l,e,c,d);return}}if(h.length>0){g=h[0].name}else{if(d.modelError!==undefined){d.modelError("Empty file")}return}}b.parseModelEntry(l.file(decodeURIComponent(g)),l,e,c,d)}catch(j){a.zipError(j)}},zipError:function(h){if(d.modelError!==undefined){d.modelError(h)}},progression:function(i,j,h){if(d.progression!==undefined){d.progression(ModelLoader.READING_MODEL,j,h)}}};ZIPTools.getZIP(e,c,a)};ModelLoader.prototype.clear=function(){this.waitingParsedEntries=[]};ModelLoader.prototype.parseModelEntry=function(g,d,f,a,b){if(a){var c=this.getModelContent(g);b.progression(ModelLoader.READING_MODEL,g.name,1);var i={};this.parseDependencies(c,g.name,d,i);var h=this.parseEntryScene(c,g.name,d,i,null,b.progression);this.loadTextureImages(h,{},d,f,true);b.modelLoaded(h)}else{var e={modelEntry:g,zip:d,zipUrl:f,loadingModelObserver:b};this.waitingParsedEntries.push(e);this.parseNextWaitingEntry()}};ModelLoader.prototype.parseNextWaitingEntry=function(){if(!this.parserBusy){for(var e in this.waitingParsedEntries){if(this.waitingParsedEntries.hasOwnProperty(e)){var c=this.waitingParsedEntries[e];var f=c.modelEntry.name;var d=this.getModelContent(c.modelEntry);c.loadingModelObserver.progression(ModelLoader.READING_MODEL,f,1);var b={};this.parseDependencies(d,f,c.zip,b);var a=this;setTimeout(function(){a.parseEntryScene(d,f,c.zip,b,function(g){a.loadTextureImages(g,{},c.zip,c.zipUrl,true);c.loadingModelObserver.modelLoaded(g);a.parserBusy=false;a.parseNextWaitingEntry()},c.loadingModelObserver.progression)},0);this.parserBusy=true;delete this.waitingParsedEntries[e];break}}}};ModelLoader.prototype.loadTextureImages=function(d,j,b,c,a){if(d instanceof Group3D){for(var g=0;g<d.children.length;g++){this.loadTextureImages(d.children[g],j,b,c,a)}}else{if(d instanceof Link3D){this.loadTextureImages(d.getSharedGroup(),j,b,c,a)}else{if(d instanceof Shape3D){var h=d.getAppearance();if(h){var f=h.imageEntryName;if(f!==undefined){delete h[f];if(f in j){h.setTextureImage(j[f])}else{var e=new Image();e.crossOrigin="anonymous";h.setTextureImage(e);e.url="jar:"+c+"!/"+f;j[f]=e;var k=function(){var i=b.file(decodeURIComponent(f));if(i!==null){var o=i.asBinary();var l=btoa(o);var n=f.substring(f.lastIndexOf(".")+1).toLowerCase();var m=ZIPTools.isJPEGImage(o)?"image/jpeg":(ZIPTools.isPNGImage(o)?"image/png":("image/"+n));e.transparent=ZIPTools.isTransparentImage(o);e.src="data:"+m+";base64,"+l}else{h.setTextureImage(null)}};if(a){k()}else{setTimeout(k,0)}}}}}}}};ModelLoader.prototype.getModelContent=function(a){return a.asBinary()};ModelLoader.prototype.parseDependencies=function(b,d,c,a){};ModelLoader.prototype.parseEntryScene=function(b,f,d,a,e,c){};function OBJLoader(){ModelLoader.call(this,"obj");if(OBJLoader.defaultAppearances===null){OBJLoader.defaultAppearances={};OBJLoader.parseMaterial("newmtl amber\nKa 0.0531 0.0531 0.0531\nKd 0.5755 0.2678 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl amber_trans\nKa 0.0531 0.0531 0.0531\nKd 0.5755 0.2678 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nd 0.1600\nNs 60.0000\n\nnewmtl charcoal\nKa 0.0082 0.0082 0.0082\nKd 0.0041 0.0041 0.0041\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl lavendar\nKa 0.1281 0.0857 0.2122\nKd 0.2187 0.0906 0.3469\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl navy_blue\nKa 0.0000 0.0000 0.0490\nKd 0.0000 0.0000 0.0531\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl pale_green\nKa 0.0444 0.0898 0.0447\nKd 0.0712 0.3796 0.0490\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl pale_pink\nKa 0.0898 0.0444 0.0444\nKd 0.6531 0.2053 0.4160\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl pale_yellow\nKa 0.3606 0.3755 0.0935\nKd 0.6898 0.6211 0.1999\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl peach\nKa 0.3143 0.1187 0.0167\nKd 0.6367 0.1829 0.0156\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl periwinkle\nKa 0.0000 0.0000 0.1184\nKd 0.0000 0.0396 0.8286\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl redwood\nKa 0.0204 0.0027 0.0000\nKd 0.2571 0.0330 0.0000\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl smoked_glass\nKa 0.0000 0.0000 0.0000\nKd 0.0041 0.0041 0.0041\nKs 0.1878 0.1878 0.1878\nillum 2\nd 0.0200\nNs 91.4700\n\nnewmtl aqua_filter\nKa 0.0000 0.0000 0.0000\nKd 0.3743 0.6694 0.5791\nKs 0.1878 0.1878 0.1878\nillum 2\nd 0.0200\nNs 91.4700\n\nnewmtl yellow_green\nKa 0.0000 0.0000 0.0000\nKd 0.1875 0.4082 0.0017\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl bluetint\nKa 0.1100 0.4238 0.5388\nKd 0.0468 0.7115 0.9551\nKs 0.3184 0.3184 0.3184\nillum 9\nd 0.4300\nNs 60.0000\nsharpness 60.0000\n\nnewmtl plasma\nKa 0.4082 0.0816 0.2129\nKd 1.0000 0.0776 0.4478\nKs 0.3000 0.3000 0.3000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl emerald\nKa 0.0470 1.0000 0.0000\nKd 0.0470 1.0000 0.0000\nKs 0.2000 0.2000 0.2000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl ruby\nKa 1.0000 0.0000 0.0000\nKd 1.0000 0.0000 0.0000\nKs 0.2000 0.2000 0.2000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl sapphire\nKa 0.0235 0.0000 1.0000\nKd 0.0235 0.0000 1.0000\nKs 0.2000 0.2000 0.2000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl white\nKa 0.4000 0.4000 0.4000\nKd 1.0000 1.0000 1.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl red\nKa 0.4449 0.0000 0.0000\nKd 0.7714 0.0000 0.0000\nKs 0.8857 0.0000 0.0000\nillum 2\nNs 136.4300\n\nnewmtl blue_pure\nKa 0.0000 0.0000 0.5000\nKd 0.0000 0.0000 1.0000\nKs 0.0000 0.0000 0.5000\nillum 2\nNs 65.8900\n\nnewmtl lime\nKa 0.0000 0.5000 0.0000\nKd 0.0000 1.0000 0.0000\nKs 0.0000 0.5000 0.0000\nillum 2\nNs 65.8900\n\nnewmtl green\nKa 0.0000 0.2500 0.0000\nKd 0.0000 0.2500 0.0000\nKs 0.0000 0.2500 0.0000\nillum 2\nNs 65.8900\n\nnewmtl yellow\nKa 1.0000 0.6667 0.0000\nKd 1.0000 0.6667 0.0000\nKs 1.0000 0.6667 0.0000\nillum 2\nNs 65.8900\n\nnewmtl purple\nKa 0.5000 0.0000 1.0000\nKd 0.5000 0.0000 1.0000\nKs 0.5000 0.0000 1.0000\nillum 2\nNs 65.8900\n\nnewmtl orange\nKa 1.0000 0.1667 0.0000\nKd 1.0000 0.1667 0.0000\nKs 1.0000 0.1667 0.0000\nillum 2\nNs 65.8900\n\nnewmtl grey\nKa 0.5000 0.5000 0.5000\nKd 0.1837 0.1837 0.1837\nKs 0.5000 0.5000 0.5000\nillum 2\nNs 65.8900\n\nnewmtl rubber\nKa 0.0000 0.0000 0.0000\nKd 0.0100 0.0100 0.0100\nKs 0.1000 0.1000 0.1000\nillum 2\nNs 65.8900\n\nnewmtl flaqua\nKa 0.0000 0.4000 0.4000\nKd 0.0000 0.5000 0.5000\nillum 1\n\nnewmtl flblack\nKa 0.0000 0.0000 0.0000\nKd 0.0041 0.0041 0.0041\nillum 1\n\nnewmtl flblue_pure\nKa 0.0000 0.0000 0.5592\nKd 0.0000 0.0000 0.7102\nillum 1\n\nnewmtl flgrey\nKa 0.2163 0.2163 0.2163\nKd 0.5000 0.5000 0.5000\nillum 1\n\nnewmtl fllime\nKa 0.0000 0.3673 0.0000\nKd 0.0000 1.0000 0.0000\nillum 1\n\nnewmtl florange\nKa 0.6857 0.1143 0.0000\nKd 1.0000 0.1667 0.0000\nillum 1\n\nnewmtl flpurple\nKa 0.2368 0.0000 0.4735\nKd 0.3755 0.0000 0.7510\nillum 1\n\nnewmtl flred\nKa 0.4000 0.0000 0.0000\nKd 1.0000 0.0000 0.0000\nillum 1\n\nnewmtl flyellow\nKa 0.7388 0.4925 0.0000\nKd 1.0000 0.6667 0.0000\nillum 1\n\nnewmtl pink\nKa 0.9469 0.0078 0.2845\nKd 0.9878 0.1695 0.6702\nKs 0.7429 0.2972 0.2972\nillum 2\nNs 106.2000\n\nnewmtl flbrown\nKa 0.0571 0.0066 0.0011\nKd 0.1102 0.0120 0.0013\nillum 1\n\nnewmtl brown\nKa 0.1020 0.0185 0.0013\nKd 0.0857 0.0147 0.0000\nKs 0.1633 0.0240 0.0000\nillum 2\nNs 65.8900\n\nnewmtl glass\nKa 1.0000 1.0000 1.0000\nKd 0.4873 0.4919 0.5306\nKs 0.6406 0.6939 0.9020\nillum 2\nNs 200.0000\n\nnewmtl flesh\nKa 0.4612 0.3638 0.2993\nKd 0.5265 0.4127 0.3374\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl aqua\nKa 0.0000 0.4000 0.4000\nKd 0.0000 0.5000 0.5000\nKs 0.5673 0.5673 0.5673\nillum 2\nNs 60.0000\n\nnewmtl black\nKa 0.0000 0.0000 0.0000\nKd 0.0020 0.0020 0.0020\nKs 0.5184 0.5184 0.5184\nillum 2\nNs 157.3600\n\nnewmtl silver\nKa 0.9551 0.9551 0.9551\nKd 0.6163 0.6163 0.6163\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl dkblue_pure\nKa 0.0000 0.0000 0.0449\nKd 0.0000 0.0000 0.1347\nKs 0.0000 0.0000 0.5673\nillum 2\nNs 65.8900\n\nnewmtl fldkblue_pure\nKa 0.0000 0.0000 0.0449\nKd 0.0000 0.0000 0.1347\nillum 1\n\nnewmtl dkgreen\nKa 0.0000 0.0122 0.0000\nKd 0.0058 0.0245 0.0000\nKs 0.0000 0.0490 0.0000\nillum 2\nNs 60.0000\n\nnewmtl dkgrey\nKa 0.0490 0.0490 0.0490\nKd 0.0490 0.0490 0.0490\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl ltbrown\nKa 0.1306 0.0538 0.0250\nKd 0.2776 0.1143 0.0531\nKs 0.3000 0.1235 0.0574\nillum 2\nNs 60.0000\n\nnewmtl fldkgreen\nKa 0.0000 0.0122 0.0000\nKd 0.0058 0.0245 0.0000\nillum 1\n\nnewmtl flltbrown\nKa 0.1306 0.0538 0.0250\nKd 0.2776 0.1143 0.0531\nillum 1\n\nnewmtl tan\nKa 0.4000 0.3121 0.1202\nKd 0.6612 0.5221 0.2186\nKs 0.5020 0.4118 0.2152\nillum 2\nNs 60.0000\n\nnewmtl fltan\nKa 0.4000 0.3121 0.1202\nKd 0.6612 0.4567 0.1295\nillum 1\n\nnewmtl brzskin\nKa 0.4408 0.2694 0.1592\nKd 0.3796 0.2898 0.2122\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 25.0000\n\nnewmtl lips\nKa 0.4408 0.2694 0.1592\nKd 0.9265 0.2612 0.2898\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 25.0000\n\nnewmtl redorange\nKa 0.3918 0.0576 0.0000\nKd 0.7551 0.0185 0.0000\nKs 0.4694 0.3224 0.1667\nillum 2\nNs 132.5600\n\nnewmtl blutan\nKa 0.4408 0.2694 0.1592\nKd 0.0776 0.2571 0.2041\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl bluteal\nKa 0.0041 0.1123 0.1224\nKd 0.0776 0.2571 0.2041\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl pinktan\nKa 0.4408 0.2694 0.1592\nKd 0.6857 0.2571 0.2163\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl brnhair\nKa 0.0612 0.0174 0.0066\nKd 0.0898 0.0302 0.0110\nKs 0.1306 0.0819 0.0352\nillum 2\nNs 60.4700\n\nnewmtl blondhair\nKa 0.4449 0.2632 0.0509\nKd 0.5714 0.3283 0.0443\nKs 0.7755 0.4602 0.0918\nillum 2\nNs 4.6500\n\nnewmtl flblonde\nKa 0.4449 0.2632 0.0509\nKd 0.5714 0.3283 0.0443\nillum 1\n\nnewmtl yelloworng\nKa 0.5837 0.1715 0.0000\nKd 0.8857 0.2490 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl bone\nKa 0.3061 0.1654 0.0650\nKd 0.9000 0.7626 0.4261\nKs 0.8939 0.7609 0.5509\nillum 2\nNs 200.0000\n\nnewmtl teeth\nKa 0.6408 0.5554 0.3845\nKd 0.9837 0.7959 0.4694\nillum 1\n\nnewmtl brass\nKa 0.2490 0.1102 0.0000\nKd 0.4776 0.1959 0.0000\nKs 0.5796 0.5796 0.5796\nillum 2\nNs 134.8800\n\nnewmtl dkred\nKa 0.0939 0.0000 0.0000\nKd 0.2286 0.0000 0.0000\nKs 0.2490 0.0000 0.0000\nillum 2\nNs 60.0000\n\nnewmtl taupe\nKa 0.1061 0.0709 0.0637\nKd 0.2041 0.1227 0.1058\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 84.5000\n\nnewmtl dkteal\nKa 0.0000 0.0245 0.0163\nKd 0.0000 0.0653 0.0449\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 55.0400\n\nnewmtl dkdkgrey\nKa 0.0000 0.0000 0.0000\nKd 0.0122 0.0122 0.0122\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl dkblue\nKa 0.0000 0.0029 0.0408\nKd 0.0000 0.0041 0.0571\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl gold\nKa 0.7224 0.1416 0.0000\nKd 1.0000 0.4898 0.0000\nKs 0.7184 0.3695 0.3695\nillum 2\nNs 123.2600\n\nnewmtl redbrick\nKa 0.1102 0.0067 0.0067\nKd 0.3306 0.0398 0.0081\nillum 1\n\nnewmtl flmustard\nKa 0.4245 0.2508 0.0000\nKd 0.8898 0.3531 0.0073\nillum 1\n\nnewmtl flpinegreen\nKa 0.0367 0.0612 0.0204\nKd 0.1061 0.2163 0.0857\nillum 1\n\nnewmtl fldkred\nKa 0.0939 0.0000 0.0000\nKd 0.2286 0.0082 0.0082\nillum 1\n\nnewmtl fldkgreen2\nKa 0.0025 0.0122 0.0014\nKd 0.0245 0.0694 0.0041\nillum 1\n\nnewmtl flmintgreen\nKa 0.0408 0.1429 0.0571\nKd 0.1306 0.2898 0.1673\nillum 1\n\nnewmtl olivegreen\nKa 0.0167 0.0245 0.0000\nKd 0.0250 0.0367 0.0000\nKs 0.2257 0.2776 0.1167\nillum 2\nNs 97.6700\n\nnewmtl skin\nKa 0.2286 0.0187 0.0187\nKd 0.1102 0.0328 0.0139\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 17.8300\n\nnewmtl redbrown\nKa 0.1469 0.0031 0.0000\nKd 0.2816 0.0060 0.0000\nKs 0.3714 0.3714 0.3714\nillum 2\nNs 141.0900\n\nnewmtl deepgreen\nKa 0.0000 0.0050 0.0000\nKd 0.0000 0.0204 0.0050\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 113.1800\n\nnewmtl flltolivegreen\nKa 0.0167 0.0245 0.0000\nKd 0.0393 0.0531 0.0100\nillum 1\n\nnewmtl jetflame\nKa 0.7714 0.0000 0.0000\nKd 0.9510 0.4939 0.0980\nKs 0.8531 0.5222 0.0000\nillum 2\nNs 132.5600\n\nnewmtl brownskn\nKa 0.0122 0.0041 0.0000\nKd 0.0204 0.0082 0.0000\nKs 0.0735 0.0508 0.0321\nillum 2\nNs 20.1600\n\nnewmtl greenskn\nKa 0.0816 0.0449 0.0000\nKd 0.0000 0.0735 0.0000\nKs 0.0490 0.1224 0.0898\nillum 3\nNs 46.5100\nsharpness 146.5100\n\nnewmtl ltgrey\nKa 0.5000 0.5000 0.5000\nKd 0.3837 0.3837 0.3837\nKs 0.5000 0.5000 0.5000\nillum 2\nNs 65.8900\n\nnewmtl bronze\nKa 0.0449 0.0204 0.0000\nKd 0.0653 0.0367 0.0122\nKs 0.0776 0.0408 0.0000\nillum 3\nNs 137.2100\nsharpness 125.5800\n\nnewmtl bone1\nKa 0.6408 0.5554 0.3845\nKd 0.9837 0.7959 0.4694\nillum 1\n\nnewmtl flwhite1\nKa 0.9306 0.9306 0.9306\nKd 1.0000 1.0000 1.0000\nillum 1\n\nnewmtl flwhite\nKa 0.6449 0.6116 0.5447\nKd 0.9837 0.9309 0.8392\nKs 0.8082 0.7290 0.5708\nillum 2\nNs 200.0000\n\nnewmtl shadow\nKd 0.0350 0.0248 0.0194\nillum 0\nd 0.2500\n\nnewmtl fldkolivegreen\nKa 0.0056 0.0082 0.0000\nKd 0.0151 0.0204 0.0038\nillum 1\n\nnewmtl fldkdkgrey\nKa 0.0000 0.0000 0.0000\nKd 0.0122 0.0122 0.0122\nillum 1\n\nnewmtl lcdgreen\nKa 0.4000 0.4000 0.4000\nKd 0.5878 1.0000 0.5061\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl brownlips\nKa 0.1143 0.0694 0.0245\nKd 0.1429 0.0653 0.0408\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 25.0000\n\nnewmtl muscle\nKa 0.2122 0.0077 0.0154\nKd 0.4204 0.0721 0.0856\nKs 0.1184 0.1184 0.1184\nillum 2\nNs 25.5800\n\nnewmtl flltgrey\nKa 0.5224 0.5224 0.5224\nKd 0.8245 0.8245 0.8245\nillum 1\n\nnewmtl offwhite.warm\nKa 0.5184 0.4501 0.3703\nKd 0.8367 0.6898 0.4490\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl offwhite.cool\nKa 0.5184 0.4501 0.3703\nKd 0.8367 0.6812 0.5703\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl yellowbrt\nKa 0.4000 0.4000 0.4000\nKd 1.0000 0.7837 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl chappie\nKa 0.4000 0.4000 0.4000\nKd 0.5837 0.1796 0.0367\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl archwhite\nKa 0.2816 0.2816 0.2816\nKd 0.9959 0.9959 0.9959\nillum 1\n\nnewmtl archwhite2\nKa 0.2816 0.2816 0.2816\nKd 0.8408 0.8408 0.8408\nillum 1\n\nnewmtl lighttan\nKa 0.0980 0.0536 0.0220\nKd 0.7020 0.4210 0.2206\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl lighttan2\nKa 0.0980 0.0492 0.0144\nKd 0.3143 0.1870 0.0962\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl lighttan3\nKa 0.0980 0.0492 0.0144\nKd 0.1796 0.0829 0.0139\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl lightyellow\nKa 0.5061 0.1983 0.0000\nKd 1.0000 0.9542 0.3388\nKs 1.0000 0.9060 0.0000\nillum 2\nNs 177.5200\n\nnewmtl lighttannew\nKa 0.0980 0.0492 0.0144\nKd 0.7878 0.6070 0.3216\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl default\nKa 0.4000 0.4000 0.4000\nKd 0.7102 0.7020 0.6531\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 128.0000\n\nnewmtl ship2\nKa 0.0000 0.0000 0.0000\nKd 1.0000 1.0000 1.0000\nKs 0.1143 0.1143 0.1143\nillum 2\nNs 60.0000\n\nnewmtl dkpurple\nKa 0.0082 0.0000 0.0163\nKd 0.0245 0.0000 0.0490\nKs 0.1266 0.0000 0.2531\nillum 2\nNs 65.8900\n\nnewmtl dkorange\nKa 0.4041 0.0123 0.0000\nKd 0.7143 0.0350 0.0000\nKs 0.7102 0.0870 0.0000\nillum 2\nNs 65.8900\n\nnewmtl mintgrn\nKa 0.0101 0.1959 0.0335\nKd 0.0245 0.4776 0.0816\nKs 0.0245 0.4776 0.0816\nillum 2\nNs 65.8900\n\nnewmtl fgreen\nKa 0.0000 0.0449 0.0000\nKd 0.0000 0.0449 0.0004\nKs 0.0062 0.0694 0.0000\nillum 2\nNs 106.2000\n\nnewmtl glassblutint\nKa 0.4000 0.4000 0.4000\nKd 0.5551 0.8000 0.7730\nKs 0.7969 0.9714 0.9223\nillum 4\nd 0.6700\nNs 60.0000\nsharpness 60.0000\n\nnewmtl bflesh\nKa 0.0122 0.0122 0.0122\nKd 0.0245 0.0081 0.0021\nKs 0.0531 0.0460 0.0153\nillum 2\nNs 20.1600\n\nnewmtl meh\nKa 0.4000 0.4000 0.4000\nKd 0.5551 0.8000 0.7730\nKs 0.7969 0.9714 0.9223\nillum 4\nd 0.2500\nNs 183.7200\nsharpness 60.0000\n\nnewmtl violet\nKa 0.0083 0.0000 0.1265\nKd 0.0287 0.0269 0.1347\nKs 0.2267 0.4537 0.6612\nillum 2\nNs 96.9000\n\nnewmtl iris\nKa 0.3061 0.0556 0.0037\nKd 0.0000 0.0572 0.3184\nKs 0.8041 0.6782 0.1477\nillum 2\nNs 188.3700\n\nnewmtl blugrn\nKa 0.4408 0.4144 0.1592\nKd 0.0811 0.6408 0.2775\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl glasstransparent\nKa 0.2163 0.2163 0.2163\nKd 0.4694 0.4694 0.4694\nKs 0.6082 0.6082 0.6082\nillum 4\nd 0.2500\nNs 200.0000\nsharpness 60.0000\n\nnewmtl fleshtransparent\nKa 0.4000 0.2253 0.2253\nKd 0.6898 0.2942 0.1295\nKs 0.7388 0.4614 0.4614\nillum 4\nd 0.2500\nNs 6.2000\nsharpness 60.0000\n\nnewmtl fldkgrey\nKa 0.0449 0.0449 0.0449\nKd 0.0939 0.0939 0.0939\nillum 1\n\nnewmtl sky_blue\nKa 0.1363 0.2264 0.4122\nKd 0.1241 0.5931 0.8000\nKs 0.0490 0.0490 0.0490\nillum 2\nNs 13.9500\n\nnewmtl fldkpurple\nKa 0.0443 0.0257 0.0776\nKd 0.1612 0.0000 0.3347\nKs 0.0000 0.0000 0.0000\nillum 2\nNs 13.9500\n\nnewmtl dkbrown\nKa 0.0143 0.0062 0.0027\nKd 0.0087 0.0038 0.0016\nKs 0.2370 0.2147 0.1821\nillum 3\nNs 60.0000\nsharpness 60.0000\n\nnewmtl bone2\nKa 0.6408 0.5388 0.3348\nKd 0.9837 0.8620 0.6504\nillum 1\n\nnewmtl bluegrey\nKa 0.4000 0.4000 0.4000\nKd 0.1881 0.2786 0.2898\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 14.7300\n\nnewmtl metal\nKa 0.9102 0.8956 0.1932\nKd 0.9000 0.7626 0.4261\nKs 0.8939 0.8840 0.8683\nillum 2\nNs 200.0000\n\nnewmtl sand_stone\nKa 0.1299 0.1177 0.0998\nKd 0.1256 0.1138 0.0965\nKs 0.2370 0.2147 0.1821\nillum 3\nNs 60.0000\nsharpness 60.0000\n\nnewmtl hair\nKa 0.0013 0.0012 0.0010\nKd 0.0008 0.0007 0.0006\nKs 0.0000 0.0000 0.0000\nillum 3\nNs 60.0000\nsharpness 60.0000\n",OBJLoader.defaultAppearances,null,null)}}OBJLoader.prototype=Object.create(ModelLoader.prototype);OBJLoader.prototype.constructor=OBJLoader;OBJLoader.defaultAppearances=null;OBJLoader.prototype.createScene=function(d,c,i,b,e,l,f){var h=new Group3D();if(l===null){f(ModelLoader.BUILDING_MODEL,"",0);for(var k in b){this.createGroupShapes(d,c,i,b[k],e,h)}f(ModelLoader.BUILDING_MODEL,"",1);return h}else{var a=0;for(var k in b){a+=b[k].geometries.length}var g=0;var j=this;var m=function(){f(ModelLoader.BUILDING_MODEL,"",a!==0?g/a:0);var o=Date.now();for(var n in b){j.createGroupShapes(d,c,i,b[n],e,h);g+=b[n].geometries.length;delete b[n];if(g<a&&Date.now()-o>10){setTimeout(m,0);return}}setTimeout(function(){f(ModelLoader.BUILDING_MODEL,"",1);l(h)},0)};m()}};OBJLoader.prototype.createGroupShapes=function(o,g,y,r,x,t){var w=r.geometries;if(w.length>0){var F=0;while(F<w.length){var d=w[F];var G=d.textureCoordinateIndices.length>0;var H=(d instanceof OBJLoader.OBJFace)&&d.normalIndices.length>0;var I=(d instanceof OBJLoader.OBJFace)&&d.smooth;var f=d.material;var v=OBJLoader.getAppearance(x,f);var E=F;while(++E<w.length){var m=w[E];var u=m.material;if((m.constructor!==d.constructor)||u===null&&f!==null||u!==null&&OBJLoader.getAppearance(x,u)!==v||(I^((m instanceof OBJLoader.OBJFace)&&m.smooth))||(G^m.textureCoordinateIndices.length>0)||(H^((m instanceof OBJLoader.OBJFace)&&m.normalIndices.length>0))){break}}if(v!==null){v=v.clone()}var z=E-F;var h=[];var q=[];var e=true;for(var D=0;D<z;D++){var b=w[F+D].vertexIndices;h.push.apply(h,b);q.push(b.length);if(e&&b.length!==3){e=false}}var l=[];if(G){for(var D=0;D<z;D++){l.push.apply(l,w[F+D].textureCoordinateIndices)}}var A;if(d instanceof OBJLoader.OBJFace){var s=[];if(H){for(var D=0;D<z;D++){s.push.apply(s,w[F+D].normalIndices)}}var B=new GeometryInfo3D(e?GeometryInfo3D.TRIANGLE_ARRAY:GeometryInfo3D.POLYGON_ARRAY);B.setCoordinates(o);B.setCoordinateIndices(h);B.setNormals(y);B.setNormalIndices(s);B.setTextureCoordinates(g);B.setTextureCoordinateIndices(l);B.setStripCounts(q);if(!H){B.setCreaseAngle(I?Math.PI/2:0);B.setGeneratedNormals(true)}A=B.getIndexedGeometryArray()}else{var n=[];var a=[];for(var D=0,p=0;D<z;p+=q[D],D++){for(var C=0;C<q[D]-1;C++){n.push(h[p+C]);n.push(h[p+C+1]);if(l.length>0){a.push(l[p+C]);a.push(l[p+C+1])}}}A=new IndexedLineArray3D(o,n,g,a)}var c=new Shape3D(A,v);t.addChild(c);c.setName(r.name+(F===0?"":"_"+F));F=E}}};OBJLoader.getAppearance=function(c,b){var a=undefined;if(b!==null){a=c[b]}if(a===undefined){a=OBJLoader.defaultAppearances["default"]}return a};OBJLoader.prototype.parseDependencies=function(c,a,b,f){f.appearances={};for(var d in OBJLoader.defaultAppearances){var e=OBJLoader.defaultAppearances[d];f.appearances[e.getName()]=e}try{var h=c.indexOf("mtllib");while(h!==-1){var i=h+6;while(i<c.length&&c.charAt(i)!="\n"&&c.charAt(i)!="\r"){i++}var l=c.substring(h,i).trim();var j=l.substring(7,l.length).trim();this.parseMaterialEntry(j,f.appearances,a,b);h=c.indexOf("mtllib",i)}}catch(g){f.appearances={}}};OBJLoader.prototype.parseEntryScene=function(f,c,e,j,q,l){var i=[];var h=[];var o=[];var m=new OBJLoader.OBJGroup("default");var g={"default":m};var b={};var a={group:m,material:"default",smooth:false};if(q===null){try{l(ModelLoader.PARSING_MODEL,c,0);for(var n=0;n<=f.length;){n=this.parseObjectLine(f,n,i,h,o,g,b,a)}l(ModelLoader.PARSING_MODEL,c,1);return this.createScene(i,h,o,g,j.appearances,null,l)}catch(k){l(ModelLoader.PARSING_MODEL,c,1);return this.createScene([],[],[],{},j.appearances,null,l)}}else{var n=0;var p=this;var d=function(){try{l(ModelLoader.PARSING_MODEL,c,n/f.length);var s=n+200000;var t=Date.now();while(n<=f.length){n=p.parseObjectLine(f,n,i,h,o,g,b,a);if(n<=f.length&&n>s&&Date.now()-t>10){setTimeout(d,0);return}}setTimeout(function(){l(ModelLoader.PARSING_MODEL,c,1);p.createScene(i,h,o,g,j.appearances,function(u){q(u)},l)},0)}catch(r){l(ModelLoader.PARSING_MODEL,c,1);p.createScene([],[],[],{},j.appearances,q,l)}};d()}};OBJLoader.prototype.parseObjectLine=function(f,l,j,h,m,g,b,a){var n=l+1;while(n<f.length&&f.charAt(n)!="\n"&&f.charAt(n)!="\r"){n++}var p=f.substring(l,n);if(p.indexOf("v")===0||p.indexOf("f ")===0||p.indexOf("l ")===0){while(p.charAt(p.length-1)==="\\"){p=p.substring(0,p.length-1)+" ";l=n+1;if(l<f.length&&f.charAt(n)=="\r"&&f.charAt(l)=="\n"){l++}n=l+1;while(n<f.length&&f.charAt(n)!="\n"&&f.charAt(n)!="\r"){n++}p+=f.substring(l,n)}}p=p.trim();var o=p.split(/\s+/);var d=o[0];if(d==="v"){j.push(OBJLoader.parseVector3f(o))}else{if(d==="vt"){h.push(OBJLoader.parseVector2f(o))}else{if(d==="vn"){try{m.push(OBJLoader.parseVector3f(o))}catch(i){console.log(f+" "+p)}}else{if(d==="l"){var p=this.parseLine(o,a.material);if(p.vertexIndices.length>1){a.group.addGeometry(p)}}else{if(d==="f"){var k=this.parseFace(o,a.smooth,a.material);if(k.vertexIndices.length>2){if(k.normalIndices.length===0||a.group.name.indexOf("sweethome3d_")===0){a.group.addGeometry(k)}else{if(!(k.material in b)){b[k.material]=a.group}b[k.material].addGeometry(k)}}}else{if(d==="g"||d==="o"){if(o.length>1){var c=o[1];a.group=g[c];if(a.group===undefined){a.group=new OBJLoader.OBJGroup(c);g[c]=a.group}}else{a.group=g["default"]}}else{if(d==="s"){a.smooth=o[1]!="off"}else{if(d==="usemtl"){a.material=p.substring(7,p.length).trim()}}}}}}}}l=n+1;if(l<f.length&&f.charAt(n)=="\r"&&f.charAt(l)=="\n"){l++}return l};OBJLoader.prototype.parseLine=function(a,e){var d=[];var g=[];for(var c=0;c<a.length;c++){var f=a[c];if(c>0&&f.length>0){var b=f.indexOf("/");if(b===-1){d.push(OBJLoader.parseInteger(f)-1)}else{d.push(OBJLoader.parseInteger(f.substring(0,b))-1);g.push(OBJLoader.parseInteger(f.substring(b+1))-1)}}}if(d.length!==g.length){g=[]}return new OBJLoader.OBJLine(d,g,e)};OBJLoader.prototype.parseFace=function(h,a,g){var e=[];var c=[];var k=[];for(var f=0;f<h.length;f++){var j=h[f];if(f>0&&j.length>0){var b=j.indexOf("/");if(b===-1){e.push(OBJLoader.parseInteger(j)-1)}else{e.push(OBJLoader.parseInteger(j.substring(0,b))-1);var d=j.lastIndexOf("/");if(b===d){c.push(OBJLoader.parseInteger(j.substring(b+1))-1)}else{if(b+1!==d){c.push(OBJLoader.parseInteger(j.substring(b+1,d))-1)}k.push(OBJLoader.parseInteger(j.substring(d+1))-1)}}}}if(e.length!==c.length){c=[]}if(e.length!==k.length){k=[]}return new OBJLoader.OBJFace(e,c,k,a,g)};OBJLoader.prototype.parseMaterialEntry=function(d,f,e,c){var a=e.lastIndexOf("/");if(a>=0){d=e.substring(0,a+1)+d}var b=c.file(d);if(b!==null){OBJLoader.parseMaterial(b.asBinary(),f,e,c)}};OBJLoader.parseVector3f=function(a){return vec3.fromValues(OBJLoader.parseNumber(a[1]),OBJLoader.parseNumber(a[2]),OBJLoader.parseNumber(a[3]))};OBJLoader.parseVector2f=function(a){return vec2.fromValues(OBJLoader.parseNumber(a[1]),OBJLoader.parseNumber(a[2]))};OBJLoader.parseInteger=function(a){var b=parseInt(a);if(isNaN(b)){throw new IncorrectFormat3DException("Incorrect integer "+a)}return b};OBJLoader.parseNumber=function(b){var a=parseFloat(b);if(isNaN(a)){if(b=="NaN"){return NaN}throw new IncorrectFormat3DException("Incorrect number "+b)}return a};OBJLoader.parseMaterial=function(l,j,a,c){var d=null;var m=l.match(/^.*$/mg);for(var h=0;h<m.length;h++){var n=m[h].trim();var k=n.split(/\s+/);var b=k[0];if(b=="newmtl"){d=new Appearance3D(n.substring(7,n.length).trim());j[d.getName()]=d}else{if(d!==null){if(b=="Ka"){d.setAmbientColor(OBJLoader.parseVector3f(k))}else{if(b=="Kd"){d.setDiffuseColor(OBJLoader.parseVector3f(k))}else{if(b=="Ks"){d.setSpecularColor(OBJLoader.parseVector3f(k))}else{if(b=="Ns"){d.setShininess(Math.max(1,Math.min(OBJLoader.parseNumber(k[1]),128)))}else{if(b=="d"){d.setTransparency(1-Math.max(0,OBJLoader.parseNumber(k[1]=="-halo"?k[2]:k[1])))}else{if(b=="illum"){d.setIllumination(OBJLoader.parseInteger(k[1]))}else{if(b=="map_Kd"){var e=k[k.length-1];var f=a.lastIndexOf("/");if(f>=0){e=a.substring(0,f+1)+e}var g=c.file(e);if(g===null&&k.length>2){e=n.substring(7,n.length).trim();if(f>=0){e=a.substring(0,f+1)+e}g=c.file(e)}if(g!==null){d.imageEntryName=e}}}}}}}}}}}};OBJLoader.OBJGroup=function(a){this.name=a;this.geometries=[]};OBJLoader.OBJGroup.prototype.addGeometry=function(a){this.geometries.push(a)};OBJLoader.OBJLine=function(b,c,a){this.vertexIndices=b;this.textureCoordinateIndices=c;this.material=a};OBJLoader.OBJFace=function(d,e,b,a,c){this.vertexIndices=d;this.textureCoordinateIndices=e;this.normalIndices=b;this.smooth=a;this.material=c};function ModelManager(){this.loadedModelNodes={};this.loadingModelObservers={}}ModelManager.SPECIAL_SHAPE_PREFIX="sweethome3d_";ModelManager.WINDOW_PANE_SHAPE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"window_pane";ModelManager.MIRROR_SHAPE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"window_mirror";ModelManager.LIGHT_SHAPE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"light";ModelManager.MANNEQUIN_ABDOMEN_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_abdomen";ModelManager.MANNEQUIN_CHEST_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_chest";ModelManager.MANNEQUIN_PELVIS_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_pelvis";ModelManager.MANNEQUIN_NECK_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_neck";ModelManager.MANNEQUIN_HEAD_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_head";ModelManager.MANNEQUIN_LEFT_SHOULDER_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_shoulder";ModelManager.MANNEQUIN_LEFT_ARM_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_arm";ModelManager.MANNEQUIN_LEFT_ELBOW_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_elbow";ModelManager.MANNEQUIN_LEFT_FOREARM_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_forearm";ModelManager.MANNEQUIN_LEFT_WRIST_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_wrist";ModelManager.MANNEQUIN_LEFT_HAND_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_hand";ModelManager.MANNEQUIN_LEFT_HIP_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_hip";ModelManager.MANNEQUIN_LEFT_THIGH_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_thigh";ModelManager.MANNEQUIN_LEFT_KNEE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_knee";ModelManager.MANNEQUIN_LEFT_LEG_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_leg";ModelManager.MANNEQUIN_LEFT_ANKLE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_ankle";ModelManager.MANNEQUIN_LEFT_FOOT_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_left_foot";ModelManager.MANNEQUIN_RIGHT_SHOULDER_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_shoulder";ModelManager.MANNEQUIN_RIGHT_ARM_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_arm";ModelManager.MANNEQUIN_RIGHT_ELBOW_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_elbow";ModelManager.MANNEQUIN_RIGHT_FOREARM_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_forearm";ModelManager.MANNEQUIN_RIGHT_WRIST_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_wrist";ModelManager.MANNEQUIN_RIGHT_HAND_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_hand";ModelManager.MANNEQUIN_RIGHT_HIP_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_hip";ModelManager.MANNEQUIN_RIGHT_THIGH_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_thigh";ModelManager.MANNEQUIN_RIGHT_KNEE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_knee";ModelManager.MANNEQUIN_RIGHT_LEG_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_leg";ModelManager.MANNEQUIN_RIGHT_ANKLE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_ankle";ModelManager.MANNEQUIN_RIGHT_FOOT_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_right_foot";ModelManager.MANNEQUIN_ABDOMEN_CHEST_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_abdomen_chest";ModelManager.MANNEQUIN_ABDOMEN_PELVIS_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"mannequin_abdomen_pelvis";ModelManager.BALL_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"ball_";ModelManager.ARM_ON_BALL_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"arm_on_ball_";ModelManager.HINGE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"hinge_";ModelManager.OPENING_ON_HINGE_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"opening_on_hinge_";ModelManager.WINDOW_PANE_ON_HINGE_PREFIX=ModelManager.WINDOW_PANE_SHAPE_PREFIX+"_on_hinge_";ModelManager.MIRROR_ON_HINGE_PREFIX=ModelManager.MIRROR_SHAPE_PREFIX+"_on_hinge_";ModelManager.UNIQUE_RAIL_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"unique_rail";ModelManager.RAIL_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"rail_";ModelManager.OPENING_ON_RAIL_PREFIX=ModelManager.SPECIAL_SHAPE_PREFIX+"opening_on_rail_";ModelManager.WINDOW_PANE_ON_RAIL_PREFIX=ModelManager.WINDOW_PANE_SHAPE_PREFIX+"_on_rail_";ModelManager.MIRROR_ON_RAIL_PREFIX=ModelManager.MIRROR_SHAPE_PREFIX+"_on_rail_";ModelManager.SUB_TRANSFORMATION_SEPARATOR="_and_";ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX="_transformation";ModelManager.EDGE_COLOR_MATERIAL_PREFIX="edge_color";ModelManager.instance=null;ModelManager.getInstance=function(){if(ModelManager.instance==null){ModelManager.instance=new ModelManager()}return ModelManager.instance};ModelManager.prototype.clear=function(){this.loadedModelNodes={};this.loadingModelObservers={};if(this.modelLoaders){for(var a=0;a<this.modelLoaders.length;a++){this.modelLoaders[a].clear()}}};ModelManager.prototype.getMinimumSize=function(){return 0.001};ModelManager.prototype.getSize=function(e,d){if(d===undefined){d=mat4.create()}var c=this.getBounds(e,d);var a=vec3.create();c.getLower(a);var b=vec3.create();c.getUpper(b);return vec3.fromValues(Math.max(this.getMinimumSize(),b[0]-a[0]),Math.max(this.getMinimumSize(),b[1]-a[1]),Math.max(this.getMinimumSize(),b[2]-a[2]))};ModelManager.prototype.getCenter=function(d){var c=this.getBounds(d);var a=vec3.create();c.getLower(a);var b=vec3.create();c.getUpper(b);return vec3.fromValues((a[0]+b[0])/2,(a[1]+b[1])/2,(a[2]+b[2])/2)};ModelManager.prototype.getBounds=function(b,a){if(a===undefined){a=mat4.create()}var c=new BoundingBox3D(vec3.fromValues(Infinity,Infinity,Infinity),vec3.fromValues(-Infinity,-Infinity,-Infinity));this.computeBounds(b,c,a,!this.isOrthogonalRotation(a),this.isDeformed(b));return c};ModelManager.prototype.isOrthogonalRotation=function(c){for(var b=0;b<3;b++){for(var a=0;a<3;a++){if(Math.abs(c[b*4+a])>0.000001&&Math.abs(c[b*4+a]-1)>0.000001&&Math.abs(c[b*4+a]+1)>0.000001){return false}}}return true};ModelManager.prototype.computeBounds=function(f,e,g,c,b){if(f instanceof Group3D){if(f instanceof TransformGroup3D){g=mat4.clone(g);mat4.mul(g,g,f.transform)}for(var d=0;d<f.children.length;d++){this.computeBounds(f.children[d],e,g,c,b)}}else{if(f instanceof Link3D){this.computeBounds(f.getSharedGroup(),e,g,c,b)}else{if(f instanceof Shape3D){var a;if(c||b&&!this.isOrthogonalRotation(g)){a=this.computeTransformedGeometryBounds(f,g)}else{a=f.getBounds();a.transform(g)}e.combine(a)}}}};ModelManager.prototype.computeTransformedGeometryBounds=function(a,f){var c=vec3.fromValues(Infinity,Infinity,Infinity);var e=vec3.fromValues(-Infinity,-Infinity,-Infinity);for(var d=0;d<a.geometries.length;d++){var h=a.geometries[d];var g=vec3.create();for(var b=0;b<h.vertexIndices.length;b++){vec3.copy(g,h.vertices[h.vertexIndices[b]]);this.updateBounds(g,f,c,e)}}return new BoundingBox3D(c,e)};ModelManager.prototype.updateBounds=function(d,c,a,b){if(c!==null){vec3.transformMat4(d,d,c)}vec3.min(a,a,d);vec3.max(b,b,d)};ModelManager.prototype.getNormalizedTransformGroup=function(c,d,b,a){return new TransformGroup3D(this.getNormalizedTransform(c,d,b,a!==false))};ModelManager.prototype.getNormalizedTransform=function(d,c,b,g){var j=this.getBounds(d);var f=vec3.create();j.getLower(f);var l=vec3.create();j.getUpper(l);var a=mat4.create();mat4.translate(a,a,vec3.fromValues(-f[0]-(l[0]-f[0])/2,-f[1]-(l[1]-f[1])/2,-f[2]-(l[2]-f[2])/2));var i;if(c!==undefined&&c!==null){var e=this.getRotationTransformation(c);mat4.mul(e,e,a);var h=this.getBounds(d,e);h.getLower(f);h.getUpper(l);i=mat4.create();if(g){mat4.translate(i,i,vec3.fromValues(-f[0]-(l[0]-f[0])/2,-f[1]-(l[1]-f[1])/2,-f[2]-(l[2]-f[2])/2))}mat4.mul(i,i,e)}else{i=a}var k=mat4.create();mat4.scale(k,k,vec3.fromValues(b/Math.max(this.getMinimumSize(),l[0]-f[0]),b/Math.max(this.getMinimumSize(),l[1]-f[1]),b/Math.max(this.getMinimumSize(),l[2]-f[2])));mat4.mul(k,k,i);return k};ModelManager.prototype.getRotationTransformation=function(b){var a=mat4.create();a[0]=b[0][0];a[4]=b[0][1];a[8]=b[0][2];a[1]=b[1][0];a[5]=b[1][1];a[9]=b[1][2];a[2]=b[2][0];a[6]=b[2][1];a[10]=b[2][2];return a};ModelManager.prototype.getPieceOfFurnitureNormalizedModelTransformation=function(n,b){var d=mat4.create();var k=n.getWidth();if(n.isModelMirrored()){k*=-1}mat4.scale(d,d,vec3.fromValues(k,n.getHeight(),n.getDepth()));var h;var m;if(n.isHorizontallyRotated()&&b!==undefined&&b!==null){var i=mat4.create();if(n.getPitch()!=0){mat4.fromXRotation(i,-n.getPitch())}if(n.getRoll()!=0){var l=mat4.create();mat4.fromZRotation(l,-n.getRoll());mat4.mul(i,l,i)}mat4.mul(i,i,d);var g=this.getBounds(b,i);var e=vec3.create();g.getLower(e);var j=vec3.create();g.getUpper(j);h=mat4.create();mat4.translate(h,h,vec3.fromValues(-e[0]-(j[0]-e[0])/2,-e[1]-(j[1]-e[1])/2,-e[2]-(j[2]-e[2])/2));mat4.mul(h,h,i);m=Math.max(this.getMinimumSize(),j[1]-e[1])}else{h=d;m=n.getHeight()}var a=mat4.create();mat4.fromYRotation(a,-n.getAngle());mat4.mul(a,a,h);var f=mat4.create();var c;if(n.getLevel()!==null){c=n.getLevel().getElevation()}else{c=0}mat4.translate(f,f,vec3.fromValues(n.getX(),n.getElevation()+m/2+c,n.getY()));mat4.mul(f,f,a);return f};ModelManager.prototype.getPieceOFFurnitureNormalizedModelTransformation=ModelManager.prototype.getPieceOfFurnitureNormalizedModelTransformation;ModelManager.prototype.loadModel=function(e,b,d){if(d===undefined){d=b;b=false}var a=this;var g=e.getURL();if(g in this.loadedModelNodes){var c=this.loadedModelNodes[g];if(d.modelUpdated!==undefined){d.modelUpdated(this.cloneNode(c))}}else{if(b){this.load(e,b,{modelLoaded:function(h){a.loadedModelNodes[g]=h;if(d.modelUpdated!==undefined){d.modelUpdated(a.cloneNode(h))}},modelError:function(h){if(d.modelError!==undefined){d.modelError(h)}},progression:function(i,j,h){if(d.progression!==undefined){d.progression(i,j,h)}}})}else{if(g in this.loadingModelObservers){this.loadingModelObservers[g].push(d)}else{var f=[];f.push(d);this.loadingModelObservers[g]=f;this.load(e,b,{modelLoaded:function(j){a.loadedModelNodes[g]=j;var k=a.loadingModelObservers[g];if(k){for(var h=0;h<k.length;h++){if(k[h].modelUpdated!==undefined){k[h].modelUpdated(a.cloneNode(j))}}}},modelError:function(j){var k=a.loadingModelObservers[g];if(k){delete a.loadingModelObservers[g];for(var h=0;h<k.length;h++){if(k[h].modelError!==undefined){k[h].modelError(j)}}}},progression:function(j,l,h){var m=a.loadingModelObservers[g];if(m){for(var k=0;k<m.length;k++){if(m[k].progression!==undefined){m[k].progression(j,l,h)}}}}})}}}};ModelManager.prototype.unloadModel=function(b,a){var c=b.getURL();var d=this.loadedModelNodes[c];delete this.loadedModelNodes[c];delete this.loadingModelObservers[c];if(a){this.disposeGeometries(d)}};ModelManager.prototype.disposeGeometries=function(c){if(c instanceof Group3D){for(var a=0;a<c.children.length;a++){this.disposeGeometries(c.children[a])}}else{if(c instanceof Link3D){this.disposeGeometries(c.getSharedGroup())}else{if(c instanceof Shape3D){var b=c.getGeometries();for(var a=0;a<b.length;a++){b[a].disposeCoordinates()}}}}};ModelManager.prototype.cloneNode=function(d,k){if(k===undefined){return this.cloneNode(d,[])}else{var j=d.clone();if(d instanceof Shape3D){var h;if(d.getAppearance()){j.setAppearance(d.getAppearance().clone())}}else{if(d instanceof Link3D){var f=d.clone();var e=f.getSharedGroup();if(e!==null){var a=null;for(var g=0;g<k.length;g++){if(k[g].sharedGroup===e){a=k[g].clonedSharedGroup;break}}if(a===null){a=this.cloneNode(e,k);k.push({sharedGroup:e,clonedSharedGroup:a})}f.setSharedGroup(a)}return f}else{j=d.clone();if(d instanceof Group3D){var b=d.getChildren();for(var g=0;g<b.length;g++){var c=this.cloneNode(b[g],k);j.addChild(c)}}}}return j}};ModelManager.prototype.load=function(d,b,c){if(c===undefined){c=b;b=false}var e=d.getURL();if(!this.modelLoaders){this.modelLoaders=[new OBJLoader()];if(typeof DAELoader!=="undefined"){this.modelLoaders.push(new DAELoader())}if(typeof Max3DSLoader!=="undefined"){this.modelLoaders.push(new Max3DSLoader())}}var a=this;var f={modelLoaderIndex:0,modelLoaded:function(g){var h=a.getBounds(g);if(!h.isEmpty()){a.updateWindowPanesTransparency(g);a.updateDeformableModelHierarchy(g);a.replaceMultipleSharedShapes(g);g.setUserData(d);c.modelLoaded(g)}else{if(++this.modelLoaderIndex<a.modelLoaders.length){a.modelLoaders[this.modelLoaderIndex].load(e,b,this)}else{this.modelError("Unsupported 3D format")}}},modelError:function(g){c.modelError(g)},progression:function(h,i,g){c.progression(h,i,g)}};a.modelLoaders[0].load(e,b,f)};ModelManager.prototype.updateWindowPanesTransparency=function(d){if(d instanceof Group3D){for(var c=0;c<d.children.length;c++){this.updateWindowPanesTransparency(d.children[c])}}else{if(d instanceof Link3D){this.updateWindowPanesTransparency(d.getSharedGroup())}else{if(d instanceof Shape3D){var b=d.getName();if(b&&b.indexOf(ModelManager.WINDOW_PANE_SHAPE_PREFIX)===0){var a=d.getAppearance();if(a===null){a=new Appearance3D();d.setAppearance(a)}if(a.getTransparency()===undefined){a.setTransparency(0.5)}}}}}};ModelManager.prototype.updateDeformableModelHierarchy=function(y){if(this.containsNode(y,ModelManager.MANNEQUIN_ABDOMEN_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_CHEST_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_PELVIS_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_NECK_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_HEAD_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_SHOULDER_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_ARM_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_ELBOW_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_FOREARM_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_WRIST_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_HAND_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_HIP_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_THIGH_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_KNEE_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_LEG_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_ANKLE_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_LEFT_FOOT_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_SHOULDER_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_ARM_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_ELBOW_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_FOREARM_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_WRIST_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_HAND_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_HIP_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_THIGH_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_KNEE_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_LEG_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_ANKLE_PREFIX)&&this.containsNode(y,ModelManager.MANNEQUIN_RIGHT_FOOT_PREFIX)){var u=this.extractNodes(y,ModelManager.MANNEQUIN_HEAD_PREFIX,null);var l=this.createPickableTransformGroup(ModelManager.MANNEQUIN_NECK_PREFIX,[u]);var S=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_HAND_PREFIX,null);var d=this.createPickableTransformGroup(ModelManager.MANNEQUIN_LEFT_WRIST_PREFIX,[S]);var P=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_FOREARM_PREFIX,null);var h=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_WRIST_PREFIX,null);var C=this.createPickableTransformGroup(ModelManager.MANNEQUIN_LEFT_ELBOW_PREFIX,[P,h,d]);var o=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_ARM_PREFIX,null);var K=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_ELBOW_PREFIX,null);var L=this.createPickableTransformGroup(ModelManager.MANNEQUIN_LEFT_SHOULDER_PREFIX,[o,K,C]);var x=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_HAND_PREFIX,null);var e=this.createPickableTransformGroup(ModelManager.MANNEQUIN_RIGHT_WRIST_PREFIX,[x]);var k=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_FOREARM_PREFIX,null);var M=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_WRIST_PREFIX,null);var i=this.createPickableTransformGroup(ModelManager.MANNEQUIN_RIGHT_ELBOW_PREFIX,[k,M,e]);var I=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_ARM_PREFIX,null);var n=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_ELBOW_PREFIX,null);var p=this.createPickableTransformGroup(ModelManager.MANNEQUIN_RIGHT_SHOULDER_PREFIX,[I,n,i]);var j=this.extractNodes(y,ModelManager.MANNEQUIN_CHEST_PREFIX,null);var E=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_SHOULDER_PREFIX,null);var g=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_SHOULDER_PREFIX,null);var b=this.extractNodes(y,ModelManager.MANNEQUIN_NECK_PREFIX,null);var f=this.createPickableTransformGroup(ModelManager.MANNEQUIN_ABDOMEN_CHEST_PREFIX,[j,E,L,g,p,b,l]);var c=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_FOOT_PREFIX,null);var G=this.createPickableTransformGroup(ModelManager.MANNEQUIN_LEFT_ANKLE_PREFIX,[c]);var s=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_LEG_PREFIX,null);var N=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_ANKLE_PREFIX,null);var z=this.createPickableTransformGroup(ModelManager.MANNEQUIN_LEFT_KNEE_PREFIX,[s,N,G]);var Q=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_THIGH_PREFIX,null);var H=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_KNEE_PREFIX,null);var m=this.createPickableTransformGroup(ModelManager.MANNEQUIN_LEFT_HIP_PREFIX,[Q,H,z]);var A=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_FOOT_PREFIX,null);var F=this.createPickableTransformGroup(ModelManager.MANNEQUIN_RIGHT_ANKLE_PREFIX,[A]);var J=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_LEG_PREFIX,null);var r=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_ANKLE_PREFIX,null);var T=this.createPickableTransformGroup(ModelManager.MANNEQUIN_RIGHT_KNEE_PREFIX,[J,r,F]);var B=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_THIGH_PREFIX,null);var a=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_KNEE_PREFIX,null);var q=this.createPickableTransformGroup(ModelManager.MANNEQUIN_RIGHT_HIP_PREFIX,[B,a,T]);var w=this.extractNodes(y,ModelManager.MANNEQUIN_PELVIS_PREFIX,null);var v=this.extractNodes(y,ModelManager.MANNEQUIN_LEFT_HIP_PREFIX,null);var O=this.extractNodes(y,ModelManager.MANNEQUIN_RIGHT_HIP_PREFIX,null);var R=this.createPickableTransformGroup(ModelManager.MANNEQUIN_ABDOMEN_PELVIS_PREFIX,[w,v,m,O,q]);var t=this.extractNodes(y,ModelManager.MANNEQUIN_ABDOMEN_PREFIX,null);y.addChild(t);y.addChild(f);y.addChild(R)}else{this.updateSimpleDeformableModelHierarchy(y,null,ModelManager.HINGE_PREFIX,ModelManager.OPENING_ON_HINGE_PREFIX,ModelManager.WINDOW_PANE_ON_HINGE_PREFIX,ModelManager.MIRROR_ON_HINGE_PREFIX);this.updateSimpleDeformableModelHierarchy(y,null,ModelManager.BALL_PREFIX,ModelManager.ARM_ON_BALL_PREFIX,null,null);this.updateSimpleDeformableModelHierarchy(y,ModelManager.UNIQUE_RAIL_PREFIX,ModelManager.RAIL_PREFIX,ModelManager.OPENING_ON_RAIL_PREFIX,ModelManager.WINDOW_PANE_ON_RAIL_PREFIX,ModelManager.MIRROR_ON_RAIL_PREFIX);var D=[];while(this.updateDeformableModelSubTransformedHierarchy(y,y,[ModelManager.HINGE_PREFIX,ModelManager.BALL_PREFIX,ModelManager.RAIL_PREFIX],[ModelManager.OPENING_ON_HINGE_PREFIX,ModelManager.ARM_ON_BALL_PREFIX,ModelManager.OPENING_ON_RAIL_PREFIX],D)){}}};ModelManager.prototype.updateSimpleDeformableModelHierarchy=function(k,g,j,c,m,l){if(this.containsNode(k,c+1)||(m!==null&&this.containsNode(k,m+1))||(l!==null&&this.containsNode(k,l+1))){if(this.containsNode(k,j+1)){var e=1;do{var h=this.extractNodes(k,j+e,null);var b=this.extractNodes(k,c+e,null);var d=m!==null?this.extractNodes(k,m+e,null):null;var f=l!==null?this.extractNodes(k,l+e,null):null;var a=this.createPickableTransformGroup(j+e,[b,d,f]);k.addChild(h);k.addChild(a);e++}while(this.containsNode(k,j+e)&&(this.containsNode(k,c+e)||(m!==null&&this.containsNode(k,m+e))||(l!==null&&this.containsNode(k,l+e))))}else{if(g!==null&&this.containsNode(k,g)){var h=this.extractNodes(k,g,null);k.addChild(h);var e=1;do{var b=this.extractNodes(k,c+e,null);var d=this.extractNodes(k,m+e,null);var f=this.extractNodes(k,l+e,null);k.addChild(this.createPickableTransformGroup(j+e,[b,d,f]));e++}while(this.containsNode(k,c+e)||this.containsNode(k,m+e)||this.containsNode(k,l+e))}}}};ModelManager.prototype.containsNode=function(c,d){var a=c.getName();if(a!==null&&a.indexOf(d)===0){return true}if(c instanceof Group3D){for(var b=c.getChildren().length-1;b>=0;b--){if(this.containsNode(c.getChild(b),d)){return true}}}return false};ModelManager.prototype.extractNodes=function(d,a,c){if(d.getName()!==null&&d.getName().indexOf(a)===0){d.getParent().removeChild(d);if(c===null){c=new Group3D()}c.addChild(d)}if(d instanceof Group3D){for(var b=d.getChildren().length-1;b>=0;b--){c=this.extractNodes(d.getChild(b),a,c)}}return c};ModelManager.prototype.createPickableTransformGroup=function(d,b){var c=new TransformGroup3D();c.setCapability(TransformGroup3D.ALLOW_TRANSFORM_WRITE);c.setName(d+ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX);for(var a=0;a<b.length;a++){if(b[a]!==null){c.addChild(b[a])}}return c};ModelManager.prototype.updateDeformableModelSubTransformedHierarchy=function(r,f,a,k,s){if(r!==f&&s.indexOf(f)<0){var b=f.getName();if(b!==null){for(var l=0;l<a.length;l++){var n=a[l];if(b.indexOf(n)===0){var o=b.indexOf(ModelManager.SUB_TRANSFORMATION_SEPARATOR);if(o>0){for(var h=0;h<k.length;h++){var m=b.indexOf(k[h],o+ModelManager.SUB_TRANSFORMATION_SEPARATOR.length);if(m>=0){if(s.indexOf(f)<0){s.push(f)}var p=f.getParent();var q=p.getParent();if(q!==null){var g=q.getChildren().indexOf(p);var e=q.getChild(++g);while(!(e instanceof TransformGroup3D)){e=q.getChild(++g)}var c=m+k[h].length;while(c<b.length&&b.charAt(c)>="0"&&b.charAt(c)<="9"){c++}if(this.attachNodesToPickableTransformGroup(r,a[h]+b.substring(m+k[h].length,c),[p,e])){return true}}}}}}}}}if(f instanceof Group3D){var d=f.getChildren();for(var l=d.length-1;l>=0;l--){if(this.updateDeformableModelSubTransformedHierarchy(r,d[l],a,k,s)){return true}}}return false};ModelManager.prototype.attachNodesToPickableTransformGroup=function(e,a,g){if(e instanceof TransformGroup3D&&(a+ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX)==e.getName()){var f=e;for(var c=0;c<g.length;c++){var d=g[c];d.getParent().removeChild(d);f.addChild(d)}return true}else{if(e instanceof Group3D){var b=e.getChildren();for(var c=0;c<b.length;c++){if(this.attachNodesToPickableTransformGroup(b[c],a,g)){return true}}}}return false};ModelManager.prototype.containsDeformableNode=function(c){if(c instanceof TransformGroup3D&&c.getName()!==null&&c.getName().indexOf(ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX)>=0&&c.getName().indexOf(ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX)===(c.getName().length-ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX.length)){return true}else{if(c instanceof Group3D){var b=c.getChildren();for(var a=0;a<b.length;a++){if(this.containsDeformableNode(b[a])){return true}}}}return false};ModelManager.prototype.isDeformed=function(d){if(d instanceof TransformGroup3D&&d.getName()!==null&&d.getName().indexOf(ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX)>=0&&d.getName().indexOf(ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX)===(d.getName().length-ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX.length)){var a=mat4.create();d.getTransform(a);return !TransformGroup3D.isIdentity(a)}else{if(d instanceof Group3D){var c=d.getChildren();for(var b=0;b<c.length;b++){if(this.isDeformed(c[b])){return true}}}}return false};ModelManager.prototype.getMaterials=function(n,g,f){if(f===undefined){if(g===undefined){g=false;f=null}else{f=g}}var l=[];this.searchAppearances(n,g,l);var b=[];for(var r=0;r<l.length;r++){var h=l[r];var p=null;var o=null;var k=h.getDiffuseColor();if(k!=null){p=4278190080|(Math.round(k[0]*255)<<16)|(Math.round(k[1]*255)<<8)|Math.round(k[2]*255);o=h.getShininess()!=null?h.getShininess()/128:null}var e=h.getTextureImage();var m=null;if(e!=null){var a=e.url;if(a!=null){var u=new SimpleURLContent(a);var t=a.substring(a.lastIndexOf("/")+1);var c=t.lastIndexOf(".");if(c!==-1){t=t.substring(0,c)}m=new HomeTexture(new CatalogTexture(null,t,u,-1,-1,f))}}var s=h.getName();if(s===undefined){s=null}var d=new HomeMaterial(s,p,m,o);for(var q=0;q<b.length;q++){if(b[q].getName()==d.getName()){d=null;break}}if(d!=null){b.push(d)}}b.sort(function(j,i){var w=j.getName();var v=i.getName();if(w!=null){if(v!=null){return w.localeCompare(v)}else{return 1}}else{if(v!=null){return -1}else{return 0}}});return b};ModelManager.prototype.searchAppearances=function(e,b,f){if(e instanceof Group3D){var d=e.getChildren();for(var c=0;c<d.length;c++){this.searchAppearances(d[c],b,f)}}else{if(e instanceof Link3D){this.searchAppearances(e.getSharedGroup(),b,f)}else{if(e instanceof Shape3D){var a=e.getAppearance();if(a!==null&&(!b||!(a.getName().indexOf(ModelManager.EDGE_COLOR_MATERIAL_PREFIX)===0))&&f.indexOf(a)===-1){f.push(a)}}}}};ModelManager.prototype.replaceMultipleSharedShapes=function(c){var a=[];this.searchSharedShapes(c,a,false);for(var e=0;e<a.length;e++){if(a[e].value>1){var f=[];var g=a[e].key;this.searchShapeTransformations(c,g,f,mat4.create());var k=g.clone();var b=k.getGeometries();for(var d=0;d<b.length;d++){var h=this.getTransformedGeometry(b[d],f);if(h===null){return}k.setGeometry(h,d)}this.removeSharedShape(c,g);c.addChild(k)}}};ModelManager.prototype.searchSharedShapes=function(d,e,a){if(d instanceof Group3D){var c=d.getChildren();for(var b=0;b<c.length;b++){this.searchSharedShapes(c[b],e,a)}}else{if(d instanceof Link3D){this.searchSharedShapes(d.getSharedGroup(),e,true)}else{if(d instanceof Shape3D){if(a){for(var b=0;b<e.length;b++){if(e[b].key===d){e[b].value++;return}}e.push({key:d,value:1})}}}}};ModelManager.prototype.searchShapeTransformations=function(g,a,c,f){if(g instanceof Group3D){if(!(g instanceof TransformGroup3D)||!this.isDeformed(g)){if(g instanceof TransformGroup3D){f=mat4.clone(f);var b=mat4.create();g.getTransform(b);mat4.mul(f,f,b)}var e=g.getChildren();for(var d=0;d<e.length;d++){this.searchShapeTransformations(e[d],a,c,f)}}}else{if(g instanceof Link3D){this.searchShapeTransformations(g.getSharedGroup(),a,c,f)}else{if(g===a){c.push(f)}}}};ModelManager.prototype.getTransformedGeometry=function(p,h){var a=0;var q=0;var o=new Array(h.length*p.vertexIndices.length);for(var f=0;f<h.length;f++){for(var e=0,c=p.vertexIndices.length;e<c;e++){o[a+e]=q+p.vertexIndices[e]}a+=p.vertexIndices.length;q+=p.vertices.length}var l=new Array(h.length*p.textureCoordinateIndices.length);a=0;for(var f=0;f<h.length;f++){for(var e=0,c=p.textureCoordinateIndices.length;e<c;e++){l[a+e]=p.textureCoordinateIndices[e]}a+=p.textureCoordinateIndices.length}q=0;var d=new Array(h.length*p.vertices.length);for(var f=0;f<h.length;f++){for(var e=0,c=p.vertices.length;e<c;e++){var k=vec3.clone(p.vertices[e]);vec3.transformMat4(k,k,h[f]);d[q+e]=k}q+=p.vertices.length}if(p instanceof IndexedLineArray3D){return new IndexedLineArray3D(d,o,p.textureCoordinates,l)}else{if(p instanceof IndexedTriangleArray3D){var g=new Array(h.length*p.normalIndices.length);a=0;var r=0;for(var f=0;f<h.length;f++){for(var e=0,c=p.normalIndices.length;e<c;e++){g[a+e]=r+p.normalIndices[e]}a+=p.normalIndices.length;r+=p.normals.length}var r=0;var b=new Array(h.length*p.normals.length);for(var f=0;f<h.length;f++){for(var e=0,c=p.normals.length;e<c;e++){var m=vec3.clone(p.normals[e]);vec3.transformMat4(m,m,h[f]);vec3.normalize(m,m);b[r+e]=m}r+=p.normals.length}return new IndexedTriangleArray3D(d,o,p.textureCoordinates,l,b,g)}else{return null}}};ModelManager.prototype.removeSharedShape=function(d,a){if(d instanceof Group3D){if(!(d instanceof TransformGroup3D)||!this.isDeformed(d)){var c=d.getChildren();for(var b=c.length-1;b>=0;b--){this.removeSharedShape(c[b],a)}if(c.length===0&&d.getParent() instanceof Group3D){d.getParent().removeChild(d)}}}else{if(d instanceof Link3D){var e=d.getSharedGroup();this.removeSharedShape(e,a);if(e.children.length==0){d.getParent().removeChild(d)}}else{if(d===a){d.getParent().removeChild(d)}}}};ModelManager.prototype.getFrontArea=function(k,e){var c;if(k!==null){c=new java.awt.geom.Area(this.getShape(k));c.transform(java.awt.geom.AffineTransform.getScaleInstance(1,-1));c.transform(java.awt.geom.AffineTransform.getTranslateInstance(-0.5,0.5))}else{var b=this.getVertexCount(e);if(b<1000000){var f=new java.awt.geom.Area();this.computeBottomOrFrontArea(e,f,mat4.create(),false,false);c=new java.awt.geom.Area();var o=[];var l=null;for(var h=f.getPathIterator(null,1);!h.isDone();h.next()){var j=[0,0];switch(h.currentSegment(j)){case java.awt.geom.PathIterator.SEG_MOVETO:case java.awt.geom.PathIterator.SEG_LINETO:if(l===null||j[0]!==l[0]||j[1]!==l[1]){o.push(j)}l=j;break;case java.awt.geom.PathIterator.SEG_CLOSE:if(o[0][0]===l[0]&&o[0][1]===l[1]){o.splice(o.length-1,1)}if(o.length>2){var m=o.slice(0);var d=new Room(m);if(d.getArea()>0){if(!d.isClockwise()){var n=new java.awt.geom.GeneralPath();n.moveTo(m[0][0],m[0][1]);for(var g=1;g<m.length;g++){n.lineTo(m[g][0],m[g][1])}n.closePath();c.add(new java.awt.geom.Area(n))}}}o.length=0;l=null;break}}var a=f.getBounds2D();c.transform(java.awt.geom.AffineTransform.getTranslateInstance(-a.getCenterX(),-a.getCenterY()));c.transform(java.awt.geom.AffineTransform.getScaleInstance(1/a.getWidth(),1/a.getHeight()))}else{c=new java.awt.geom.Area(new java.awt.geom.Rectangle2D.Float(-0.5,-0.5,1,1))}}return c};ModelManager.prototype.getAreaOnFloor=function(b){if(b instanceof Node3D){var j;var a=this.getVertexCount(b);if(a<10000){j=new java.awt.geom.Area();this.computeBottomOrFrontArea(b,j,mat4.create(),true,true)}else{var h=[];this.computeVerticesOnFloor(b,h,mat4.create());if(h.length>0){var k=this.getSurroundingPolygon(h.slice(0));var e=new java.awt.geom.GeneralPath(java.awt.geom.Path2D.WIND_NON_ZERO,k.length);e.moveTo(k[0][0],k[0][1]);for(var c=0;c<k.length;c++){e.lineTo(k[c][0],k[c][1])}e.closePath();j=new java.awt.geom.Area(e)}else{j=new java.awt.geom.Area()}}return j}else{var g=b;if(g.getStaircaseCutOutShape()===null){throw new IllegalArgumentException("No cut out shape associated to piece")}var f=this.getShape(g.getStaircaseCutOutShape());var d=new java.awt.geom.Area(f);if(g.isModelMirrored()){d=this.getMirroredArea(d)}var l=java.awt.geom.AffineTransform.getTranslateInstance(g.getX()-g.getWidth()/2,g.getY()-g.getDepth()/2);l.concatenate(java.awt.geom.AffineTransform.getRotateInstance(g.getAngle(),g.getWidth()/2,g.getDepth()/2));l.concatenate(java.awt.geom.AffineTransform.getScaleInstance(g.getWidth(),g.getDepth()));d.transform(l);return d}};ModelManager.prototype.getVertexCount=function(f){var e=0;if(f instanceof Group3D){var c=f.getChildren();for(var b=0;b<c.length;b++){e+=this.getVertexCount(c[b])}}else{if(f instanceof Link3D){e=this.getVertexCount(f.getSharedGroup())}else{if(f instanceof Shape3D){var a=f.getAppearance();if(a.isVisible()){var d=f.getGeometries();for(var b=0,h=d.length;b<h;b++){var g=d[b];e+=g.vertices.length}}}}}return e};ModelManager.prototype.computeBottomOrFrontArea=function(f,m,l,h,a){if(f instanceof Group3D){if(f instanceof TransformGroup3D){l=mat4.clone(l);var e=mat4.create();f.getTransform(e);mat4.mul(l,l,e)}var c=f.getChildren();for(var g=0;g<c.length;g++){this.computeBottomOrFrontArea(c[g],m,l,h,a)}}else{if(f instanceof Link3D){this.computeBottomOrFrontArea(f.getSharedGroup(),m,l,h,a)}else{if(f instanceof Shape3D){var j=f.getAppearance();if(j.isVisible()&&(!h||j.getTransparency()===undefined||j.getTransparency()<1)){var b=f.getGeometries();for(var g=0,d=b.length;g<d;g++){var k=b[g];this.computeBottomOrFrontGeometryArea(k,m,l,a)}}}}}};ModelManager.prototype.computeBottomOrFrontGeometryArea=function(c,l,k,b){if(c instanceof IndexedTriangleArray3D){var a=c.vertices.length;var h=new Array(a*2);var f=vec3.create();for(var g=0,e=0;g<h.length;e++){vec3.copy(f,c.vertices[e]);vec3.transformMat4(f,f,k);h[g++]=f[0];if(b){h[g++]=f[2]}else{h[g++]=f[1]}}geometryPath=new java.awt.geom.GeneralPath(java.awt.geom.Path2D.WIND_NON_ZERO,1000);for(var e=0,j=0,d=c.vertexIndices.length;e<d;e+=3){this.addTriangleToPath(c,c.vertexIndices[e],c.vertexIndices[e+1],c.vertexIndices[e+2],h,geometryPath,j++,l)}l.add(new java.awt.geom.Area(geometryPath))}};ModelManager.prototype.addTriangleToPath=function(b,l,j,h,d,c,e,g){var a=d[2*l];var k=d[2*l+1];var n=d[2*j];var i=d[2*j+1];var m=d[2*h];var f=d[2*h+1];if((n-a)*(f-i)-(i-k)*(m-n)>0){if(e>0&&e%1000===0){g.add(new java.awt.geom.Area(c));c.reset()}c.moveTo(a,k);c.lineTo(n,i);c.lineTo(m,f);c.closePath()}};ModelManager.prototype.computeVerticesOnFloor=function(g,p,q){if(g instanceof Group3D){if(g instanceof TransformGroup3D){q=mat4.clone(q);var f=mat4.create();g.getTransform(f);mat4.mul(q,q,f)}var d=g.getChildren();for(var k=0;k<d.length;k++){this.computeVerticesOnFloor(d[k],p,q)}}else{if(g instanceof Link3D){this.computeVerticesOnFloor(g.getSharedGroup(),p,q)}else{if(g instanceof Shape3D){var m=g.getAppearance();if(m.isVisible()&&(m.getTransparency()===undefined||m.getTransparency()<1)){var c=g.getGeometries();for(var k=0,e=c.length;k<e;k++){var b=c[k];var a=b.vertices.length;var l=vec3.create();for(var o=0,h=0;o<a;h++,o++){vec3.copy(l,b.vertices[h]);vec3.transformMat4(l,l,q);p.push([l[0],l[2]])}}}}}}};ModelManager.prototype.getSurroundingPolygon=function(k){k.sort(function(n,i){var o;if(n[0]===i[0]){o=i[1]-n[1]}else{o=i[0]-n[0]}if(o>0){return 1}else{if(o<0){return -1}else{return 0}}});var m=new Array(k.length);var b=0;var l=-1;var f;var a=0;var e;var c=k[0][0];for(f=1;f<k.length;f++){if(k[f][0]!==c){break}}e=f-1;if(e===k.length-1){m[++l]=k[a];if(k[e][1]!==k[a][1]){m[++l]=k[e]}m[++l]=k[a];var j=new Array(l+1);System.arraycopy(m,0,j,0,j.length);return j}var d;var h=k.length-1;var g=k[k.length-1][0];for(f=k.length-2;f>=0;f--){if(k[f][0]!==g){break}}d=f+1;m[++l]=k[a];f=e;while(++f<=d){if(this.isLeft(k[a],k[d],k[f])>=0&&f<d){continue}while(l>0){if(this.isLeft(m[l-1],m[l],k[f])>0){break}else{l--}}m[++l]=k[f]}if(h!==d){m[++l]=k[h]}b=l;f=d;while(--f>=e){if(this.isLeft(k[h],k[e],k[f])>=0&&f>e){continue}while(l>b){if(this.isLeft(m[l-1],m[l],k[f])>0){break}else{l--}}m[++l]=k[f]}if(e!==a){m[++l]=k[a]}var j=new Array(l+1);System.arraycopy(m,0,j,0,j.length);return j};ModelManager.prototype.isLeft=function(c,b,a){return(b[0]-c[0])*(a[1]-c[1])-(a[0]-c[0])*(b[1]-c[1])};ModelManager.prototype.getMirroredArea=function(c){var d=new java.awt.geom.GeneralPath();var a=[0,0,0,0,0,0];for(var b=c.getPathIterator(null);!b.isDone();b.next()){switch(b.currentSegment(a)){case java.awt.geom.PathIterator.SEG_MOVETO:d.moveTo(1-a[0],a[1]);break;case java.awt.geom.PathIterator.SEG_LINETO:d.lineTo(1-a[0],a[1]);break;case java.awt.geom.PathIterator.SEG_QUADTO:d.quadTo(1-a[0],a[1],1-a[2],a[3]);break;case java.awt.geom.PathIterator.SEG_CUBICTO:d.curveTo(1-a[0],a[1],1-a[2],a[3],1-a[4],a[5]);break;case java.awt.geom.PathIterator.SEG_CLOSE:d.closePath();break}}return new java.awt.geom.Area(d)};ModelManager.prototype.getShape=function(a){return ShapeTools.getShape(a)};function ModelPreviewComponent(f,g,d){if(d===undefined){d=false}this.canvas3D=new HTMLCanvas3D(f);this.pickedMaterial=null;this.setDefaultTransform();if(g){var e=0.02;var a=0.02;var c=this;var b={pointerTouches:{},boundedPitch:false,pickedTransformGroup:null,pivotCenterPixel:null,translationFromOrigin:null,translationToOrigin:null,modelBounds:null,mousePressed:function(i){b.mousePressedInCanvas=true;c.stopRotationAnimation();var h=c.getHTMLElement().getBoundingClientRect();b.updatePickedMaterial(i.clientX-h.left,i.clientY-h.top);i.stopPropagation()},windowMouseMoved:function(i){if(b.mousePressedInCanvas){var h=c.getHTMLElement().getBoundingClientRect();b.mouseDragged(i.clientX-h.left,i.clientY-h.top,i.altKey)}},windowMouseReleased:function(h){b.mousePressedInCanvas=false},pointerPressed:function(h){if(h.pointerType=="mouse"){b.mousePressed(h)}else{b.copyPointerToTargetTouches(h);b.touchStarted(h)}},pointerMousePressed:function(h){h.stopPropagation()},windowPointerMoved:function(h){if(h.pointerType=="mouse"){b.windowMouseMoved(h)}else{b.copyPointerToTargetTouches(h);b.touchMoved(h)}},windowPointerReleased:function(h){if(h.pointerType=="mouse"){b.windowMouseReleased(h)}else{delete b.pointerTouches[h.pointerId];b.touchEnded(h)}},touchStarted:function(i){i.preventDefault();if(i.targetTouches.length==1){b.mousePressedInCanvas=true;var h=c.getHTMLElement().getBoundingClientRect();b.updatePickedMaterial(i.targetTouches[0].clientX-h.left,i.targetTouches[0].clientY-h.top)}else{if(i.targetTouches.length==2){b.distanceLastPinch=b.distance(i.targetTouches[0].clientX,i.targetTouches[0].clientY,i.targetTouches[1].clientX,i.targetTouches[1].clientY)}}c.stopRotationAnimation()},touchMoved:function(j){j.preventDefault();if(j.targetTouches.length==1){var i=c.getHTMLElement().getBoundingClientRect();b.mouseDragged(j.targetTouches[0].clientX-i.left,j.targetTouches[0].clientY-i.top,false)}else{if(j.targetTouches.length==2){var h=b.distance(j.targetTouches[0].clientX,j.targetTouches[0].clientY,j.targetTouches[1].clientX,j.targetTouches[1].clientY);var k=b.distanceLastPinch/h;c.setViewScale(Math.max(0.5,Math.min(1.3,c.viewScale*k)));b.distanceLastPinch=h}}},touchEnded:function(h){b.mousePressedInCanvas=false},copyPointerToTargetTouches:function(i){b.pointerTouches[i.pointerId]={clientX:i.clientX,clientY:i.clientY};i.targetTouches=[];for(var h in b.pointerTouches){if(b.pointerTouches.hasOwnProperty(h)){i.targetTouches.push(b.pointerTouches[h])}}},distance:function(i,k,h,j){return Math.sqrt(Math.pow(h-i,2)+Math.pow(j-k,2))},mouseScrolled:function(h){h.preventDefault();b.zoomUpdater(h.detail)},mouseWheelMoved:function(h){h.preventDefault();b.zoomUpdater(h.deltaY!==undefined?h.deltaY/2:-h.wheelDelta/3)},visibilityChanged:function(h){if(document.visibilityState=="hidden"){c.stopRotationAnimation()}},updatePickedMaterial:function(t,s){b.xLastMove=t;b.yLastMove=s;b.pickedTransformGroup=null;b.pivotCenterPixel=null;b.boundedPitch=true;c.pickedMaterial=null;if(typeof HomeMaterial!=="undefined"&&c.getModelNode()!==null){var u=ModelManager.getInstance();if(d){b.boundedPitch=!u.containsDeformableNode(c.getModelNode())}var l=c.getHTMLElement().getBoundingClientRect();var m=c.canvas3D.getClosestShapeAt(t+l.left,s+l.top);if(m!==null){var n=u.getMaterials(m);if(n.length>0){c.pickedMaterial=n[0]}for(var C=m;(C=C.getParent())!==null;){if(C instanceof TransformGroup3D){b.pickedTransformGroup=C;break}}if(d&&b.pickedTransformGroup!=null){var r=b.pickedTransformGroup.getParent();var F=r.getChildren().indexOf(b.pickedTransformGroup)-1;while(F>=0&&(r.getChild(F) instanceof TransformGroup3D)){F--}if(F>=0){var w=r.getChild(F);var B=u.getCenter(w);var k=vec3.clone(B);var J=b.getTransformBetweenNodes(w.getParent(),c.canvas3D.getScene(),false);vec3.transformMat4(k,k,J);var z=c.canvas3D.getVirtualWorldToImageTransform(mat4.create());var v=c.canvas3D.getViewPlatformTransform(mat4.create());mat4.invert(v,v);mat4.mul(z,z,v);vec3.transformMat4(k,k,z);b.pivotCenterPixel=[(k[0]/2+0.5)*l.width,l.height*(0.5-k[1]/2)];var j=b.pickedTransformGroup.getName();b.translationFromOrigin=mat4.create();b.translationFromOrigin[12]=B[0];b.translationFromOrigin[13]=B[1];b.translationFromOrigin[14]=B[2];var G=mat4.create();mat4.fromXRotation(G,c.viewPitch);var E=mat4.create();mat4.fromYRotation(E,c.viewYaw);if(j.indexOf(ModelManager.HINGE_PREFIX)===0||j.indexOf(ModelManager.RAIL_PREFIX)===0){var D=mat4.create();var A=u.getSize(w);var p=b.getModelRoot(w);var q=b.getTransformBetweenNodes(p,c.getModelNode(),true);vec3.transformMat4(A,A,q);A[0]=Math.abs(A[0]);A[1]=Math.abs(A[1]);A[2]=Math.abs(A[2]);var I=mat4.clone(E);mat4.mul(I,I,G);mat4.invert(I,I);if(A[1]>A[0]&&A[1]>A[2]){var h=vec3.fromValues(0,1,0);vec3.transformMat4(h,h,I);if(j.indexOf(ModelManager.RAIL_PREFIX)===0?h[1]>0:h[2]<0){mat4.fromXRotation(D,Math.PI/2)}else{mat4.fromXRotation(D,-Math.PI/2)}}else{if(A[2]>A[0]&&A[2]>A[1]){var o=vec3.fromValues(0,0,1);vec3.transformMat4(o,o,I);if(j.indexOf(ModelManager.RAIL_PREFIX)===0?o[0]>0:o[2]<0){mat4.fromXRotation(D,Math.PI)}}else{var H=vec3.fromValues(1,0,0);vec3.transformMat4(H,H,I);if(j.indexOf(ModelManager.RAIL_PREFIX)===0?H[0]>0:H[2]<0){mat4.fromYRotation(D,-Math.PI/2)}else{mat4.fromYRotation(D,Math.PI/2)}}}mat4.invert(q,q);mat4.mul(b.translationFromOrigin,b.translationFromOrigin,q);mat4.mul(b.translationFromOrigin,b.translationFromOrigin,D)}else{mat4.mul(b.translationFromOrigin,b.translationFromOrigin,mat4.invert(mat4.create(),b.getTransformBetweenNodes(w.getParent(),c.getModelNode(),true)));mat4.mul(b.translationFromOrigin,b.translationFromOrigin,E);mat4.mul(b.translationFromOrigin,b.translationFromOrigin,G)}b.translationToOrigin=mat4.invert(mat4.create(),b.translationFromOrigin);b.modelBounds=u.getBounds(c.getModelNode())}}}}},getTransformBetweenNodes:function(k,j,l){var i=mat4.create();if(k instanceof TransformGroup3D){k.getTransform(i);if(l){i[12]=0;i[13]=0;i[14]=0}}if(k!==j){var h=k.getParent();if(h instanceof Group3D){mat4.mul(i,b.getTransformBetweenNodes(h,j,l),i)}else{throw new IllegalStateException("Can't retrieve node transform")}}return i},getModelRoot:function(h){if(h instanceof Group3D&&h.getUserData() instanceof URLContent){return h}else{if(h.getParent()!=null){return b.getModelRoot(h.getParent())}else{return null}}},mouseDragged:function(q,n,m){if(c.getModelNode()!==null){if(b.pivotCenterPixel!==null){var h=b.pickedTransformGroup.getName();var B=mat4.create();if(h.indexOf(ModelManager.RAIL_PREFIX)===0){mat4.translate(B,B,vec3.fromValues(0,0,b.distance(q,n,b.xLastMove,b.yLastMove)*(b.xLastMove-q<0?-1:(b.xLastMove-q===0?0:1))))}else{var z=Math.atan2(b.pivotCenterPixel[1]-n,q-b.pivotCenterPixel[0])-Math.atan2(b.pivotCenterPixel[1]-b.yLastMove,b.xLastMove-b.pivotCenterPixel[0]);mat4.fromZRotation(B,z)}mat4.mul(B,B,b.translationToOrigin);mat4.mul(B,b.translationFromOrigin,B);var k=mat4.create();b.pickedTransformGroup.getTransform(k);mat4.mul(k,B,k);b.pickedTransformGroup.setTransform(k);var A=vec3.create();b.modelBounds.getLower(A);var u=vec3.create();b.modelBounds.getUpper(u);var s=ModelManager.getInstance();var o=s.getBounds(c.getModelNode());var v=vec3.create();o.getLower(v);var t=vec3.create();o.getUpper(t);var r=c.previewedPiece;r.setX(r.getX()+(t[0]+v[0])/2-(u[0]+A[0])/2);r.setY(r.getY()+(t[2]+v[2])/2-(u[2]+A[2])/2);r.setElevation(r.getElevation()+(v[1]-A[1]));r.setWidth(t[0]-v[0]);r.setDepth(t[2]-v[2]);r.setHeight(t[1]-v[1]);b.modelBounds=o;var j=c.previewedPiece.getModelTransformations();var l=[];if(j!==null){l.push.apply(l,j)}h=h.substring(0,h.length-ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX.length);for(var w=0;w<l.length;w++){if(h==l[w].getName()){l.splice(w,1);break}}l.push(new Transformation(h,[[k[0],k[4],k[8],k[12]],[k[1],k[5],k[9],k[13]],[k[2],k[6],k[10],k[14]]]));c.previewedPiece.setModelTransformations(l)}else{if(!m){c.setViewYaw(c.viewYaw-e*(q-b.xLastMove))}if(g&&m){b.zoomUpdater(n-b.yLastMove)}else{if(g&&!m){var p=c.viewPitch-e*(n-b.yLastMove);if(b.boundedPitch){c.setViewPitch(Math.max(-Math.PI/4,Math.min(0,p)))}else{c.setViewPitch(p)}}}}}b.xLastMove=q;b.yLastMove=n},zoomUpdater:function(h){c.setViewScale(Math.max(0.5,Math.min(1.3,c.viewScale*Math.exp(h*a))));c.stopRotationAnimation()}};if(OperatingSystem.isInternetExplorerOrLegacyEdge()&&window.PointerEvent){this.canvas3D.getHTMLElement().addEventListener("pointerdown",b.pointerPressed);this.canvas3D.getHTMLElement().addEventListener("mousedown",b.pointerMousePressed);window.addEventListener("pointermove",b.windowPointerMoved);window.addEventListener("pointerup",b.windowPointerReleased)}else{this.canvas3D.getHTMLElement().addEventListener("touchstart",b.touchStarted);this.canvas3D.getHTMLElement().addEventListener("touchmove",b.touchMoved);this.canvas3D.getHTMLElement().addEventListener("touchend",b.touchEnded);this.canvas3D.getHTMLElement().addEventListener("mousedown",b.mousePressed);window.addEventListener("mousemove",b.windowMouseMoved);window.addEventListener("mouseup",b.windowMouseReleased)}this.canvas3D.getHTMLElement().addEventListener("DOMMouseScroll",b.mouseScrolled);this.canvas3D.getHTMLElement().addEventListener("mousewheel",b.mouseWheelMoved);document.addEventListener("visibilitychange",b.visibilityChanged);this.userActionsListener=b}}ModelPreviewComponent.prototype.getHTMLElement=function(){return this.canvas3D.getHTMLElement()};ModelPreviewComponent.prototype.setDefaultTransform=function(){this.viewYaw=Math.PI/8;this.viewPitch=-Math.PI/16;this.viewScale=1;this.updateViewPlatformTransform()};ModelPreviewComponent.prototype.getViewYaw=function(){return this.viewYaw};ModelPreviewComponent.prototype.setViewYaw=function(a){this.viewYaw=a;this.updateViewPlatformTransform()};ModelPreviewComponent.prototype.getViewScale=function(){return this.viewScale};ModelPreviewComponent.prototype.setViewScale=function(a){this.viewScale=a;this.updateViewPlatformTransform()};ModelPreviewComponent.prototype.getViewPitch=function(){return this.viewPitch};ModelPreviewComponent.prototype.setViewPitch=function(a){this.viewPitch=a;this.updateViewPlatformTransform()};ModelPreviewComponent.prototype.updateViewPlatformTransform=function(){var b=1.4/Math.tan(Math.PI/8);var e=mat4.create();mat4.translate(e,e,vec3.fromValues(0,0,b));var a=mat4.create();mat4.rotateX(a,a,this.viewPitch);var d=mat4.create();mat4.rotateY(d,d,this.viewYaw);var c=mat4.create();mat4.scale(c,c,vec3.fromValues(this.viewScale,this.viewScale,this.viewScale));mat4.mul(a,a,e);mat4.mul(d,d,a);mat4.mul(c,c,d);this.canvas3D.setViewPlatformTransform(c)};ModelPreviewComponent.prototype.setModel=function(d,f,b,a,c,i,h,g){if(c===undefined&&i===undefined&&h===undefined&&g===undefined){g=a;h=b;b=f;f=0;a=-1;c=-1;i=-1}this.model=d;this.canvas3D.clear();if(typeof HomePieceOfFurniture!=="undefined"){this.previewedPiece=null}if(d!==null){var e=this;ModelManager.getInstance().loadModel(d,{modelUpdated:function(q){if(d===e.model){var j=ModelManager.getInstance();var l=a<0?j.getSize(q):vec3.fromValues(a,i,c);var n=1.8/Math.max(Math.max(l[0],l[2]),l[1]);var k;if(typeof HomePieceOfFurniture!=="undefined"){if(typeof f==="boolean"){f=f?PieceOfFurniture.SHOW_BACK_FACE:0}e.previewedPiece=new HomePieceOfFurniture(new CatalogPieceOfFurniture(null,null,d,l[0],l[2],l[1],0,false,null,null,b,f,null,null,0,0,1,false));e.previewedPiece.setX(0);e.previewedPiece.setY(0);e.previewedPiece.setElevation(-e.previewedPiece.getHeight()/2);var m=mat4.create();mat4.scale(m,m,vec3.fromValues(n,n,n));k=new TransformGroup3D(m);var p=new HomePieceOfFurniture3D(e.previewedPiece,null,true);k.addChild(p)}else{var m=b?j.getRotationTransformation(b):mat4.create();mat4.scale(m,m,vec3.fromValues(n,n,n));mat4.scale(m,m,l);mat4.mul(m,m,j.getNormalizedTransform(q,null,1));k=new TransformGroup3D(m);k.addChild(q)}var o=new BranchGroup3D();o.addChild(k);o.addChild(new DirectionalLight3D(vec3.fromValues(0.9,0.9,0.9),vec3.fromValues(1.732,-0.8,-1)));o.addChild(new DirectionalLight3D(vec3.fromValues(0.9,0.9,0.9),vec3.fromValues(-1.732,-0.8,-1)));o.addChild(new DirectionalLight3D(vec3.fromValues(0.9,0.9,0.9),vec3.fromValues(0,-0.8,1)));o.addChild(new DirectionalLight3D(vec3.fromValues(0.66,0.66,0.66),vec3.fromValues(0,1,0)));o.addChild(new AmbientLight3D(vec3.fromValues(0.2,0.2,0.2)));e.setDefaultTransform();e.canvas3D.setScene(o,g);e.canvas3D.updateViewportSize()}},modelError:function(j){if(d===e.model&&h!==undefined){h(j)}},progression:function(k,l,j){if(d===e.model&&g!==undefined){g(k,l,j)}}})}};ModelPreviewComponent.prototype.getModelNode=function(){var a=this.canvas3D.getScene().getChild(0);if(a.getChildren().length>0){return a.getChild(0)}else{return null}};ModelPreviewComponent.prototype.setModelMaterials=function(a){if(this.previewedPiece!=null){this.previewedPiece.setModelMaterials(a);this.getModelNode().update()}};ModelPreviewComponent.prototype.setModelTransformations=function(a){if(this.previewedPiece!=null){this.previewedPiece.setModelTransformations(a);this.getModelNode().update()}};ModelPreviewComponent.prototype.setPresetModelTransformations=function(c){if(this.previewedPiece!=null){var a=ModelManager.getInstance();var e=a.getBounds(this.getModelNode());var h=vec3.create();e.getLower(h);var b=vec3.create();e.getUpper(b);this.setNodeTransformations(this.getModelNode(),c);var g=a.getBounds(this.getModelNode());var d=vec3.create();g.getLower(d);var f=vec3.create();g.getUpper(f);this.previewedPiece.setX(this.previewedPiece.getX()+(f[0]+d[0])/2-(b[0]+h[0])/2);this.previewedPiece.setY(this.previewedPiece.getY()+(f[2]+d[2])/2-(b[2]+h[2])/2);this.previewedPiece.setElevation(this.previewedPiece.getElevation()+(d[1]-h[1]));this.previewedPiece.setWidth(f[0]-d[0]);this.previewedPiece.setDepth(f[2]-d[2]);this.previewedPiece.setHeight(f[1]-d[1]);this.previewedPiece.setModelTransformations(c)}};ModelPreviewComponent.prototype.resetModelTransformations=function(){this.setPresetModelTransformations(null)};ModelPreviewComponent.prototype.setNodeTransformations=function(g,c){if(g instanceof Group3D){if(g instanceof TransformGroup3D&&g.getName()!==null&&g.getName().lastIndexOf(ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX)===g.getName().length-ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX.length){g.setTransform(mat4.create());if(c!=null){var h=g.getName();h=h.substring(0,h.length-ModelManager.DEFORMABLE_TRANSFORM_GROUP_SUFFIX.length);for(var e=0;e<c.length;e++){var f=c[e];if(h==f.getName()){var a=f.getMatrix();var b=mat4.create();mat4.set(b,a[0][0],a[1][0],a[2][0],0,a[0][1],a[1][1],a[2][1],0,a[0][2],a[1][2],a[2][2],0,a[0][3],a[1][3],a[2][3],1);g.setTransform(b)}}}}var d=g.getChildren();for(var e=0;e<d.length;e++){this.setNodeTransformations(d[e],c)}}};ModelPreviewComponent.prototype.getModelTransformations=function(){if(this.previewedPiece!=null){return this.previewedPiece.getModelTransformations()}else{return null}};ModelPreviewComponent.prototype.getModelX=function(){return this.previewedPiece.getX()};ModelPreviewComponent.prototype.getModelY=function(){return this.previewedPiece.getY()};ModelPreviewComponent.prototype.getModelElevation=function(){return this.previewedPiece.getElevation()};ModelPreviewComponent.prototype.getModelWidth=function(){return this.previewedPiece.getWidth()};ModelPreviewComponent.prototype.getModelDepth=function(){return this.previewedPiece.getDepth()};ModelPreviewComponent.prototype.getModelHeight=function(){return this.previewedPiece.getHeight()};ModelPreviewComponent.prototype.getPickedMaterial=function(){return this.pickedMaterial};ModelPreviewComponent.prototype.clear=function(){this.stopRotationAnimation();this.canvas3D.clear()};ModelPreviewComponent.prototype.dispose=function(){if(OperatingSystem.isInternetExplorerOrLegacyEdge()&&window.PointerEvent){window.removeEventListener("pointermove",this.userActionsListener.windowPointerMoved);window.removeEventListener("pointerup",this.userActionsListener.windowPointerReleased)}else{window.removeEventListener("mousemove",this.userActionsListener.windowMouseMoved);window.removeEventListener("mouseup",this.userActionsListener.windowMouseReleased)}document.removeEventListener("visibilitychange",this.userActionsListener.visibilityChanged);this.clear()};ModelPreviewComponent.prototype.startRotationAnimation=function(a){this.roundsPerMinute=a!==undefined?a:5;if(!this.rotationAnimationStarted){this.rotationAnimationStarted=true;this.animate()}};ModelPreviewComponent.prototype.animate=function(){if(this.rotationAnimationStarted){var b=Date.now();if(this.lastRotationAnimationTime!==undefined){var a=this.roundsPerMinute*2*Math.PI/60000;this.viewYaw+=((b-this.lastRotationAnimationTime)*a)%(2*Math.PI);this.updateViewPlatformTransform()}this.lastRotationAnimationTime=b;var c=this;requestAnimationFrame(function(){c.animate()})}};ModelPreviewComponent.prototype.stopRotationAnimation=function(){delete this.lastRotationAnimationTime;delete this.rotationAnimationStarted};function viewModelInOverlay(s,e){var t=window.innerWidth;var j=window.innerHeight;var r=document.documentElement.clientWidth;var i=document.documentElement.clientHeight;var m=document.getElementsByTagName("body").item(0);if(m&&m.scrollWidth){if(m.scrollWidth>r){r=m.scrollWidth}if(m.scrollHeight>i){i=m.scrollHeight}}var d=window.pageXOffset?window.pageXOffset:0;var c=window.pageYOffset?window.pageYOffset:0;var f=document.getElementById("canvas3D");if(!f){createModel3DOverlay();f=document.getElementById("canvas3D")}var n=document.getElementById("modelViewerOverlay");n.style.height=Math.max(i,j)+"px";n.style.width=r<=t?"100%":r+"px";n.style.display="block";var b=Math.min(800,t,j);b*=0.9;f.width=b;f.style.width=f.width+"px";f.height=b;f.style.height=f.height+"px";var o=d+(t-b-10)/2;f.style.left=o+"px";var p=c+(j-b-10)/2;f.style.top=p+"px";var h=document.getElementById("modelViewerCloseButton");h.style.left=(o+b-5)+"px";h.style.top=(p-10)+"px";var g=document.getElementById("modelViewerProgressDiv");g.style.left=(o+(b-300)/2)+"px";g.style.top=(p+(b-50)/2)+"px";g.style.visibility="visible";document.getElementById("modelViewerProgress").value=0;try{if(f.modelPreviewComponent===undefined){f.modelPreviewComponent=new ModelPreviewComponent("canvas3D",true)}var l=f.modelPreviewComponent;var k=null;if(e){var a=e.split(/\s+/);k=[[parseFloat(a[0]),parseFloat(a[1]),parseFloat(a[2])],[parseFloat(a[3]),parseFloat(a[4]),parseFloat(a[5])],[parseFloat(a[6]),parseFloat(a[7]),parseFloat(a[8])]]}l.setModel(new URLContent(s),k,function(u){console.log(u);alert(u)},function(x,y,v){var w=document.getElementById("modelViewerProgress");if(x===ModelLoader.READING_MODEL){w.value=v*100;y=y.substring(y.lastIndexOf("/")+1)}else{if(x===ModelLoader.PARSING_MODEL){w.value=210+v*100}else{if(x===ModelLoader.BUILDING_MODEL){w.value=310+v*100}else{if(x===ModelLoader.BINDING_MODEL){w.value=410+v*50}}}}var u=document.getElementById("modelViewerProgressLabel");if(x===ModelLoader.BUILDING_MODEL&&v===1){u.innerHTML="Preparing display..."}else{u.innerHTML=(v?Math.floor(v*100)+"% ":"")+x+" "+y}if(x===ModelLoader.BINDING_MODEL&&v===1){document.getElementById("modelViewerProgressDiv").style.visibility="hidden";l.startRotationAnimation()}})}catch(q){hideModel3DOverlay();if(q=="No WebGL"){alert("Sorry, your browser doesn't support WebGL.")}else{alert("Error: "+q)}}}function createModel3DOverlay(){var e=document.createElement("div");e.setAttribute("id","modelViewerOverlay");e.style.display="none";e.style.position="absolute";e.style.left="0";e.style.top="0";e.style.zIndex="100";e.style.background="rgba(127, 127, 127, .5)";var d=document.getElementsByTagName("body").item(0);d.insertBefore(e,d.firstChild);var f=document.createElement("div");f.innerHTML='<canvas id="canvas3D" style="background-color: #CCCCCC; border: 1px solid gray; position: absolute; touch-action: none"></canvas><div id="modelViewerProgressDiv" style="position:absolute; width: 300px;">  <progress id="modelViewerProgress" value="0" max="460" style="width: 300px;"></progress>  <label id="modelViewerProgressLabel" style="margin-top: 2px; font-family: Sans-serif; margin-left: 10px; margin-right: 0px; display: block;"></label></div>';var a=new Image();a.src=ZIPTools.getScriptFolder()+"close.png";a.id="modelViewerCloseButton";a.style.position="absolute";e.appendChild(f);e.appendChild(a);var b=function(g){hideModel3DOverlay("canvas3D")};document.addEventListener("keydown",function(g){if(g.keyCode===27){b()}});a.addEventListener("click",b);var c={mousePressed:function(g){c.mousePressedInCanvas=true},mouseClicked:function(g){if(c.mousePressedInCanvas){delete c.mousePressedInCanvas;b()}}};e.addEventListener("mousedown",c.mousePressed);e.addEventListener("click",c.mouseClicked);e.addEventListener("touchmove",function(g){g.preventDefault()})}function hideModel3DOverlay(){document.getElementById("modelViewerOverlay").style.display="none";var a=document.getElementById("canvas3D").modelPreviewComponent;if(a){a.clear();ModelManager.getInstance().clear();ZIPTools.clear()}}function bindAnchorsToModel3DViewer(e){var d=document.getElementsByTagName("a");for(var c=0;c<d.length;c++){var b=d[c];var a=b.getAttribute("href");if(a!==null&&a.match(e)){b.onclick=function(){viewModelInOverlay(this.getAttribute("href"),this.getAttribute("data-model-rotation"));return false}}}};